<?php $__env->startSection('title'); ?>
Student Dashboard
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- =======================
Page Banner START -->
<?php
    $user = findUser();
    $enrolled_course_count = getEnrolledCourses()->get();
?>
<?php echo $__env->make('frontend.student.include.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<!-- =======================
Page Banner END -->

<!-- =======================
Page content START -->
<section class="pt-0">
	<div class="container">
        <div class="row">
            <div class="col-xl-12">
                <?php if(isset($notice)): ?>
                <marquee behavior="" direction="" class="text-danger my-2" style="font-size: 18px"><a href="<?php echo e(route('student.notice')); ?>">***<?php echo e($notice->notice_title); ?>***</a></marquee>
                <?php endif; ?>
            </div>
        </div>
		<div class="row">

			<?php echo $__env->make('frontend.student.include.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

			<!-- Main content START -->
			<div class="col-xl-9">

				<!-- Counter boxes START -->
				<div class="row mb-4">
					<!-- Counter item -->
					<div class="col-sm-6 col-lg-4 mb-3 mb-lg-0">
						<div class="d-flex justify-content-center align-items-center p-4 bg-orange bg-opacity-15 rounded-3">
							<span class="display-6 lh-1 text-orange mb-0"><i class="fas fa-tv fa-fw"></i></span>
							<div class="ms-4">
								<div class="d-flex">
									<h5 class="purecounter mb-0 fw-bold" data-purecounter-start="0" data-purecounter-end="9" data-purecounter-delay="200"><?php echo e(count($courses)); ?></h5>
								</div>
								<p class="mb-0 h6 fw-light">Total Courses</p>
							</div>
						</div>
					</div>
					<!-- Counter item -->
					<div class="col-sm-6 col-lg-4 mb-3 mb-lg-0">
						<div class="d-flex justify-content-center align-items-center p-4 bg-purple bg-opacity-15 rounded-3">
							<span class="display-6 lh-1 text-purple mb-0"><i class="fas fa-clipboard-check fa-fw"></i></span>
							<div class="ms-4">
								<div class="d-flex">
									<h5 class="purecounter mb-0 fw-bold" data-purecounter-start="0" data-purecounter-end="52" data-purecounter-delay="200"><?php echo e(count($enrolled_courses)); ?></h5>
								</div>
								<p class="mb-0 h6 fw-light">Enrolled Courses</p>
							</div>
						</div>
					</div>
					<!-- Counter item -->
					<div class="col-sm-6 col-lg-4 mb-3 mb-lg-0">
						<div class="d-flex justify-content-center align-items-center p-4 bg-success bg-opacity-10 rounded-3">
							<span class="display-6 lh-1 text-success mb-0"><i class="fas fa-medal fa-fw"></i></span>
							<div class="ms-4">
								<div class="d-flex">
									<h5 class="purecounter mb-0 fw-bold" data-purecounter-start="0" data-purecounter-end="8" data-purecounter-delay="300">0</h5>
								</div>
								<p class="mb-0 h6 fw-light">Achieved Certificates</p>
							</div>
						</div>
					</div>
				</div>
				<!-- Counter boxes END -->

				<div class="card bg-transparent border rounded-3">
					<!-- Card header START -->
					<div class="card-header bg-transparent border-bottom">
						<h3 class="mb-0">Today's Classes</h3>
					</div>
					<!-- Card header END -->

					<!-- Card body START -->
					<div class="card-body">


						<!-- Course list table START -->
						<div class="table-responsive border-0">
							<table class="table table-dark-gray align-middle p-4 mb-0 table-hover">
								<!-- Table head -->
								<thead>
									<tr>
										<th scope="col" class="border-0 rounded-start">Course Title</th>

										<th scope="col" class="border-0">Time</th>
										<th scope="col" class="border-0 rounded-end"></th>
									</tr>
								</thead>

								<!-- Table body START -->
                                <?php
                                    $j = 0;
                                ?>
								<tbody>
                                    <?php if(count($todays_classes) >0): ?>
                                    <?php $__currentLoopData = $todays_classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $content = getCourseContent($item->id);
                                        $completion_percent = 100;
                                        if($item->total_content > 0){
                                            $completion_percent = ($item->completed_content/$item->total_content)*100;
                                        }

                                    ?>
                                    <?php if($item->status == 1): ?>
                                        <?php
                                            $j++;
                                        ?>
                                        <tr>
                                            <!-- Table data -->
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <!-- Image -->
                                                    <div class="w-100px">
                                                        <img src="<?php echo e(asset($item->course->image)); ?>" class="rounded" alt="">
                                                    </div>
                                                    <div class="mb-0 ms-2">
                                                        <!-- Title -->
                                                        <h6><a href="<?php echo e(route('course.details', $item->course_id)); ?>"><?php echo e($item->course->course_name ?? ''); ?></a></h6>
                                                        <!-- Info -->
                                                        <div class="overflow-hidden">
                                                            
                                                        </div>
                                                    </div>
                                                </div>
                                            </td>
                                            <!-- Table data -->
                                            <td><?php echo e($item->batch->time); ?></td>

                                            <!-- Table data -->
                                            

                                            <!-- Table data -->
                                            <td>
                                                <a href="<?php echo e($item->link); ?>" class="btn btn-sm btn-primary-soft me-1 mb-1 mb-md-0">Join</a>
                                            </td>
                                        </tr>
                                    <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php elseif(count($enrolled_courses) == 0 || $j == 0): ?>
                                        <tr>
                                            <td colspan="4" class="text-center">No Classes Today</td>
                                        </tr>
                                    <?php endif; ?>

									<!-- Table item -->

								</tbody>
								<!-- Table body END -->
							</table>
                            <?php echo e($enrolled_courses->links('pagination::bootstrap-5')); ?>

						</div>
						<!-- Course list table END -->


					</div>
					<!-- Card body START -->
				</div>
				<div class="card bg-transparent border rounded-3 mt-4">
					<!-- Card header START -->
					<div class="card-header bg-transparent border-bottom">
						<h3 class="mb-0">My Courses List</h3>
					</div>
					<!-- Card header END -->

					<!-- Card body START -->
					<div class="card-body">


						<!-- Course list table START -->
						<div class="table-responsive border-0">
							<table class="table table-dark-gray align-middle p-4 mb-0 table-hover">
								<!-- Table head -->
								<thead>
									<tr>
										<th scope="col" class="border-0 rounded-start">Course Title</th>
										<th scope="col" class="border-0 rounded-">Branch</th>
										<th scope="col" class="border-0 rounded-">Batch</th>
										<th scope="col" class="border-0">Enrolled In</th>
										<th scope="col" class="border-0">Total Lectures</th>
										<th scope="col" class="border-0 ">Status</th>
										<th scope="col" class="border-0 rounded-end">Action</th>
									</tr>
								</thead>

								<!-- Table body START -->
                                <?php
                                    $j = 0;
                                ?>
								<tbody>
                                    <?php if(count($enrolled_courses) >0): ?>
                                    <?php $__currentLoopData = $enrolled_courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $content = getCourseContent($item->id);
                                        $completion_percent = 100;
                                        if($item->total_content > 0){
                                            $completion_percent = ($item->completed_content/$item->total_content)*100;
                                        }

                                    ?>
                                    <?php if($item->status == 1): ?>
                                        <?php
                                            $j++;
                                        ?>
                                        <tr>
                                            <!-- Table data -->
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <!-- Image -->
                                                    <div class="w-100px">
                                                        <img src="<?php echo e(asset($item->course->image)); ?>" class="rounded" alt="">
                                                    </div>
                                                    <div class="mb-0 ms-2">
                                                        <!-- Title -->
                                                        <h6><a href="<?php echo e(route('course.details', $item->course->slug)); ?>"><?php echo e($item->course->course_name ?? ''); ?></a></h6>
                                                        <!-- Info -->
                                                        <div class="overflow-hidden">
                                                            
                                                        </div>
                                                    </div>
                                                </div>
                                            </td>
                                            <td><?php echo e($item->branch->branch_name ?? 'No Branch Found'); ?></td>
                                            <td><?php echo e($item->batch->batch_name ?? ''); ?></td>
                                            <td><?php echo e(date('Y-m-d', strtotime($item->created_at))); ?></td>
                                            <!-- Table data -->
                                            <td><?php echo e($item->course->total_lectures); ?></td>

                                            <!-- Table data -->
                                            

                                            <!-- Table data -->
                                            <td>
                                                <?php if($item->status == 1): ?>
                                                <button class="btn btn-sm btn-success-soft me-1 mb-1 mb-md-0"><i class="bi bi-play-circle me-1"></i>OnGoing</button>
                                                <?php elseif($item->status == 0): ?>
                                                <a href="#" class="btn btn-sm btn-primary-soft me-1 mb-1 mb-md-0"></i>Pending</a>
                                                <?php endif; ?>
                                            </td>
                                            <td class="">
                                                <?php
                                                    $student = \App\Models\Student::where('user_id', Auth::user()->id)->first();
                                                    $testimonial = \App\Models\Testimonial::where('student_id', $student->id)->where('course_id', $item->course_id)->get();
                                                ?>
                                                <div class="d-flex">
                                                    <a href="<?php echo e(route('student.curriculum', $item->course->slug)); ?>" class="btn btn-sm btn-primary me-1 mb-1 mb-md-0" title="View Curriculum"><i class="bi bi-list-task me-1"></i></a>
                                                    <a href="<?php echo e(route('student.course.review', $item->course->slug)); ?>" class="btn btn-sm ms-2 me-1 mb-1 mb-md-0" title="Review Course" style="background-color: #A70000; color:white;"><i class="bi bi-tag"></i></a>

                                                </div>


                                            </td>                                        </tr>
                                    <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php elseif(count($enrolled_courses) == 0 || $j == 0): ?>
                                        <tr>
                                            <td colspan="4" class="text-center">No Course Enrolled</td>
                                        </tr>
                                    <?php endif; ?>

									<!-- Table item -->

								</tbody>
								<!-- Table body END -->
							</table>
                            <?php echo e($enrolled_courses->links('pagination::bootstrap-5')); ?>

						</div>
						<!-- Course list table END -->


					</div>
					<!-- Card body START -->
				</div>
			<!-- Main content END -->
			</div><!-- Row END -->
		</div>
	</div>
</section>
<!-- =======================
Page content END -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\laravel projects\git projects\learning_management_system\resources\views/frontend/student/dashboard.blade.php ENDPATH**/ ?>