<?php $__env->startSection('title'); ?>
Profile Edit
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- =======================
Page Banner START -->
<?php
    $user = findUser();
    $enrolled_course_count = getEnrolledCourses()->get();
?>
<?php echo $__env->make('frontend.student.include.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<!-- =======================
Page Banner END -->

<!-- =======================
Page content START -->
<section class="pt-0">
	<div class="container">
		<div class="row">

			<?php echo $__env->make('frontend.student.include.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

			<div class="col-xl-9">
				<!-- Edit profile START -->
				<div class="card bg-transparent border rounded-3">
					<!-- Card header -->
					<div class="card-header bg-transparent border-bottom">
						<h3 class="card-header-title mb-0">Edit Profile</h3>
                        <?php if($errors->any()): ?>
    <div class="alert alert-danger">
        <ul>
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
<?php endif; ?>
					</div>
					<!-- Card body START -->
					<div class="card-body">
						<!-- Form -->
						<form class="row g-4" action="<?php echo e(route('student.profile.update')); ?>" method="POST" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="id" value="<?php echo e($item->id); ?>">
                            <input type="hidden" name="password" value="<?php echo e($item->password); ?>">
							<!-- Profile picture -->
							<div class="col-12 justify-content-center align-items-center">
								<label class="form-label">Profile Picture</label>
								<div class="d-flex align-items-center">
									<label class="position-relative me-4" for="uploadfile-1" title="Replace this pic">
										<!-- Avatar place holder -->


										<?php if($item->student_image == Null): ?>
                                        <span class="avatar avatar-xl">
											<img id="uploadfile-1-preview" class="avatar-img rounded-circle border border-white border-3 shadow" src=" <?php echo e(asset('admin-assets')); ?>/images/default.jpg" alt="">
										</span>
                                        <?php else: ?>
                                        <span class="avatar avatar-xl">
											<img id="uploadfile-1-preview" class="avatar-img rounded-circle border border-white border-3 shadow" src="<?php echo e(asset($item->student_image)); ?>" alt="">
										</span>
                                        <?php endif; ?>
										<!-- Remove btn -->
										
									</label>
									<!-- Upload button -->
									<label class="btn btn-primary-soft mb-0" for="uploadfile-1">Change</label>
									<input id="uploadfile-1" name="student_image" class="form-control d-none" type="file" accept="image/*" onchange="readURL(this)">
                                    <?php $__errorArgs = ['student_image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback" role="alert"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
								</div>
							</div>

							<!-- Full name -->
							<div class="col-12">
								<label class="form-label">Full Name<span style="color:red">*</span></label>
								<div class="input-group">
									<input type="text" name="student_name" class="form-control <?php $__errorArgs = ['student_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"  placeholder="Full Name" value="<?php echo e($item->student_name); ?>" required>
                                    <?php $__errorArgs = ['student_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback" role="alert"><?php echo e($messsage); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

								</div>
							</div>

							<!-- Username -->
							<div class="col-md-6">
								<label class="form-label">Father's Name</label>
								<div class="input-group">

									<input type="text" name="father_name" class="form-control <?php $__errorArgs = ['father_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e($item->father_name); ?>">
                                   
								</div>
							</div>
                            <!-- Location -->
							<div class="col-md-6">
								<label class="form-label">Mother's Name</label>
								<input name="mother_name" class="form-control <?php $__errorArgs = ['mother_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" type="text" value="<?php echo e($item->mother_name); ?>">
                                
							</div>

							<!-- Email id -->
							<div class="col-md-6">
								<label class="form-label">Email Address<span style="color:red">*</span></label>
								<input name="student_email" class="form-control <?php $__errorArgs = ['student_email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" type="email" value="<?php echo e($item->student_email); ?>" placeholder="Email">
                                <?php $__errorArgs = ['student_email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback" role="alert"><?php echo e($messsage); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
							</div>

							<!-- Phone number -->
							<div class="col-md-6">
								<label class="form-label">Phone Number<span style="color:red">*</span></label>
								<input type="text" name="student_phone" class="form-control <?php $__errorArgs = ['student_phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e($item->student_phone); ?>" placeholder="Phone number" required>
                                <?php $__errorArgs = ['student_phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback" role="alert"><?php echo e($messsage); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
							</div>



							<!-- Save button -->
							<div class="d-sm-flex justify-content-end">
								<button type="submit" class="btn btn-primary mb-0">Save changes</button>
							</div>
						</form>
					</div>
					<!-- Card body END -->
				</div>
				<!-- Edit profile END -->

				<div class="row g-4 mt-3">



                    <form action="<?php echo e(route('student.password.update')); ?>" id='passwordChangeForm'  method="POST">
                        <?php echo csrf_field(); ?>
                        <div class="col-xl-9">
                            <div class="card border bg-transparent rounded-3">
                                <!-- Card header -->
                                <div class="card-header bg-transparent border-bottom">
                                    <h5 class="card-header-title mb-0">Update Password</h5>
                                </div>
                                <!-- Card body START -->
                                <div class="card-body">
                                    <!-- Current password -->
                                    <div class="mb-3">
                                        <label class="form-label">Current Password</label>
                                        <input class="form-control" id="current_password"  type="password" placeholder="Enter Current Password">
                                        <div > <span id="password_error" class="text-danger"></span></div>
                                    </div>
                                    <!-- New password -->
                                    <div class="mb-3">
                                        <label class="form-label"> Enter New Password</label>
                                        <div class="input-group">
                                            <input name="password" class="form-control" type="password" placeholder="Enter New Password">
                                            
                                        </div>
                                        <div class="rounded mt-1" id="psw-strength"></div>
                                    </div>
                                    <!-- Confirm password -->
                                    <div>
                                        <label class="form-label">Confirm New Password</label>
                                        <input name="password_confirmation" class="form-control" type="password" placeholder="Enter New Password">
                                    </div>
                                    <!-- Button -->
                                    <div class="d-flex justify-content-end mt-4">
                                        <button type="submit" onclick="return checkPassword()"   class="btn btn-primary mb-0">Change password</button>
                                    </div>
                                </div>
                                <!-- Card body END -->
                            </div>
                        </div>
                    </form>
					<!-- Password change START -->

					<!-- Password change end -->
				</div>
			</div>
		</div>
	</div>
</section>
<!-- =======================
Page content END -->
<?php $__env->stopSection(); ?>
<?php $__env->startPush('js'); ?>
<script>
    function readURL(input) {
    if (input.files && input.files[0]) {

        var reader = new FileReader();
        reader.onload = function (e) {
            document.querySelector("#uploadfile-1-preview").setAttribute("src",e.target.result);
        };

        reader.readAsDataURL(input.files[0]);
    }
}
</script>
<script>
    function checkPassword(){
        event.preventDefault();
        var password = $('#current_password').val();
        if(password != null){
            $.ajax({
            type: 'GET',
            url: '<?php echo e(route('student.get-password')); ?>',
            dataType: 'json',
            data:{
                id: <?php echo e(Auth::user()->id); ?>,
            },
            success: function(data) {
                if(password != data){
                    $('#password_error').text('Password Does not Match');

                    return false;
                }
                else{
                    $('#passwordChangeForm').submit();
                    return true;
                }
            }
        });
        }

    }
</script>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('frontend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/tanmvcyz/freelancing-career.com/resources/views/frontend/student/profile.blade.php ENDPATH**/ ?>