<?php $__env->startSection('title'); ?>
    About Us
<?php $__env->stopSection(); ?>

<?php $__env->startSection('meta'); ?>
    <meta name="title" content="About Freelancing-Career: Empowering Skills in Bangladesh">
    <meta name="description" content="Our mission is to equip future freelancers in Bangladesh with top skills in web development, design, WordPress, and more. Dive in to learn more about us!">
    <meta name="keywords" content="about freelancing career">
    
    <meta name="og:title" content="About Freelancing-Career: Empowering Skills in Bangladesh">
    <meta name="og:image" content="<?php echo e(asset('frontend-assets')); ?>/images/meta_image.png">
<?php $__env->stopSection(); ?>


<?php $__env->startPush('css'); ?>
<!-- Google Font -->
	<link rel="preconnect" href="https://fonts.googleapis.com">
	<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
	<link rel="stylesheet"
		href="https://fonts.googleapis.com/css2?family=Heebo:wght@400;500;700&amp;family=Roboto:wght@400;500;700&amp;display=swap">
	<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.css" />
	<link rel="stylesheet" type="text/css"
		href="https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick-theme.css" />
		
	<link rel="stylesheet" type="text/css" href="<?php echo e(asset('frontend-assets')); ?>/css/aos.css">
<style>
		.icon-hover {
			background-color: #055fb5;
			transition: 0.5s;

		}

		.hoverd:hover .icon-hover {
			background-color: #D6293E;

		}

		.success_story_img {
			width: 100px;
			height: 100px;
			margin: auto;
		}

		.slick-prev,
		.slick-next {
			display: none;
			/* Hide default arrows */
		}

		.custom-arrow {
			border: none;
			width: 40px;
			height: 40px;
			border-radius: 50%;
			display: flex;
			align-items: center;
			justify-content: center;
			position: absolute;
			top: 50%;
			transform: translateY(-50%);
			background-color: #fff;
			/* Background color of buttons */
			box-shadow: 0 2px 5px rgba(0, 0, 0, 0.3);
			/* Optional shadow for effect */
			cursor: pointer;
			/* Pointer cursor */
			z-index: 10;
			/* Ensure buttons are above the slider */
		}
		
		.slick-prev:before, .slick-next:before {
            content: '←';
            display: none;
        }

		.custom-next {
			right: -15px;
			/* Position for right button */
		}

		.custom-prev {
			left: -15px;
			/* Position for left button */
		}


        .bg-info-dark {
          --bs-bg-opacity: 1;
          background-color: #CA9AA8;
        }

		@media (max-width: 768px) {
			.custom-arrow {
				width: 35px;
				height: 35px;
			}
		}

		@media (max-width: 576px) {
			.custom-arrow {
				width: 30px;
				height: 30px;
			}
		}
		
		.feedback-slider-wrapper .custom-arrow {
			border: none;
			width: 40px;
			height: 40px;
			border-radius: 50%;
			display: flex;
			align-items: center;
			justify-content: center;
			position: absolute;
			top: 50%;
			transform: translateY(-50%);
			background-color: #fff;
			/* Background color of buttons */
			box-shadow: 0 2px 5px rgba(0, 0, 0, 0.3);
			/* Optional shadow for effect */
			cursor: pointer;
			/* Pointer cursor */
			z-index: 10;
			/* Ensure buttons are above the slider */
		}

		.feedback-slider-wrapper .custom-next {
			right: -15px;
			/* Position for right button */
		}

		.feedback-slider-wrapper .custom-prev {
			left: -15px;
			/* Position for left button */
		}
		
		.feedback-desc {
		    height: 78px;
		}
		
		@media (max-width: 560px) {
		    .feedback-slider-wrapper .custom-next {
    			right: 0px !important;
    		}
    		.feedback-slider-wrapper .custom-prev {
    			left: 0px !important;
    		}
          .feedback-desc {
            height: 58px !important;
          }
          
          .about__area {
              padding-top: 0px !important;
          }
          
        }
	</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    		<section class="pt-0 pt-md-5">
			<div class="container">
				<div class="row align-items-center">

					<!-- Left side START -->
					<div class="col-lg-5 col-xxl-6 position-relative">
						<!-- Svg decoration -->
						<figure class="position-absolute bottom-0 end-0 me-6 d-none d-xl-block">

						</figure>

						<!-- Title -->
						<h1 class="">
							<span class="position-relative z-index-9"><span style="color:#EB343C">About</span> Us</span>

						</h1>

						<p class="mt-4 mb-0">At <strong>Freelancing Career</strong>, we believe in the power of knowledge and its endless
							possibilities. We were born out of our successful journey with <strong><a href="https://skydreamit.com/" target="_blank">Sky Dream IT</a></strong>, where, since
							2016, we have been providing top-notch web design, development, and digital marketing
							services to both domestic and international clients.</p>
						<p class="mt-4 mb-0">We provide top-quality online courses in web design, development, digital
							marketing, and graphic design. We are a one-stop solution for the essential fields in
							today's digital economy. Our courses are designed by industry experts and meticulously focus
							on practical skills and real-life applications. We ensure that what you learn with us can be
							directly applied to your professional or career endeavors. </p>



						<!-- Buttons -->
						<div class="d-sm-flex align-items-center mt-4">
							<!-- Button -->

							<!-- Video button -->
							<div class="d-flex align-items-center py-2 ms-0 ms-sm-4">
								<a data-glightbox="" data-gallery="office-tour" href=""
									class="btn btn-round btn-danger-shadow mb-0 overflow-visible me-7">
									<i class="fas fa-play"></i>
									<h6
										class="mb-0 ms-3 fw-normal position-absolute start-100 top-50 translate-middle-y">
										Watch video</h6>
								</a>
							</div>
						</div>

					</div>
					<!-- Left side END -->

					<!-- Right side START -->
					<div class="col-lg-7 col-xxl-6 my-5 mt-lg-0">
						<div class="row">

							<div class="col-md-4">
								<!-- Box item -->
								<div class="bg-danger bg-opacity-10 p-4 p-xl-4 text-center rounded-3 mb-4">
									<h6>Since</h6>
									<span class="h2 text-danger mb-2">2016</span>
								</div>

								<!-- Box item -->
								<div class="bg-light p-4 p-xl-4 text-center rounded-3">
								    <h6>Job Placements</h6>
									<span class="h2 text-primary mb-2">76%</span>
								</div>
							</div>

							<div class="col-md-8 position-relative mt-5 mt-md-0">





								<!-- Image -->
								<img src="<?php echo e(asset('frontend-assets')); ?>/images/about-us-tall-1-1.jpg" class="rounded-3" alt="">
								<!-- Image -->
								<div style="top: 95%;"
									class="col-10 position-absolute start-0 translate-middle mt-n6 ms-n3 d-none d-md-block">
									<img src="<?php echo e(asset('frontend-assets')); ?>/images/about-us-small.jpg" class="rounded-3" alt="">
								</div>
							</div>

						</div> <!-- Row END -->
					</div>
					<!-- Right side END -->
				</div>
			</div>
		</section>


		<section class="pt-0 pt-md-5">
			<div class="container">
				<div class="row g-md-5 align-items-center">
					<div class="col-lg-6 mb-3 mb-lg-0">
						<div class="row mt-4 mt-md-0 hoverd">
							<!-- Image 1 -->
							<div class="col-6">
								<img class="rounded" src="<?php echo e(asset('frontend-assets')); ?>/images/about-what-we-offer-1.jpg" alt="">
							</div>

							<!-- Image 2 -->
							<div class="col-6 mt-5 position-relative">
								<img class="rounded" src="<?php echo e(asset('frontend-assets')); ?>/images/02_3.jpg" alt="">
								<!-- SVG decoration -->
								<figure class="position-absolute top-0 end-0 mb-5 mt-n4 d-none d-lg-block">
									<svg width="192.5px" height="89.4px" viewBox="0 0 192.5 89.4">
										<path class="fill-primary"
											d="M170.2,0.5c-0.1,0-0.2,0-0.4,0c-2.6-0.1-5.2-0.4-7.8-0.5c-2.9-0.1-5.8,0-8.6,0.2c-1.4,0.1-2.9,0.3-4.3,0.5 c-0.5,0.1-1,0-1.5,0c-1-0.1-1.9,0.2-2.9,0.3c-5.6,0.9-11.1,2.1-16.5,3.6c-2.7,0.7-5.4,1.6-8.1,2.5c-0.6,0.2-1.2,0.4-1.8,0.5 c-0.4,0-0.8,0-1.2,0.1c-1.5,0.2-3,1.1-4.3,1.8c-3,1.5-5.9,3.2-8.6,5.2c-2,1.5-3.8,3.1-5.6,4.8c-0.9,0.9-1.7,1.8-2.5,2.7 c-0.4,0.4-1.1,0.7-1.4,1.2c-0.3,0.4-0.6,0.9-0.9,1.4c-0.9,1.2-1.7,2.3-2.7,3.4c-0.3,0.4-0.7,0.6-1.2,0.6c-1.4,0.1-2.8-0.1-4.2-0.1 c-0.7,0-1.2,0.2-1.9,0.2c-3.3,0.4-6.6,0.7-9.8,1.6c-1.7,0.5-3.4,0.9-5.1,1.4c-5.4,1.5-11,2.9-16,5.4c-4.6,2.2-8.7,5.2-12.7,8.3 c-2,1.6-4,3.2-5.9,4.9c-0.8,0.7-1.6,1.2-2.5,1.6c-0.9,0.5-1.7,1.3-2.4,2c-1.4,1.3-2.9,2.6-4.3,3.9c-1.2,1.1-2.5,2.1-3.6,3.3 c-0.9,1-2,1.9-3,2.8c-1,0.9-2.1,1.9-3.1,2.8c-0.8,0.7-1.6,1.2-2.3,1.9c-0.9,0.9-1.7,1.9-2.7,2.7c0-0.7,0.2-1.3,0.2-2 c0-1.8-0.2-3.7-0.7-5.5c-0.2-0.9-0.5-1.8-1.1-2.4c-0.6-0.7-1.7-1-2.4-0.6c-0.1,0.1-0.3,0.2-0.4,0.3c-0.1,0.2-0.1,0.4,0,0.6 c0.7,3.7,1.2,7.4,0.7,11.1c-0.2,2.4-0.9,4.9-2,7c-0.5,1-1.2,1.9-1.7,3c-0.4,1-1.4,1.8-2.1,2.7C0.3,86,0.1,86.3,0,86.6 c-0.1,0.4,0.1,0.7,0.2,1.1c0.3,0.8,0.8,1.6,1.6,1.7c0.5,0,0.9-0.2,1.3-0.5c0.9-0.5,1.7-1.1,2.6-1.6c0.4-0.2,0.7-0.5,1.1-0.7 c1.7-1.3,3.7-2.3,5.7-3.1c4.3-1.7,9.1-2.4,13.8-1.7c0.2,0,0.4,0.1,0.7,0c0.7-0.2,0.9-1.2,0.4-1.8c-0.4-0.6-1.2-0.8-1.9-1 c-2.7-0.8-5.4-1.5-8.2-1.8c-0.7-0.1-1.4-0.1-2.1-0.2c-0.3,0-0.6,0-0.8,0c-0.3,0-0.9,0.2-1.2,0.1C13,77,13,77.1,13,76.8 c0-0.4,0.6-0.8,0.9-1c0.5-0.4,0.9-0.8,1.4-1.2c1.1-1,2.3-1.9,3.4-2.9c0.6-0.5,1.1-1,1.7-1.5c0.3-0.3,0.5-0.7,0.9-1 c1.2-1.1,2.7-1.7,3.9-2.8c0.4-0.4,0.8-0.8,1.2-1.2c0.8-0.8,1.7-1.5,2.6-2.2c1-0.8,2.1-1.6,3.1-2.3c0.9-0.6,1.9-1.1,2.6-2 c0.8-1,2.1-1.7,3.1-2.5c1.1-0.9,2.2-1.8,3.3-2.6c3.9-3.1,7.9-6.2,12.3-8.6c5.2-2.7,10.6-4.9,16.3-6.4c5.5-1.4,11.2-1.8,16.8-2.7 c0.2,0,0.3-0.1,0.5-0.1c1.4-0.2,2.3-0.4,2,1.5c-0.8,4.9,2.3,7.5,5.8,9.8c4,2.5,8,5,12.7,5.8c5.2,0.9,10.4,2.7,15.9,0.8 c3-1,6.3-5,6.2-7.6c0-1.7-0.3-3.5-1-5.1c-0.6-1.4-1.5-3-2.8-3.7c-1-0.5-1.9-1.5-2.8-2.2c-1.1-0.8-2.2-1.5-3.3-2.1 c-2.3-1.2-4.8-2.1-7.3-2.8c-3.5-0.9-7.2-1.4-10.8-1.8c-0.9-0.1-1.7-0.2-2.6-0.2c-0.2,0-1.4,0-1.4-0.2c-0.1-0.2,0.3-0.5,0.4-0.6 c0.8-0.9,1.7-1.8,2.5-2.6c1.7-1.7,3.6-3.3,5.5-4.8c2-1.6,4.2-3,6.4-4.1c1.1-0.6,2.3-1.1,3.5-1.5c0.6-0.2,1.2-0.4,1.8-0.6 c0.4-0.2,0.7-0.5,1.1-0.7c1.2-0.6,2.7-0.9,4-1.3c1.4-0.4,2.8-0.8,4.2-1.2c2.8-0.8,5.6-1.5,8.4-2.2c3.4-0.8,6.9-1.6,10.3-2.4 c7.9-1.7,15.9-2.4,24-1.7c4.4,0.4,8.9,0.9,13.2,2.1c1.3,0.4,2.5,0.8,3.9,1.1c0.7,0.1,1.4,0.5,2,0.9c0.9,0.5,1.7,0.9,2.6,1.4 c0.3,0.2,0.7,0.3,0.9,0.1c0.1-0.1,0.1-0.3,0.1-0.4c0-0.9-0.4-1.8-1-2.5c-0.5-0.6-1.2-1.4-1.9-1.8c-0.9-0.6-2.2-0.9-3.3-1.3 c-1.1-0.4-2.2-0.7-3.3-1c-2.8-0.8-5.6-1.4-8.5-1.9C173.1,0.9,171.6,0.6,170.2,0.5z M106.8,36c5,0.8,11.2,2,16.2,6.2 c1.1,0.9,2.8,1.6,2.3,3.4c-0.4,1.7-2.1,1.8-3.5,2.3c-5,1.5-9.9,0-14.5-1.2c-4.9-1.2-9.7-3.3-13.5-7c-0.6-0.6-1.2-1.3-1.5-2.1 c-0.1-0.3-0.1-0.7-0.2-1c-0.1-0.3-0.3-0.6,0-0.9c0.2-0.2,0.5-0.3,0.9-0.3c2.4-0.4,4.9-0.6,7.4-0.5c0.9,0,1.8,0.4,2.7,0.5 C104.5,35.6,105.7,35.8,106.8,36z">
										</path>
									</svg>
								</figure>
							</div>

							<!-- Content -->
							<div class="col-8 col-sm-5 mt-n6 align-items-end position-relative">
								<!-- SVG decoration -->
								<figure class="mt-n7 me-n7 position-absolute top-0 end-0">
									<svg width="192px" height="190px">
										<path stroke="#F99D2B" fill="none" stroke-width="10"
											d="M9.1,82.6C15.5,36,58.7,2.7,105.5,8.3c47.3,5.7,81.4,49.3,75.7,96.6c-5.8,47.2-49.4,81.4-96.6,75.7">
										</path>
									</svg>
								</figure>
								<div class="p-3 card card-body shadow rounded-3 d-inline-block position-relative mt-n2" style="background-color: #FF6865">
									<!-- Info -->
									<h6 class="mb-2 mr-2 text-white">Scholarship<span class="ms-1"><i
												class="fas fa-check-circle text-success"></i></span></h6>
									<p class="mb-0 small text-white">Scholarships on all courses. Call to avail now!</p>
									<!-- Icon -->
									<a href="tel:<?php echo e(getSettings('Phone')); ?>" class="text-white">
    									<div
    										class="icon-lg icon-hover rounded-circle position-absolute top-100 start-100 translate-middle text-white">
    										<i class="fa-solid fa-phone"></i>
    									</div>
									</a>
								</div>
							</div>
						</div> <!-- Row END -->
					</div>

					<div class="col-lg-6 mt-5 mt-lg-0">
						<!-- Title -->
						<h2 class="mb-3"><span style="color:#EB343C">What We</span> offer</h2>
						<p class="mb-3 mb-lg-4">Two before narrow not relied on how except moment myself Dejection
							assurance Mrs led certainly So gate at no only none open Betrayed.</p>
						<!-- Content -->
						<div class="row g-4">
							<!-- Item -->
							<div class="col-6">
								<div class="d-sm-flex align-items-center">
									<div class="icon-md fs-5 text-white bg-warning rounded">
										<i class="fas fa-user-graduate"></i>
									</div>
									<div class="ms-0 ms-sm-3 mt-2 mt-sm-0">
										<h6 class="mb-0">Industry Expert Instructors
										</h6>
										<div class="small">Learn from seasoned professionals</div>
									</div>
								</div>
							</div>

							<!-- Item -->
							<div class="col-6">
								<div class="d-sm-flex align-items-center">
									<div class="icon-md fs-5 text-white bg-info-dark rounded">
										<i class="bi bi-award"></i>
									</div>
									<div class="ms-0 ms-sm-3 mt-2 mt-sm-0">
										<h6 class="mb-0">Lifetime Course Materials
										</h6>
										<div class="small">Engaging, updated materials.</div>
									</div>
								</div>
							</div>

							<!-- Item -->
							<div class="col-6">
								<div class="d-sm-flex mb-lg-0 align-items-center">
									<div class="icon-md fs-5 text-white bg-danger rounded">
										<i class="fas fa-graduation-cap"></i>
									</div>
									<div class="ms-0 ms-sm-3 mt-2 mt-sm-0">
										<h6 class="mb-0">Career Opportunity & Certificates</h6>
										<div class="small">Online + Onsite</div>
									</div>
								</div>
							</div>

							<!-- Item -->
							<div class="col-6">
								<div class="d-sm-flex mb-lg-0 align-items-center">
									<div class="icon-md fs-5 text-white bg-purple rounded">
										<i class="bi bi-laptop"></i>
									</div>
									<div class="ms-0 ms-sm-3 mt-2 mt-sm-0">
										<h6 class="mb-0">Community and Support
										</h6>
										<div class="small"><i class="bi bi-stopwatch me-2"></i>Coming soon...</div>
									</div>
								</div>
							</div>
							<div class="col-6">
								<div class="d-sm-flex mb-lg-0 align-items-center">
									<div class="icon-md fs-5 text-white rounded" style="background-color: #066AC9;">
										<i class="fa-solid fa-circle-dollar-to-slot"></i>
									</div>
									<div class="ms-0 ms-sm-3 mt-2 mt-sm-0">
										<h6 class="mb-0">Competitive and Flexible Pricing</h6>
										<div class="small">Get courses at best price.</div>
									</div>
								</div>
							</div>
						</div> <!-- Row END -->
						<!-- Button -->

					</div>
				</div>
			</div>
		</section>


		<section class="position-relative pt-5 d-none">

			<!-- Content START -->
			<div class="container">
				<div class="row align-items-center justify-content-between">
					<!-- Left content START -->
					<div class="col-lg-6 position-relative z-index-9">

						<h2 class="mb-3">Our Vission</h2>
						<p class="lead mb-4">
							Our vision is to become the leading platform where students can rapidly acquire practical skills through real-world examples, enabling them to thrive in a dynamic job market. We envision a learning environment where knowledge is shared and supported through our vibrant community. By providing exceptional materials, certifications, and career opportunities, we empower learners to transform their careers and lives. Ultimately, we strive for global reach and impactful support, ensuring our platform leads purposefully and effectively.
						</p>


						<!-- Button -->
						<a href="<?php echo e(route('contact')); ?>" class="btn btn-primary">Contact Us</a>
					</div>
					<!-- Left content END -->

					<!-- Right content START -->
					<div class="col-lg-6 position-relative mt-5 mt-lg-0">
						<!-- Award message -->


						<!-- Image -->
						<img src="<?php echo e(asset('frontend-assets')); ?>/images/07_6.jpg" class="rounded-3 z-index-1 position-relative" alt="Tutor image">
					</div>
					<!-- Right content END -->
				</div>
			</div>
			<!-- Content END -->
		</section>

		<!--<section class="position-relative pt-5">-->
			<!-- Content START -->
		<!--	<div class="container">-->
		<!--		<div class="row">-->
		<!--			<div class="col-12">-->
		<!--				<div class="row">-->
							<!-- Text appears first on mobile, second on desktop -->
		<!--					<div class="col-12 col-md-8 order-1 order-md-2">-->
		<!--						<div class="card-content">-->
		<!--							<h2 class="mb-3">Our Mission</h2>-->
		<!--							<p>-->
		<!--							    Our sole mission is to provide top-tier, accessible education that equips you with the tools to succeed in the fast-paced digital era. Our experience in the international market for almost a decade will not only help but polish the best practices for each field.-->
		<!--							</p>-->
		<!--						</div>-->
		<!--					</div>-->
							<!-- Image appears second on mobile, first on desktop -->
		<!--					<div class="card-image col-12 col-md-4 order-2 order-md-1">-->
		<!--						<img src="<?php echo e(asset('frontend-assets')); ?>//images/mission.jpg" class="fadeIn img-fluid mb-4">-->
		<!--					</div>-->
		<!--				</div>-->
						
		<!--				<div class="row mt-3">-->
		<!--					<div class="col-12 col-md-8">-->
		<!--						<div class="card-content">-->
		<!--							<h2 class="mb-3">Our Vision</h2>-->
		<!--							<p>Our vision is to become the leading platform where students can rapidly acquire-->
		<!--								practical skills through real-world examples, enabling them to thrive in a-->
		<!--								dynamic-->
		<!--								job market. We envision a learning environment where knowledge is shared and-->
		<!--								supported through our vibrant community. By providing exceptional materials,-->
		<!--								certifications, and career opportunities, we empower learners to transform their-->
		<!--								careers and lives. Ultimately, we strive for global reach and impactful support,-->
		<!--								ensuring our platform leads purposefully and effectively.-->
		<!--							</p>-->
		<!--						</div>-->
		<!--					</div>-->
		<!--					<div class="card-image col-12 col-md-4">-->
		<!--						<img src="<?php echo e(asset('frontend-assets')); ?>//images/vision.jpg" class="fadeIn img-fluid mb-4">-->
		<!--					</div>-->
		<!--				</div>-->
		<!--			</div>-->
		<!--		</div>-->
		<!--	</div>-->
			<!-- Content END -->
		<!--</section>-->
		
		<section class="about__area mt-3">
			<div class="container">
				<div class="row">
					<div class="col-xxl-12">
						<div class="about__inner row">
						
							<div class="about__content col-lg-7 col-12 order-md-0 order-1 mt-md-0 mt-5">
								<div>
									<h5 class="sec-title py-2 px-4 "
										style="background-color: #FAF0F3; display: inline-block; border-radius: 6px; color: #EB343C;">

										<span>Our Mission</span>
									</h5>
									<div class="d-flex gap-4 align-items-center mt-2">
										<span class="" style="width: 8px; height: 70px; background-color: #EB343C;"></span>

										<h3 class="sec-title " style="width: 90%;">
											Helping You Succeed with Years of Digital Education Experience</h3>
									</div>
									<div class="py-2 ">
										<p>Our sole mission is to provide top-tier, accessible education that equips you
											with the tools to succeed in the fast-paced digital era. Our experience in
											the international market for almost a decade will not only help but polish
											the best practices for each field.</p>
									</div>
								</div>
						
								<div class="mt-2 text-md-end" >
									<h5 class="sec-title py-2 px-4 "
										style="background-color: #FAF0F3; display: inline-block; border-radius: 6px; color: #EB343C; justify-content:end;">

										<span>Our Vision</span>
									</h5>
									<div class="d-flex align-items-center mt-2 gap-4 justify-content-end">
										
										<h3 class="sec-title order-md-0 order-1 ml-md-auto ml-0" style="width: 90%; ">
											Empowering Learners with Practical Skills for a Thriving Career</h3>
											<span class="order-0 order-md-1 ml-md-auto ml-0" style="width: 8px; height: 70px; background-color: #EB343C; "></span>
									</div>
									<div class="py-2 ">
										<p class=""  style="text-align: justify;"> Our vision is to become the leading platform where students can rapidly
											acquire practical skills through real-world examples, enabling them to
											thrive in a dynamic job market. We envision a learning environment where
											knowledge is shared and supported through our vibrant community. By
											providing exceptional materials, certifications, and career opportunities,
											we empower learners to transform their careers and lives. Ultimately, we
											strive for global reach and impactful support, ensuring our platform leads
											purposefully and effectively.</p>
									</div>
								</div>
						


							</div>
							<div class="col-lg-5 col-12 position-relative order-md-1 order-0">
								<!-- <img loading="lazy" decoding="async" width="149" height="93"
								src="https://eduquest.itech-theme.com/wp-content/uploads/2023/08/shape.png"
								class="shape" alt=""> -->
								<img loading="lazy" src="<?php echo e(asset('frontend-assets')); ?>/images/mission-vision-3.png" class="image w-100 rounded" alt="">
								<div style="bottom: 30px; right: 0;" class="about_success position-absolute  shadow-sm">
									<div class="success-story bg-white p-3 d-flex align-items-center gap-3">
										<div class="left position-relative">
											<img loading="lazy" decoding="async" width="50" height="50"
												src="<?php echo e(asset('frontend-assets')); ?>/images/loading-bar.png" class="attachment-full size-full" alt="">
											<h5 class="position-absolute top-50 start-50 translate-middle " style="margin-left: 2px; margin-top: 3px; font-size: 13px">90%</h5>
										</div>
										<div class="right" style="line-height: 0.2rem">
											<h5 class="title"> Success Story</h5>
											<p style="font-size: 11px">Student Success History</p>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>

		<section class="position-relative pt-0 pt-lg-5 d-none">
			<div class="container">
				<div class="mb-5">
					<h2 class="text-center">Success Stories</h2>
				</div>
				<div class="position-relative">

					<div class="slider">
						<!-- Card item START -->
						<div class="col-sm-6 col-lg-4 col-xl-3  p-2">
							<div class="card bg-transparent border p-3">
								<div class="overflow-hidden m-auto">
									<img src="<?php echo e(asset('frontend-assets')); ?>/images/02_5.jpg" style="border-radius: 50%;" class="success_story_img"
										alt="course image">
									<!-- Overlay -->

								</div>

								<!-- Card body -->
								<div class="">
									<!-- Title -->
									<h5 class="card-title text-center mt-3"><a href="#">Turjo Barman</a></h5>
									<p class="text-truncate-2 text-center">Affronting imprudence do he he everything.
										Offered chiefly farther of my no colonel shyness. Such on help ye some door if
										in.
										Laughter proposal laughing any son law consider. Needed except up piqued an.</p>
								</div>
							</div>
						</div>
						<!-- Card item END -->
						<!-- Card item START -->
						<div class="col-sm-6 col-lg-4 col-xl-3  p-2">
							<div class="card bg-transparent border p-3">
								<div class="overflow-hidden m-auto">
									<img src="<?php echo e(asset('frontend-assets')); ?>/images/08_3.jpg" style="border-radius: 50%;" class="success_story_img"
										alt="course image">
									<!-- Overlay -->

								</div>

								<!-- Card body -->
								<div class="">
									<!-- Title -->
									<h5 class="card-title text-center mt-3"><a href="#">Turjo Barman</a></h5>
									<p class="text-truncate-2 text-center">Affronting imprudence do he he everything.
										Offered chiefly farther of my no colonel shyness. Such on help ye some door if
										in.
										Laughter proposal laughing any son law consider. Needed except up piqued an.</p>
								</div>
							</div>
						</div>
						<!-- Card item END -->
						<!-- Card item START -->
						<div class="col-sm-6 col-lg-4 col-xl-3  p-2">
							<div class="card bg-transparent border p-3">
								<div class="overflow-hidden m-auto">
									<img src="<?php echo e(asset('frontend-assets')); ?>/images/09_2.jpg" style="border-radius: 50%;" class="success_story_img"
										alt="course image">
									<!-- Overlay -->

								</div>

								<!-- Card body -->
								<div class="">
									<!-- Title -->
									<h5 class="card-title text-center mt-3"><a href="#">Turjo Barman</a></h5>
									<p class="text-truncate-2 text-center">Affronting imprudence do he he everything.
										Offered chiefly farther of my no colonel shyness. Such on help ye some door if
										in.
										Laughter proposal laughing any son law consider. Needed except up piqued an.</p>
								</div>
							</div>
						</div>
						<!-- Card item END -->
						<!-- Card item START -->
						<div class="col-sm-6 col-lg-4 col-xl-3  p-2">
							<div class="card bg-transparent border p-3">
								<div class="overflow-hidden m-auto">
									<img src="<?php echo e(asset('frontend-assets')); ?>/images/03_5.jpg" style="border-radius: 50%;" class="success_story_img"
										alt="course image">
									<!-- Overlay -->

								</div>

								<!-- Card body -->
								<div class="">
									<!-- Title -->
									<h5 class="card-title text-center mt-3"><a href="#">Turjo Barman</a></h5>
									<p class="text-truncate-2 text-center">Affronting imprudence do he he everything.
										Offered chiefly farther of my no colonel shyness. Such on help ye some door if
										in.
										Laughter proposal laughing any son law consider. Needed except up piqued an.</p>
								</div>
							</div>
						</div>
						<!-- Card item END -->
						<div class="col-sm-6 col-lg-4 col-xl-3  p-2">
							<div class="card bg-transparent border p-3">
								<div class="overflow-hidden m-auto">
									<img src="<?php echo e(asset('frontend-assets')); ?>/images/02_5.jpg" style="border-radius: 50%;" class="success_story_img"
										alt="course image">
									<!-- Overlay -->

								</div>

								<!-- Card body -->
								<div class="">
									<!-- Title -->
									<h5 class="card-title text-center mt-3"><a href="#">Turjo Barman</a></h5>
									<p class="text-truncate-2 text-center">Affronting imprudence do he he everything.
										Offered chiefly farther of my no colonel shyness. Such on help ye some door if
										in.
										Laughter proposal laughing any son law consider. Needed except up piqued an.</p>
								</div>
							</div>
						</div>

					</div> <!-- Row end -->
					<button class="custom-next custom-arrow">
						<i class="fa-solid fa-arrow-right text-dark"></i>
					</button>
					<button class="custom-prev custom-arrow">
						<i class="fa-solid fa-arrow-left"></i>
					</button>
				</div>

			</div>
		</section>
		
		
		<section class="bg-light position-relative">
        <!-- SVG Image -->
        <figure class="position-absolute start-0 bottom-0 mb-0">
            <img src="fonts/10.svg" class="h-200px" alt="">
        </figure>

        <div class="container">
            <!-- Title -->
            <div class="row mb-4">
                <div class="col-lg-8 mx-auto text-center">
                    <h2><span style="color:#EB343C">Our Students</span> Feedback</h2>
                    <p class="mb-0">Discover what our students have to say about their learning journey – real experiences, honest feedback, and inspiring stories</p>
                </div>
            </div>

            <!-- Feedback START -->
            <div class="row">
                <!-- Slider START -->
                <div class="tiny-slider arrow-round arrow-creative arrow-dark arrow-hover d-none">
                    <div class="tiny-slider-inner" data-autoplay="true" data-edge="5" data-arrow="true"
                        data-dots="false" data-items="4" data-items-xl="3" data-items-md="2" data-items-xs="1">

                        <!-- Feedback item -->
                        <?php $__currentLoopData = $testimonials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $testimonial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div>
                                <div class="bg-body text-center p-4 rounded-3 border border-1 position-relative">
                                    <!-- Avatar -->
                                    <div class="avatar avatar-lg mb-3">
                                        <img class="avatar-img rounded-circle" src="<?php echo e(asset($testimonial->image)); ?>"
                                            alt="avatar">
                                    </div>
                                    <!-- Title -->
                                    <h6 class="mb-2"><?php echo e($testimonial->name); ?></h6>
                                    <!-- Content -->
                                    <blockquote class="mt-1">
                                        <p style="height: 90px;">
                                            <span class="me-1 small"><i class="fas fa-quote-left"></i></span>
                                            <?php echo e($testimonial->description); ?>

                                            <span class="ms-1 small"><i class="fas fa-quote-right"></i></span>
                                        </p>
                                    </blockquote>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </div>
                </div>
                <!-- Slider START -->
                
                <div class="position-relative p-0 feedback-slider-wrapper">

					<div class="feedback-slider">
					    <?php $__currentLoopData = $testimonials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $testimonial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    						<!-- Card item START -->
    						<div class="col-sm-6 col-lg-4 col-xl-3  p-2">
    							<!--<div class="card bg-transparent border p-3">-->
    							<!--<div class="card bg-white border p-3">-->
    							<div class="card bg-white p-3">
    								<div class="overflow-hidden m-auto">
    									<img src="<?php echo e(asset($testimonial->image)); ?>" style="border-radius: 50%;" class="success_story_img"
    										alt="course image">
    									<!-- Overlay -->
    
    								</div>
    
    								<!-- Card body -->
    								<div class="">
    									<!-- Title -->
    									<h5 class="card-title text-center mt-3" style="height: 40px !important"><?php echo e($testimonial->name); ?></h5>
    									<p class="text-truncate-3 text-center feedback-desc" style="font-size: 13px;"><?php echo e($testimonial->description); ?></p>
    								</div>
    							</div>
    						</div>
    						<!-- Card item END -->
						 <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					</div> <!-- Row end -->
					<button class="custom-next custom-arrow">
						<i class="fa-solid fa-arrow-right text-dark"></i>
					</button>
					<button class="custom-prev custom-arrow">
						<i class="fa-solid fa-arrow-left"></i>
					</button>
				</div>
				
            </div>
            <!-- Feedback END -->
        </div>
    </section>
    <!-- =======================
                            Reviews END -->
                            

		<!-- Award and Team START  -->
		<section class="pt-0 d-none">
			<div class="container position-relative">
				<!-- SVG decoration START -->
				<figure class="position-absolute top-50 start-50 translate-middle ms-2">
					<svg>
						<path class="fill-white opacity-4"
							d="m496 22.999c0 10.493-8.506 18.999-18.999 18.999s-19-8.506-19-18.999 8.507-18.999 19-18.999 18.999 8.506 18.999 18.999z">
						</path>
						<path class="fill-white opacity-4"
							d="m775 102.5c0 5.799-4.701 10.5-10.5 10.5-5.798 0-10.499-4.701-10.499-10.5 0-5.798 4.701-10.499 10.499-10.499 5.799 0 10.5 4.701 10.5 10.499z">
						</path>
						<path class="fill-white opacity-4"
							d="m192 102c0 6.626-5.373 11.999-12 11.999s-11.999-5.373-11.999-11.999c0-6.628 5.372-12 11.999-12s12 5.372 12 12z">
						</path>
						<path class="fill-white opacity-4"
							d="m20.499 10.25c0 5.66-4.589 10.249-10.25 10.249-5.66 0-10.249-4.589-10.249-10.249-0-5.661 4.589-10.25 10.249-10.25 5.661-0 10.25 4.589 10.25 10.25z">
						</path>
					</svg>
				</figure>
				<!-- SVG decoration END -->

				<div class="row">
					<div class="col-12">
						<div style="" class="bg-grad-pink p-4 p-sm-5 rounded-3">
							<div class="row position-relative">
								<!-- Svg decoration -->
								<figure
									class="fill-white opacity-1 position-absolute top-50 start-0 translate-middle-y">
									<svg width="141px" height="141px">
										<path
											d="M140.520,70.258 C140.520,109.064 109.062,140.519 70.258,140.519 C31.454,140.519 -0.004,109.064 -0.004,70.258 C-0.004,31.455 31.454,-0.003 70.258,-0.003 C109.062,-0.003 140.520,31.455 140.520,70.258 Z">
										</path>
									</svg>
								</figure>
								<!-- Action box -->
								<div class="col-11 mx-auto position-relative">
									<div class="row align-items-center">
										<!-- Title -->
										<div class="col-lg-7">
											<h3 class="text-white">Not sure which one to enroll?</h3>
											<p class="text-white mb-3 mb-lg-0">Tell us about your interest, we will suggest you the best course matching your interests to learn with fun.</p>
										</div>
										<!-- Content and input -->
										<div class="col-lg-5 text-lg-end">
											<a href="<?php echo e(route('contact')); ?>" class="btn btn-white text-dark mb-0">Contact Us</a>
										</div>
									</div>
								</div>
							</div> <!-- Row END -->
						</div>
					</div>
				</div> <!-- Row END -->
			</div>
		</section>
		<!-- =======================
Award and Team END -->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
<!-- Vendors -->
	<script src="js/aos.js"></script>

	<!-- Template Functions -->
	<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
	<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.min.js"></script>
	<script>
		$(document).ready(function () {
			$('.slider').slick({
				autoplay: true,
				autoplaySpeed: 2000,
				dots: false,
				infinite: true,
				slidesToShow: 4,
				slidesToScroll: 1,
				responsive: [
					{
						breakpoint: 1024,
						settings: {
							slidesToShow: 3,
							slidesToScroll: 1,
						}
					},
					{
						breakpoint: 768,
						settings: {
							slidesToShow: 2,
							slidesToScroll: 1,
						}
					},
					{
						breakpoint: 576,
						settings: {
							slidesToShow: 1,
							slidesToScroll: 1,
						}
					}
				]
			});

			// Custom Arrow Button Functionality
			$('.custom-prev').click(function () {
				$('.slider').slick('slickPrev'); // Move to the previous slide
			});

			$('.custom-next').click(function () {
				$('.slider').slick('slickNext'); // Move to the next slide
			});
		});
	</script>
	
	<script>
		$(document).ready(function () {
			$('.feedback-slider').slick({
				autoplay: true,
				autoplaySpeed: 2000,
				dots: false,
				infinite: true,
				slidesToShow: 4,
				slidesToScroll: 1,
				responsive: [
					{
						breakpoint: 1024,
						settings: {
							slidesToShow: 3,
							slidesToScroll: 1,
						}
					},
					{
						breakpoint: 768,
						settings: {
							slidesToShow: 2,
							slidesToScroll: 1,
						}
					},
					{
						breakpoint: 576,
						settings: {
							slidesToShow: 1,
							slidesToScroll: 1,
						}
					}
				]
			});

			// Custom Arrow Button Functionality
			$('.custom-prev').click(function () {
				$('.feedback-slider').slick('slickPrev'); // Move to the previous slide
			});

			$('.custom-next').click(function () {
				$('.feedback-slider').slick('slickNext'); // Move to the next slide
			});
		});
	</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('frontend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/tanmvcyz/freelancing-career.com/resources/views/frontend/pages/about-us/index2.blade.php ENDPATH**/ ?>