<?php $__env->startSection('title'); ?>
    Course List
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">

                    <div class="row">
                        <div class="col-md-10">
                            <h4 class="text-center text-success"><?php echo e(session('message')); ?></h4>
                            <h3 class="text-center"><strong>View Course List</strong></h3>
                        </div>
                        <div class="col-md-2">
                            <a href="<?php echo e(route('admin.course.add')); ?>" class="float-right btn btn-primary">Add Course</a>
                        </div>
                    </div>

                    <hr>
                    <form action="" id="filterForm">
                        <div class="row mb-3">
                            <div class="form-group col-sm-5"><label for="" class="form-control-label">Status</label>
                                <select name="course_status_id" onchange="filter()" id="" class="form-control">
                                    <option value="">All</option>
                                    <option value="1" <?php if(isset($_GET['course_status_id'])): ?><?php echo e($_GET['course_status_id'] == '1' ? 'selected':''); ?><?php endif; ?>>Active</option>
                                    <option value="0" <?php if(isset($_GET['course_status_id'])): ?><?php echo e($_GET['course_status_id'] == '0' ? 'selected':''); ?><?php endif; ?>>Inactive</option>
                                </select>

                            </div>
                            <div class="form-group col-sm-5"><label for="" class="form-control-label">Course Type</label>
                                <select name="course_type" onchange="filter()" id="" class="form-control">
                                    <option value="">All</option>
                                    <option value="online"
                                    <?php if(isset($_GET['course_type'])): ?><?php echo e($_GET['course_type'] == 'online' ? 'selected':''); ?><?php endif; ?>>
                                        Offline</option>
                                    <option value="offline" <?php if(isset($_GET['course_type'])): ?><?php echo e($_GET['course_type'] == 'offline' ? 'selected':''); ?><?php endif; ?>
                                    >Online</option>
                                </select>
                            </div>

                        </div>

                    </form>
                </div>
                <div class="card-body">
                    <table class="table table-striped">
                        <tr>
                            <th>#</th>
                            <th>Course Name<br><span class="second-line">Course Code</span></th>
                            <th>Fee<br><span class="second-line">Discount</span></th>
                            <th>Duration<br><span class="second-line">Lectures</span></th>
                            <th><span class="second-line">Type</span></th>
                            <th>Status<br><span class="second-line">Total Students</span></th>
                            <th>Action</th>
                        </tr>
                        <?php $i=1; ?>
                        <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($i++); ?></td>
                                <td><?php echo e($item->course_name); ?><br><span><?php echo e($item->course_code); ?></span></td>
                                <td><?php echo e($item->course_fee); ?><br><span><?php echo e($item->discount); ?></span></td>
                                <td><?php echo e($item->course_duration); ?><br><span><?php echo e($item->total_lectures); ?></span></td>
                                <td><span><?php echo e(Str::title($item->course_type)); ?> <br></span><a href="<?php echo e($item->course_type == 'online' ? $item->course_link:''); ?>"><?php echo e($item->course_type == 'online' ? $item->course_link:''); ?></a></td>

                                <td class="text-center">
                                    <div class="mb-2">
                                        <span class="<?php if($item->course_status_id == 1): ?> bg-success <?php elseif($item->course_status_id == 2): ?> bg-warning <?php else: ?> bg-danger <?php endif; ?> p-2 text-white" style="border-radius:5px">
                                    <?php if($item->course_status_id == 1): ?> Active <?php elseif($item->course_status_id == 2): ?> Upcoming <?php else: ?> Inactive <?php endif; ?></span>
                                    </div>
                                    <span><?php echo e(count(getStudentsByCourseId($item->id))); ?></span>
                                    </td>

                                <td class="btn-group">
                                    <a href="<?php echo e(route('admin.course.edit', ['id'=>$item->id])); ?>" title="Edit" class="btn btn-primary"><i class="fa fa-pencil"></i></a>
                                    <form action="<?php echo e(route('admin.course.remove')); ?>" onclick="return confirm('Please Confirm Before Deleting it!!')" method="post">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" name="id" value="<?php echo e($item->id); ?>">
                                        <button type="submit" title="Remove" class="btn btn-danger" style="margin-left: 5px"><i class="fa fa-trash"></i></button>
                                    </form>

                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\laravel projects\git projects\learning_management_system\resources\views/admin/course/list.blade.php ENDPATH**/ ?>