<?php $__env->startSection('title'); ?>
    View Attendance Summary
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="text-center text-success"><?php echo e(session('message')); ?></h4>
                    <h3 class="text-center"><strong>View Attendance Summary</strong>
                        <?php if(Auth::user()->role == 2): ?>
                            <a href="<?php echo e(route('exam.attendance.add')); ?>" class="float-right btn btn-primary">Add Exam Attendance</a>
                        <?php endif; ?>
                    </h3>
                </div>
                <div class="card-body">
                    <table class="table table-striped">
                        <tr>
                            <th>#</th>
                            <th class="<?php echo e(Auth::user()->role == 4 ? 'd-none':''); ?>">Teacher Name</th>
                            <th>Course Name</th>
                            <th>Branch Name</th>
                            <th>Batch Name</th>
                            <th>Date</th>
                            <th>Total Student</th>
                            <th>Present</th>
                            <th>Absent</th>
                            <th>Action</th>
                        </tr>
                        <?php $i=1; ?>
                        <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($i++); ?></td>
                                <td class="<?php echo e(Auth::user()->role == 4 ? 'd-none':''); ?>"><?php echo e($item->teacher->name ?? ''); ?></td>
                                <td><?php echo e($item->course->course_name ?? ''); ?></td>
                                <td><?php echo e($item->branch->branch_name ?? ''); ?></td>
                                <td><?php echo e($item->batch->batch_name ?? ''); ?></td>
                                <td><?php echo e($item->date); ?></td>
                                <td><?php echo e($item->total_student); ?></td>
                                <td><?php echo e($item->present); ?></td>
                                <td><?php echo e($item->absent); ?></td>
                                <td class="btn group">

                                    <a href="<?php echo e(route('exam.attendance.details', ['id'=>$item->id])); ?>" title="View Details" class="btn btn-primary"><i class="fa fa-info"></i></a>
                                    <a href="<?php echo e(route('exam.attendance.print', ['id'=>$item->id])); ?>" title="Get Attendance Sheet" class=" mx-2 btn btn-success"><i class="fa fa-download"></i></a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\laravel projects\git projects\learning_management_system\resources\views/admin/exam-attendance/list.blade.php ENDPATH**/ ?>