<?php $__env->startSection('title'); ?>
    Notice List
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="text-center text-success"><?php echo e(session('message')); ?></h4>
                    <h3 class="text-center"><strong>View Notices</strong></h3>
                    <?php if(Auth::user()->role == 1): ?>
                        <a href="<?php echo e(route('admin.notice.add')); ?>" class="float-right btn btn-primary">Add Notice</a>
                    <?php endif; ?>
                </div>
                <div class="card-body table-responsive">
                    <table class="table table-striped">
                        <tr>
                            <th>#</th>
                            <th>Course</th>
                            <th>Batch</th>
                            <th>Circulated By</th>
                            <th>Title</th>
                            <th>Details</th>
                            <th>Date</th>
                            <?php if(Auth::user()->role == 1 || Auth::user()->role == 4): ?>
                                <th>Status</th>
                                <th>Action</th>
                            <?php endif; ?>
                        </tr>
                        <?php $i=1; ?>
                        <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($i++); ?></td>
                                <td><?php echo e($item->course->course_name ?? 'N/A'); ?></td>
                                <td><?php echo e($item->batch->batch_name ?? 'All'); ?></td>
                                <td><?php echo e($item->user->name ?? ''); ?></td>
                                <td><?php echo e($item->notice_title); ?></td>
                                <td><?php echo e($item->notice_description); ?></td>
                                <td width="150px"><?php echo e($item->notice_date); ?><br><span><?php echo e($item->notice_time); ?></span></td>
                                <?php if(Auth::user()->role == 1 || Auth::user()->role == 4): ?>

                                    <td class="text-center">
                                        <div class="">
                                        <span class="<?php echo e($item->notice_status_id == 1 ? 'bg-success':'bg-danger'); ?> p-2 text-white" style="border-radius:5px">
                                    <?php echo e($item->notice_status_id == 1 ? 'Circulated':'Pending'); ?></span>
                                        </div>
                                    </td>
                                    <td class="btn-group">
                                        <a href="<?php echo e(route('admin.notice.edit', ['id'=>$item->id])); ?>" title="Edit" class="btn btn-primary"><i class="fa fa-pencil"></i></a>
                                        <form action="<?php echo e(route('admin.notice.remove')); ?>" onclick="return confirm('Please Confirm Before Deleting it!!')" method="post">
                                            <?php echo csrf_field(); ?>
                                            <input type="hidden" name="id" value="<?php echo e($item->id); ?>">
                                            <button type="submit" title="Remove" class="btn btn-danger" style="margin-left: 5px"><i class="fa fa-trash"></i></button>
                                        </form>
                                    </td>
                                <?php endif; ?>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </table>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/tanmvcyz/freelancing-career.com/resources/views/admin/notice/list.blade.php ENDPATH**/ ?>