<!DOCTYPE html>
<html lang="en">

<head>
    <title><?php echo e(getSettings('site_name' ?? '')); ?> | <?php echo $__env->yieldContent('title'); ?></title>

    <!-- Meta Tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <meta name="description" content="<?php echo e(getSettings('site_name' ?? '')); ?>">
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/magnific-popup.js/1.1.0/magnific-popup.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">



    <!-- Favicon -->

    <link rel="shortcut icon" href="<?php echo e(asset(getSettings('site_icon'))); ?>">

    <!-- Google Font -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600&display=swap">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">



    <?php echo $__env->make('frontend.include.style', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <style>
        .custom-nav-container {
            position: fixed;
            bottom: 0;
            width: 100%;
            padding: 20px;
            max-width: 100%;
            margin: 0 auto;
            left: 0;
            right: 0;

        }

        .custom-nav-box {
            display: flex;
            padding: 8px;
            background-color: #fff;
            box-shadow: 0px 0px 16px 0px #4444;
            border-radius: 8px;
        }

        .custom-nav-list {
            display: flex;
            width: 100%;
            list-style: none;
            justify-content: space-around;
            padding-left: 0px;
        }

        .custom-nav-item {
            display: flex;
            position: relative;
            padding: 2px;
        }

        .custom-nav-item.active .custom-nav-icon {
            margin-top: -26px;
            box-shadow: 0px 0px 16px 0px #4444;
        }

        .custom-nav-item.active .custom-nav-text {
            transform: scale(1);
        }

        .custom-nav-link {
            display: flex;
            flex-direction: column;
            align-items: center;
            color: #2f3046;
            text-decoration: none;
        }

        .custom-nav-icon {
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 2.3em;
            background-color: #fff;
            border-radius: 50%;
            height: 70px;
            width: 70px;
            transition: margin-top 250ms ease-in-out, box-shadow 250ms ease-in-out;
        }

        .custom-nav-text {
            position: absolute;
            bottom: 0;
            transform: scale(0);
            transition: transform 250ms ease-in-out;
        }
    </style>
    <?php echo $__env->yieldPushContent('css'); ?>
</head>

<body>

    <?php echo $__env->make('frontend.include.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- **************** MAIN CONTENT START **************** -->
    <main>
        <?php echo $__env->yieldContent('content'); ?>
        <div class="modal fade" id="promoCodeModal" tabindex="-1" aria-labelledby="promoCodeModalLabel"
            aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="promoCodeModalLabel">Enter Promo Code</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <form action="<?php echo e(route('coupon.apply')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="mb-3">
                                <label for="promoCode" class="form-label">Promo Code</label>
                                <input type="text" class="form-control" id="promoCode" name="coupon_code"
                                    placeholder="Enter your promo code">
                            </div>
                            <button type="submit" class="btn btn-primary">Apply</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <div class="modal fade" id="webinarModal" tabindex="-1" aria-labelledby="webinarModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="registerModalLabel">Register for Free Webinar</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form action="<?php echo e(route('webinar.booking.submit')); ?>" method="post">
                        <div class="modal-body">

                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="webinar_id" value="<?php echo e($webinar->id ?? ''); ?>">
                            <div class="mb-3">
                                <label for="name" class="form-label">Name <span class="text-danger">*</span></label>
                                <input type="text" class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    name="name" id="name" placeholder="Name"
                                    value="<?php echo e(Auth::check() && Auth::user()->role == 3 ? Auth::user()->name : old('name')); ?>"
                                    required>
                                <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback" role="alert"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="mb-3">
                                <label for="phone" class="form-label">Phone</label>
                                <input type="tel" name="phone"
                                    class="form-control <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="phone"
                                    placeholder="Phone"
                                    value="<?php echo e(Auth::check() != null && Auth::user()->role == 3 ? Auth::user()->student->student_phone : old('phone')); ?>"
                                    required>
                                <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback" role="alert"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="mb-3">
                                <label for="email" class="form-label">Email</label>
                                <input type="email" name="email"
                                    class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="email"
                                    placeholder="Email"
                                    value="<?php echo e(Auth::check() != null && Auth::user()->role == 3 ? Auth::user()->email : old('email')); ?>"
                                    required>
                                <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback" role="alert"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="mb-3">
                                <label for="address" class="form-label">Address</label>
                                <textarea type="text" name="address" class="form-control <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="address"
                                    placeholder="Address" required><?php echo e(old('address')); ?></textarea>
                                <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback" role="alert"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-primary">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </main>
    <?php echo NoCaptcha::renderJs(); ?>


    <!-- **************** MAIN CONTENT END **************** -->

    <?php echo $__env->make('frontend.include.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    <!-- Back to top -->
    <div class="back-top d-lg-block d-none"><i
            class="bi bi-arrow-up-short position-absolute top-50 start-50 translate-middle"></i>
    </div>
    <!-- Bootstrap JS -->
    <?php echo $__env->make('frontend.include.script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <script>
        $(document).ready(function() {
            $('.image-popup').magnificPopup({
                type: 'image',
                gallery: {
                    enabled: true
                },
                mainClass: 'mfp-fade',
                removalDelay: 300,
                closeBtnInside: true,
                closeMarkup: '<button title="%title%" type="button" class="mfp-close">&#215;</button>',
                closeOnContentClick: true,
                closeOnBgClick: true
            });
        });
    </script>




    <?php echo $__env->yieldPushContent('js'); ?>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <script>
        toastr.options = {
            "closeButton": true,
            "progressBar": true,
            "positionClass": "toast-top-right",
            "timeOut": "3000",
            "extendedTimeOut": "1000",
            "showEasing": "swing",
            "hideEasing": "linear",
            "showMethod": "fadeIn",
            "hideMethod": "fadeOut"
        };
    </script>




</body>

</html>
<?php /**PATH /home/websited/lms.website-designer-pro.com/resources/views/frontend/master.blade.php ENDPATH**/ ?>