<?php $__env->startSection('title'); ?>
    All Courses
<?php $__env->stopSection(); ?>

<?php $__env->startSection('meta'); ?>
    <meta name="title" content="Freelancing-Career in Bangladesh: From Learning to Earning">
    <meta name="description" content="Start your freelancing career with expert-led courses on in-demand skills and live projects. Get certified and have a chance to join our agency!">
    <meta name="keywords" content="freelancing career courses in Bangladesh">
    
    <meta name="og:title" content="Freelancing-Career in Bangladesh: From Learning to Earning">
    <meta name="og:image" content="<?php echo e(asset('frontend-assets')); ?>/images/meta_image.png">
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
        <!-- =======================
Page Banner START -->
<section>
    <div class="container">

        <div class="row g-4">
            <!-- Title and SVG START -->
            <div class="col-10 text-center mx-auto position-relative">
                <!-- SVG decoration -->
                <figure class="position-absolute top-100 start-50 translate-middle mt-5 ms-n9 pt-5 d-none d-lg-block">
                    <svg>
                        <path class="fill-success" d="m181.6 6.7c-0.1 0-0.2-0.1-0.3 0-2.5-0.3-4.9-1-7.3-1.4-2.7-0.4-5.5-0.7-8.2-0.8-1.4-0.1-2.8-0.1-4.1-0.1-0.5 0-0.9-0.1-1.4-0.2-0.9-0.3-1.9-0.1-2.8-0.1-5.4 0.2-10.8 0.6-16.1 1.4-2.7 0.3-5.3 0.8-7.9 1.3-0.6 0.1-1.1 0.3-1.8 0.3-0.4 0-0.7-0.1-1.1-0.1-1.5 0-3 0.7-4.3 1.2-3 1-6 2.4-8.8 3.9-2.1 1.1-4 2.4-5.9 3.9-1 0.7-1.8 1.5-2.7 2.2-0.5 0.4-1.1 0.5-1.5 0.9s-0.7 0.8-1.1 1.2c-1 1-1.9 2-2.9 2.9-0.4 0.3-0.8 0.5-1.2 0.5-1.3-0.1-2.7-0.4-3.9-0.6-0.7-0.1-1.2 0-1.8 0-3.1 0-6.4-0.1-9.5 0.4-1.7 0.3-3.4 0.5-5.1 0.7-5.3 0.7-10.7 1.4-15.8 3.1-4.6 1.6-8.9 3.8-13.1 6.3-2.1 1.2-4.2 2.5-6.2 3.9-0.9 0.6-1.7 0.9-2.6 1.2s-1.7 1-2.5 1.6c-1.5 1.1-3 2.1-4.6 3.2-1.2 0.9-2.7 1.7-3.9 2.7-1 0.8-2.2 1.5-3.2 2.2-1.1 0.7-2.2 1.5-3.3 2.3-0.8 0.5-1.7 0.9-2.5 1.5-0.9 0.8-1.9 1.5-2.9 2.2 0.1-0.6 0.3-1.2 0.4-1.9 0.3-1.7 0.2-3.6 0-5.3-0.1-0.9-0.3-1.7-0.8-2.4s-1.5-1.1-2.3-0.8c-0.2 0-0.3 0.1-0.4 0.3s-0.1 0.4-0.1 0.6c0.3 3.6 0.2 7.2-0.7 10.7-0.5 2.2-1.5 4.5-2.7 6.4-0.6 0.9-1.4 1.7-2 2.6s-1.5 1.6-2.3 2.3c-0.2 0.2-0.5 0.4-0.6 0.7s0 0.7 0.1 1.1c0.2 0.8 0.6 1.6 1.3 1.8 0.5 0.1 0.9-0.1 1.3-0.3 0.9-0.4 1.8-0.8 2.7-1.2 0.4-0.2 0.7-0.3 1.1-0.6 1.8-1 3.8-1.7 5.8-2.3 4.3-1.1 9-1.1 13.3 0.1 0.2 0.1 0.4 0.1 0.6 0.1 0.7-0.1 0.9-1 0.6-1.6-0.4-0.6-1-0.9-1.7-1.2-2.5-1.1-4.9-2.1-7.5-2.7-0.6-0.2-1.3-0.3-2-0.4-0.3-0.1-0.5 0-0.8-0.1s-0.9 0-1.1-0.1-0.3 0-0.3-0.2c0-0.4 0.7-0.7 1-0.8 0.5-0.3 1-0.7 1.5-1l5.4-3.6c0.4-0.2 0.6-0.6 1-0.9 1.2-0.9 2.8-1.3 4-2.2 0.4-0.3 0.9-0.6 1.3-0.9l2.7-1.8c1-0.6 2.2-1.2 3.2-1.8 0.9-0.5 1.9-0.8 2.7-1.6 0.9-0.8 2.2-1.4 3.2-2 1.2-0.7 2.3-1.4 3.5-2.1 4.1-2.5 8.2-4.9 12.7-6.6 5.2-1.9 10.6-3.4 16.2-4 5.4-0.6 10.8-0.3 16.2-0.5h0.5c1.4-0.1 2.3-0.1 1.7 1.7-1.4 4.5 1.3 7.5 4.3 10 3.4 2.9 7 5.7 11.3 7.1 4.8 1.6 9.6 3.8 14.9 2.7 3-0.6 6.5-4 6.8-6.4 0.2-1.7 0.1-3.3-0.3-4.9-0.4-1.4-1-3-2.2-3.9-0.9-0.6-1.6-1.6-2.4-2.4-0.9-0.8-1.9-1.7-2.9-2.3-2.1-1.4-4.2-2.6-6.5-3.5-3.2-1.3-6.6-2.2-10-3-0.8-0.2-1.6-0.4-2.5-0.5-0.2 0-1.3-0.1-1.3-0.3-0.1-0.2 0.3-0.4 0.5-0.6 0.9-0.8 1.8-1.5 2.7-2.2 1.9-1.4 3.8-2.8 5.8-3.9 2.1-1.2 4.3-2.3 6.6-3.2 1.2-0.4 2.3-0.8 3.6-1 0.6-0.2 1.2-0.2 1.8-0.4 0.4-0.1 0.7-0.3 1.1-0.5 1.2-0.5 2.7-0.5 3.9-0.8 1.3-0.2 2.7-0.4 4.1-0.7 2.7-0.4 5.5-0.8 8.2-1.1 3.3-0.4 6.7-0.7 10-1 7.7-0.6 15.3-0.3 23 1.3 4.2 0.9 8.3 1.9 12.3 3.6 1.2 0.5 2.3 1.1 3.5 1.5 0.7 0.2 1.3 0.7 1.8 1.1 0.7 0.6 1.5 1.1 2.3 1.7 0.2 0.2 0.6 0.3 0.8 0.2 0.1-0.1 0.1-0.2 0.2-0.4 0.1-0.9-0.2-1.7-0.7-2.4-0.4-0.6-1-1.4-1.6-1.9-0.8-0.7-2-1.1-2.9-1.6-1-0.5-2-0.9-3.1-1.3-2.5-1.1-5.2-2-7.8-2.8-1-0.8-2.4-1.2-3.7-1.4zm-64.4 25.8c4.7 1.3 10.3 3.3 14.6 7.9 0.9 1 2.4 1.8 1.8 3.5-0.6 1.6-2.2 1.5-3.6 1.7-4.9 0.8-9.4-1.2-13.6-2.9-4.5-1.7-8.8-4.3-11.9-8.3-0.5-0.6-1-1.4-1.1-2.2 0-0.3 0-0.6-0.1-0.9s-0.2-0.6 0.1-0.9c0.2-0.2 0.5-0.2 0.8-0.2 2.3-0.1 4.7 0 7.1 0.4 0.9 0.1 1.6 0.6 2.5 0.8 1.1 0.4 2.3 0.8 3.4 1.1z"></path>
                    </svg>
                </figure>
                <!-- SVG decoration -->
                <figure class="position-absolute top-0 start-0 ms-n9">
                    <svg width="22px" height="22px" viewBox="0 0 22 22">
                        <polygon class="fill-orange" points="22,8.3 13.7,8.3 13.7,0 8.3,0 8.3,8.3 0,8.3 0,13.7 8.3,13.7 8.3,22 13.7,22 13.7,13.7 22,13.7 "></polygon>
                    </svg>
                </figure>
                <!-- SVG decoration -->
                <figure class="position-absolute top-100 start-100 translate-middle ms-5 d-none d-md-block">
                    <svg width="21.5px" height="21.5px" viewBox="0 0 21.5 21.5">
                        <polygon class="fill-danger" points="21.5,14.3 14.4,9.9 18.9,2.8 14.3,0 9.9,7.1 2.8,2.6 0,7.2 7.1,11.6 2.6,18.7 7.2,21.5 11.6,14.4 18.7,18.9 "></polygon>
                    </svg>
                </figure>
                <!-- SVG decoration -->
                <figure class="position-absolute top-0 start-100 translate-middle">
                    <svg width="27px" height="27px">
                        <path class="fill-orange" d="M13.122,5.946 L17.679,-0.001 L17.404,7.528 L24.661,5.946 L19.683,11.533 L26.244,15.056 L18.891,16.089 L21.686,23.068 L15.400,19.062 L13.122,26.232 L10.843,19.062 L4.557,23.068 L7.352,16.089 L-0.000,15.056 L6.561,11.533 L1.582,5.946 L8.839,7.528 L8.565,-0.001 L13.122,5.946 Z"></path>
                    </svg>
                </figure>

                <!-- Title -->
                <h1 class="position-relative fs-2">Our Courses</h1>
            </div>
            <!-- Title and SVG END -->
        </div>


    </div>
</section>
<!-- =======================
Page Banner END -->

    <!-- =======================
    Recent Course START -->
    <section class="pb-0 pb-md-5 ">
        <div class="container">
            <!-- Title -->
            <div class="row mb-4">
                <div class="row">
                    <div class="col-sm-8">
                        <h2 class="mb-0">Our <span class="text-primary">All</span> Courses</h2>
                    </div>
                    <div class="col-sm-4 d-flex justify-content-sm-end mt-3 mt-sm-0">
                        <select class="form-select" id="categoryFilter" style="max-width: 200px">
                            <option value="">All Categories</option>
                            <?php $__currentLoopData = $course_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($category->slug); ?>" <?php echo e(request('category') == $category->slug ? 'selected' : ''); ?>><?php echo e($category->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
                
                
            </div>
            <div class="row">
                <!-- Slider START -->
                <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                    <div class="col-md-4 my-3">
                        <div class="card shadow h-100">
                            <a href="<?php echo e(route('course.details', $item->slug)); ?>">
                                <div class="rounded-top overflow-hidden">
                                    <div class="card-overlay-hover">
                                        <!-- Image -->
                                        <img src=" <?php echo e(asset($item->image)); ?>" class="card-img-top"
                                            alt="course image">

                                    </div>
                                </div>
                           </a>
                            <!-- Card body -->
                            <div class="card-body">
                                <!-- Rating and avatar -->
                                <div class="d-flex justify-content-between">
                                    <!-- Rating and info -->
                                    <ul class="list-inline hstack gap-2 mb-0">
                                        <!-- Info -->
                                        <li class="list-inline-item d-flex justify-content-center align-items-center">
                                            <div class="icon-md bg-orange bg-opacity-10 text-orange rounded-circle"><i class="fas fa-clock"></i></div>
                                            <span class="h6 fw-light mb-0 ms-2"><?php echo e($item->course_duration); ?></span>
                                        </li>
                                        <!-- Rating -->



                                    </ul>
                                    <!-- Avatar -->
                                    <div class="d-flex justify-content-center align-items-center">
                                        <div class="icon-md bg-primary bg-opacity-15 text-primary rounded-circle"><i class="fas fa-table"></i></div>
                                        <span class="h6 fw-light mb-0 ms-2"><?php echo e($item->total_lectures); ?> Lecture<?php echo e($item->total_lectures > 1 ? 's':''); ?></span>
                                    </div>
                                </div>
                                <!-- Divider -->
                                <hr>
                                <div class="d-flex justify-content-between mb-3">
                                    <div class="hstack gap-2">
                                        <a href="<?php echo e(route('course.details', $item->slug)); ?>" class="badge text-bg-dark">
                                            <?php echo e(Str::title($item->course_type)); ?>

                                        </a>
                                    </div>
                                </div>
                                <!-- Title -->
                                <h5 class="card-title"><a href="<?php echo e(route('course.details', $item->slug)); ?>"><?php echo e($item->course_name); ?></a></h5>
                                <!-- Badge and Price -->
                                <div
                                            class="d-flex justify-content-between align-items-center mb-0 position-relative">
                                            <!-- Category -->
                                            <a href="<?php echo e(route('category.course', $item->category->slug ?? '#')); ?>"
                                                class="badge bg-info bg-opacity-10 text-info me-2" style="
                                                    margin-top: 20px">
                                                <i class="fas fa-circle small fw-bold"></i> <?php echo e($item->category->name); ?>

                                            </a>
                                            <!-- Price Container -->
                                            <div class="">
                                                <?php if($item->course_status_id == 1): ?>
                                                    <del class="text-danger mb-1 ">
                                                        <?php echo e($item->course_fee ?? ''); ?> BDT
                                                    </del>
                                                    <h5 class="text-success mb-0">
                                                        <?php echo e($item->course_fee - $item->discount ?? ''); ?> BDT
                                                    </h5>
                                                <?php elseif($item->course_status_id == 2): ?>
                                                    <h4 class="bg-info bg-opacity-10" style="color: #D6293E;padding: 5px;border-radius: 9px;">Upcoming</h4>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                            </div>
                        </div>
                    </div>

                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <!-- Slider END -->
            </div>
        </div>
    </section>
    <!-- =======================
    Recent Course END -->


<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
<script>
    document.getElementById('categoryFilter').addEventListener('change', function () {
        // Get the selected value
        const selectedCategory = this.value;

        // Get the current URL
        const url = new URL(window.location.href);

        // Update the 'category' query parameter
        if (selectedCategory) {
            url.searchParams.set('category', selectedCategory);
        } else {
            url.searchParams.delete('category'); // Remove parameter if empty
        }

        // Reload the page with the updated URL
        window.location.href = url.toString();
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('frontend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/tanmvcyz/freelancing-career.com/resources/views/frontend/pages/courses/index.blade.php ENDPATH**/ ?>