<?php $__env->startSection('title'); ?>
    Checkout
<?php $__env->stopSection(); ?>
<?php $__env->startPush('css'); ?>
    <style>
        .batch-card {
            cursor: pointer;
            border: 1px solid #ccc;
            transition: border 0.2s ease-in-out;
        }

        .batch-card.selected {
            border-color: #007bff;
            background-color: #f0f8ff;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <?php if($errors->any()): ?>
        <div class="alert alert-danger">
            <ul>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>
    <form action="<?php echo e(route('student.course.enroll')); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <input type="hidden" value="<?php echo e($item->id); ?>" name="course_id">
        <input type="hidden" value="<?php echo e($item->course_type); ?>" id="courseTypeHidden">
        <input type="hidden" id="batch_id" name="batch_id_online" value="">

        <div class="container">
            <div class="row my-5">
                <div class="col-lg-8 ">
                    <!-- Course Details -->
                    <div class="card my-3 border rounded shadow-sm">
                        <div class="card-body mx-3 my-3">
                            <div class="d-flex mb-4">
                                <img class="img-fluid me-3 rounded" style="width: 120px; height: auto;"
                                    src="<?php echo e(asset($item->image)); ?>" alt="Course Image">
                                <div>
                                    <h4><?php echo e($item->course_name); ?></h4>
                                </div>
                            </div>
                            <div class="row">
                                <?php if($item->course_type == 'online and offline'): ?>
                                    <div class="col-md-12">
                                        <div class="form-group mb-3">
                                            <label for="courseTypeSelect" class="form-control-label">Course Type <span
                                                    class="text-danger">*</span></label>
                                            <select id="courseTypeSelect" name="course_type" class="form-control" required>
                                                <option value="">Select</option>
                                                <option value="online">Online</option>
                                                <option value="offline">Offline</option>
                                            </select>
                                        </div>
                                    </div>
                                <?php else: ?>
                                    <input type="hidden" name="course_type" id="courseTypeSelect"
                                        value="<?php echo e($item->course_type); ?>">
                                <?php endif; ?>

                                <div id="branchDiv" class="col-md-6">
                                    <div class="form-group mb-3">
                                        <label for="branchSelect" class="form-control-label">Branch <span
                                                class="text-danger">*</span></label>
                                        <select name="branch_id" id="branchSelect" class="form-control">
                                            <option value="">Select Branch</option>
                                            <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($branch->id); ?>"><?php echo e($branch->branch_name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>

                                <div id="batchDivSelect" class="col-md-6 d-none">
                                    <div class="form-group mb-3">
                                        <label for="batchSelect" class="form-control-label">Batch <span
                                                class="text-danger">*</span></label>
                                        <select id="batchSelect" name="batch_id" class="form-control">
                                            <option value="">Select Batch</option>
                                        </select>
                                    </div>
                                </div>

                                <div id="batchDiv" class="col-md-12" style="display: none;">
                                    <div class="row" id="batchCardContainer">
                                    </div>
                                </div>
                            </div>
                            
                            <div class="d-flex justify-content-between mb-2">
                                <p class="mb-0">Coupon</p>
                                <div>
                                    <div class="input-group">
                                        <input type="text" class="form-control" style="width: 83px" id="promoCode"
                                            value="<?php echo e(session('coupon') != null ? session('coupon')['coupon_code']:''); ?>" name="coupon_code"
                                            placeholder="Promo Code" required>
                                        <input type="hidden" value="<?php echo e($item->id); ?>" name="course_id">
                                        <button type="button" id="<?php echo e(session('coupon') == null ? 'applyCoupon' :'removeCoupon'); ?>"
                                            class="btn btn-primary border-1 border-white">
                                            <i class="fa fa-<?php echo e(session('coupon') != null &&  session('coupon')['coupon_code'] != null ? 'x' : 'check-circle'); ?>"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                            
                            
                            <h6>Payment Details</h6>
                            <div class="d-flex justify-content-between mb-2">
                                <p class="mb-0">Course Price</p>
                                <p class="mb-0">৳ <?php echo e($item->course_fee); ?></p>
                            </div>
                            <div class="d-flex justify-content-between mb-2">
                                <p class="mb-0">Discount</p>
                                <?php if(session('coupon') != null && session('coupon')['discount_type'] == 1): ?>
                                    <input type="hidden" value="<?php echo e(session('coupon')['discount']); ?>" name="discount">
                                    <p class="mb-0">- ৳ <?php echo e(session('coupon')['discount']); ?></p>
                                    <?php
                                        $discount = session('coupon')['discount'];
                                    ?>
                                <?php elseif(session('coupon') != null && session('coupon')['discount_type'] == 0): ?>
                                    <input type="hidden"
                                        value="<?php echo e(($item->course_fee * session('coupon')['discount']) / 100); ?>"
                                        name="discount">
                                    <p class="mb-0">- ৳
                                        <?php echo e(($item->course_fee * session('coupon')['discount']) / 100); ?></p>
                                    <?php
                                        $discount = ($item->course_fee * session('coupon')['discount']) / 100;
                                    ?>
                                <?php else: ?>
                                    <p class="mb-0">- ৳ <?php echo e($item->discount); ?></p>
                                    <input type="hidden" value="<?php echo e($item->discount); ?>" name="discount">
                                    <?php
                                        $discount = $item->discount;
                                    ?>
                                <?php endif; ?>
                            </div>
                            <hr>
                            <div class="d-flex justify-content-between">
                                <h5>Total Payment:</h5>
                                <h5>৳ <?php echo e($item->course_fee - $discount); ?></h5>
                                <input type="hidden" value="<?php echo e($item->course_fee); ?>" name="total_fee">
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Payment Methods -->
                <div class="col-lg-4">
                    <div class="card border card my-3">
                        <div class="card-body">
                            <h5 class="text-center">Payment Methods</h5>
                            <div class="form-check mb-3">
                                <input class="form-check-input" type="radio" name="payment_method" value="Bkash"
                                    id="bKash" checked>
                                <label class="form-check-label d-flex align-items-center p-2 border rounded"
                                    for="bKash">
                                    <img src="https://cdn.ostad.app/public/gateway/bkash-payment.png" alt="bKash"
                                        class="img-fluid me-3" style="height: 30px;">
                                    bKash
                                </label>
                            </div>
                            <div class="form-check mb-3">
                                <input class="form-check-input" type="radio" name="payment_method" value="Nagad"
                                    id="nagad">
                                <label class="form-check-label d-flex align-items-center p-2 border rounded"
                                    for="nagad">
                                    <img src="https://cdn.ostad.app/public/upload/2024-04-23T05-07-00.461Z-nagad.png"
                                        alt="Nagad" class="img-fluid me-3" style="height: 30px;">
                                    Nagad
                                </label>
                            </div>
                            <button class="btn btn-primary form-control">Submit</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('js'); ?>
    <script>
        $('#removeCoupon').on('click', function() {
            // Get the promo code and course id
            alert('ok')
            let promoCode = $('#promoCode').val();
            let courseId = "<?php echo e($item->id); ?>";

            // Create form data
            let formData = new FormData();
            formData.append('coupon_code', promoCode);
            formData.append('course_id', courseId);

            $.ajax({
                url: "<?php echo e(route('coupon.remove')); ?>",
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                headers: {
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                },
                success: function(data) {
                    // Handle the response
                    console.log(data);

                        // alert('Coupon applied/removed successfully');
                        location.reload(); // Reload to reflect the coupon application

                }
            });
        });
        $('#applyCoupon').on('click', function() {
            // Get the promo code and course id
            alert('ok')
            let promoCode = $('#promoCode').val();
            let courseId = "<?php echo e($item->id); ?>";

            // Create form data
            let formData = new FormData();
            formData.append('coupon_code', promoCode);
            formData.append('course_id', courseId);

            $.ajax({
                url: "<?php echo e(route('coupon.apply.ajax')); ?>",
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                headers: {
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                },
                success: function(data) {
                    // Handle the response
                    console.log(data);

                        // alert('Coupon applied/removed successfully');
                        location.reload(); // Reload to reflect the coupon application

                }
            });
        });


        $(document).ready(function() {
            var courseTypeFromDB = $('#courseTypeHidden').val();

            handleCourseTypeDisplay(courseTypeFromDB);

            $('#courseTypeSelect').change(function() {
                var courseType = $(this).val();
                var course_id = $('input[name="course_id"]').val();

                handleCourseTypeDisplay(courseType);
            });

            $('#branchSelect').change(function() {
                var branch_id = $(this).val();
                var course_id = $('input[name="course_id"]').val();

                if (branch_id && course_id) {
                    loadBatches(branch_id, course_id);
                } else {
                    $('#batchCardContainer').empty().append('<p>Select a branch to see batches.</p>');
                }
            });

            function handleCourseTypeDisplay(courseType) {
                var course_id = $('input[name="course_id"]').val();

                if (courseType === 'online') {
                    $('#courseTypeDiv').hide();
                    $('#branchDiv').hide();
                    $('#batchDivSelect').hide();
                    $('#batchDiv').show();
                    loadBatches(null, course_id);
                } else if (courseType === 'offline') {
                    $('#courseTypeDiv').hide();
                    $('#branchDiv').show();
                    $('#batchDiv').show();
                    $('#batchDivSelect').hide();
                    $('#batchCardContainer').empty().append('<p>Select a branch to see batches.</p>');
                } else if (courseType === 'online and offline') {
                    $('#courseTypeDiv').hide();
                    $('#branchDiv').show();
                    $('#batchDiv').hide();
                    $('#batchDivSelect').show();
                    $('#batchSelect').empty().append('<option value="">Select Batch</option>');
                }
            }

            function loadBatches(branch_id, course_id) {
                $.ajax({
                    url: '/get-batches/' + (branch_id ? branch_id : 'null') + '/' + course_id,
                    type: 'GET',
                    success: function(batches) {
                        console.log(batches);
                        $('#batchCardContainer').empty();
                        if (batches.length === 0) {
                            $('#batchCardContainer').append('<p>No Batch Found</p>');
                        } else {
                            $.each(batches, function(key, batch) {
                                var cardHtml = `
                            <div class="col-md-4 col-sm-12 mb-3">
                                <div class="card batch-card" data-batch-id="${batch.id}">
                                    <div class="card-body text-center" style="padding-bottom: 0px;">
                                        <h6>${batch.batch_name}</h6>
                                        <p>${batch.branch.branch_name}</p>
                                        <input type="hidden" class="batch_value" value="${batch.id}">
                                    </div>
                                </div>
                            </div>`;
                                $('#batchCardContainer').append(cardHtml);
                            });

                            $('.batch-card').on('click', function() {
                                $('.batch-card').removeClass('selected');
                                $(this).addClass('selected');
                                var selectedBatchId = $(this).find('.batch_value').val();
                                $('input[name="batch_id_online"]').val(selectedBatchId);
                            });
                        }
                    },
                    error: function() {
                        alert('Failed to fetch batches. Please try again.');
                    }
                });
            }

            $('form').on('submit', function(event) {
                if ($('input[name="batch_id_online"]').val() === '') {
                    alert('Please select a batch before submitting.');
                    event.preventDefault();
                }
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('frontend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\laravel projects\git projects\learning_management_system\resources\views/frontend/pages/checkout/index.blade.php ENDPATH**/ ?>