<?php $__env->startSection('title'); ?>
    Assigned Course List
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">

                    <div class="row">
                        <div class="col-md-10">
                            <h4 class="text-center text-success"><?php echo e(session('message')); ?></h4>
                            <h3 class="text-center"><strong>View Assigned Course List</strong></h3>
                        </div>
                    </div>

                    <hr>
                    <form action="" id="filterForm">
                        <div class="row mb-3">
                            <div class="form-group col-sm-5"><label for="" class="form-control-label">Status</label>
                                <select name="course_status_id" onchange="filter()" id="" class="form-control">
                                    <option value="">All</option>
                                    <option value="1" <?php if(isset($_GET['course_status_id'])): ?><?php echo e($_GET['course_status_id'] == '1' ? 'selected':''); ?><?php endif; ?>>Active</option>
                                    <option value="0" <?php if(isset($_GET['course_status_id'])): ?><?php echo e($_GET['course_status_id'] == '0' ? 'selected':''); ?><?php endif; ?>>Inactive</option>
                                </select>

                            </div>
                            <div class="form-group col-sm-5"><label for="" class="form-control-label">Course Type</label>
                                <select name="course_type" onchange="filter()" id="" class="form-control">
                                    <option value="">All</option>
                                    <option value="offline"
                                    <?php if(isset($_GET['course_type'])): ?><?php echo e($_GET['course_type'] == 'offline' ? 'selected':''); ?><?php endif; ?>>
                                        Offline</option>
                                    <option value="online" <?php if(isset($_GET['course_type'])): ?><?php echo e($_GET['course_type'] == 'online' ? 'selected':''); ?><?php endif; ?>
                                    >Online</option>
                                </select>
                            </div>

                        </div>

                    </form>
                </div>
                <div class="card-body">
                    <table class="table table-striped">
                        <tr>
                            <th>#</th>
                            <th>Course Name<br><span class="second-line">Course Code</span></th>
                            <th>Duration<br><span class="second-line">Lectures</span></th>
                            <th><span class="second-line">Type</span></th>
                            <th><span class="second-line">Assign Batches</span></th>
                            <th><span class="second-line">Total Students</span></th>
                        </tr>
                        <?php $i=1; ?>
                        <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($i++); ?></td>
                                <td><?php echo e($item->course->course_name ?? ''); ?><br><span><?php echo e($item->course->course_code ?? ''); ?></span></td>
                                <td><?php echo e($item->course->course_duration); ?><br><span><?php echo e($item->course->total_lectures); ?></span></td>
                                <td><span><?php echo e($item->course->course_type); ?> <br></span><a href="<?php echo e($item->course->course_type == 'online' ? $item->course->course_link:''); ?>"><?php echo e($item->course->course_type == 'online' ? $item->course->course_link:''); ?></a></td>
                                <td><?php echo e(count(getAssignedBatchesByCourseId($item->course_id))); ?></td>
                                <td class="text-center">
                                    <span><?php echo e(count(getStudentsByCourseId($item->course_id))); ?></span>
                                    </td>

                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\laravel projects\git projects\learning_management_system\resources\views/teacher/course/list.blade.php ENDPATH**/ ?>