<?php $__env->startSection('title'); ?>
    Student List
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <?php
    $column='col-sm-2';
    ?>
    <div class="row mt-5 ">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="text-center text-success"><?php echo e(session('message')); ?></h4>
                    <h3 class="text-center"><strong>View Students</strong>

                        <a href="<?php echo e(route('student.add')); ?>" class="float-right btn btn-primary">Add Student</a>

                    </h3>
                    <hr>
                    <form id="filterForm">
                        <div class="row">
                            <div class="form-group col-sm-8">
                                <label for="" class="form-control-label">Student Roll</label>
                                <input name="student_roll" id="student_roll" placeholder="Enter Student Roll" onchange="filter()" type="text" class="form-control" value="<?php if(isset($_GET['student_roll'])): ?><?php echo e($_GET['student_roll']); ?><?php endif; ?>">
                            </div>
                            <div class="form-group col-sm-4">
                                <label for="" class="form-control-label">Year</label>
                                <select name="year" id="year" onchange="filter()" class="form-control">
                                    <option value="">All</option>
                                    <?php for($i=2018; $i<=date('Y'); $i++): ?>
                                        <option value="<?php echo e($i); ?>" <?php if(isset($_GET['year'])): ?> <?php if($i == $_GET['year']): ?> selected <?php endif; ?> <?php endif; ?>><?php echo e($i); ?></option>
                                    <?php endfor; ?>
                                </select>
                            </div>
                        </div>

                    </form>
                </div>
                <div class="card-body">
                    <div class="">
                        <table id="filter_table" class="table table-striped">
                            <thead>
                                <tr>
                                <th>#</th>
                                <th>Image</th>
                                <th>Name</th>
                               <th>Father's Name<br><span class="second-line">Mother's Name</span></th>
                                <th>Roll No<br><span class="second-line">Registration No</span></th>
                                <th>Phone</th>
                                






                                    <th>Action</th>

                                
                            </tr>
                            </thead>
                            <?php $i=1; ?>
                            <tbody>
                                <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($i++); ?></td>
                                    <?php
                                        $course = getCourseById($item->course_id);
                                        $branch = getBranchById($item->branch_id);
                                        $student = getStudentById($item->student_id)
                                    ?>

                                        <td>
                                            <?php if($item->student && $item->student->student_image != null): ?>
                                                <img src="<?php echo e(asset($item->student->student_image)); ?>" class="rounded-circle" height="100px" width="100px" alt="">
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e($item->student->student_name ?? ''); ?></td>
                                       <td><?php echo e($item->student->father_name ?? ''); ?><br><span><?php echo e($item->student->mother_name ?? ''); ?></span></td>
                                        <td><?php echo e($item->student_roll ?? ''); ?> <br><span><?php echo e($item->student_registration ?? ''); ?></span></td>
                                        <td><?php echo e($item->student->student_phone ?? ''); ?></td>

                                        












                                        <td></td>
                                        <td><?php echo e($item->join_date); ?></td>

                                        <td class="btn-group">
                                            <a href="<?php echo e(route('student.edit', ['id'=>$item->id])); ?>" title="Edit" class="btn btn-primary"><i class="fa fa-pencil"></i></a>
                                            <form action="<?php echo e(route('student.remove')); ?>" onclick="return confirm('Please Confirm Before Deleting it!!')" method="post">
                                                <?php echo csrf_field(); ?>
                                                <input type="hidden" name="id" id="'student_id'.<?php echo e($i); ?>" value="<?php echo e($item->id); ?>">
                                                <button type="submit" class="btn btn-danger" title="Remove" style="margin-left: 5px"><i class="fa fa-trash"></i></button>
                                            </form>
                                            <a  onclick="test(<?php echo e($item->id); ?>)" class="btn btn-info"><i class="fa fa-download"></i></a>
                                        </td>














                                </tr>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                        <?php echo e($items->links('pagination::bootstrap-5')); ?>

                    </div>

                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>
    <script>
        function filter(){
            jQuery('#filterForm').submit()
        }

<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/tanmvcyz/freelancing-career.com/resources/views/admin/student/list.blade.php ENDPATH**/ ?>