<?php $__env->startSection('title'); ?>
    Gallery Images
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row mt-1">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header text-center">
                    <h3 class="text-success"><?php echo e(session('message')); ?></h3>
                    <h2>Gallery Images</h2>
                </div>
                <div class="card-body">
                    <table class="table table-striped">
                        <tr>
                            <th>#</th>
                            <th>Title</th>
                            <th>Description</th>
                            <th>Images</th>
                            <th>Action</th>
                        </tr>
                        <?php $i=1; ?>
                        <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($i++); ?></td>
                                <td><?php echo e($item->title); ?></td>
                                <td><?php echo e($item->description); ?></td>
                                <td>
                                    <?php $__currentLoopData = $item->galleryImage; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <img src="<?php echo e(asset($image->image_path)); ?>" alt="" class="mx-2" height="100px" width="100px">
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </td>
                                <td class="btn-group">
                                    <a href="<?php echo e(route('admin.gallery.edit', ['id'=>$item->id])); ?>" title="Edit" class="btn btn-primary"><i class="fa fa-pencil"></i></a>
                                    <form action="<?php echo e(route('admin.gallery.remove')); ?>" onclick="return confirm('Please Confirm Before Deleting it!!')" method="post">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" name="id" value="<?php echo e($item->id); ?>">
                                        <button type="submit" title="Remove" class="btn btn-danger" style="margin-left: 5px"><i class="fa fa-trash"></i></button>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/tanmvcyz/freelancing-career.com/resources/views/admin/gallery/list.blade.php ENDPATH**/ ?>