<?php $__env->startSection('title'); ?>
    Student List
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

    <?php
    $column='col-sm-2';
    $route = Route::currentRouteName();

    ?>
    <div class="row mt-5 ">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h2 class="text-center">Batch Students</h2>
                    <h4 class="text-center text-success"><?php echo e(session('message')); ?></h4>

                        <hr>
                        <form id="filterForm">
                            <div class="row">
                                <div class="form-group col-sm-<?php echo e($route != 'teacher.student.list.by-batch' ? '6':'12'); ?>">
                                    <label for="" class="form-control-label">Student Roll</label>
                                    <input name="student_roll" id="student_roll" placeholder="Enter Student Roll" onchange="filter()" type="text" class="form-control" value="<?php if(isset($_GET['student_roll'])): ?><?php echo e($_GET['student_roll']); ?><?php endif; ?>">
                                </div>
                                <?php if($route != 'teacher.student.list.by-batch'): ?>
                                <div class="form-group col-sm-6">
                                    <label for="" class="form-control-label">Course</label>
                                    <select name="course_id" id="year" onchange="filter()" class="form-control">
                                        <option value="">All</option>
                                        <?php $__currentLoopData = assignedCourses(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($course->course_id); ?>" <?php if(isset($_GET['course_id'])): ?> <?php if($course->course_id == $_GET['course_id']): ?> selected <?php endif; ?> <?php endif; ?>><?php echo e($course->course->course_name ?? ''); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="form-group col-sm-6">
                                    <label for="" class="form-control-label">Branch</label>
                                    <select name="branch_id" id="year" onchange="filter()" class="form-control">
                                        <option value="">All</option>
                                        <?php if(isset($assigned_branches)): ?>
                                            <?php $__currentLoopData = $assigned_branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($branch->branch_id); ?>" <?php if(isset($_GET['branch_id'])): ?> <?php if($branch->branch_id == $_GET['branch_id']): ?> selected <?php endif; ?> <?php endif; ?>><?php echo e($branch->branch->branch_name ?? ''); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    </select>
                                </div>
                                <div class="form-group col-sm-6">
                                    <label for="" class="form-control-label">Batch</label>
                                    <select name="batch_id" id="year" onchange="filter()" class="form-control">
                                        <option value="">All</option>
                                        <?php if(isset($batches)): ?>
                                            <?php $__currentLoopData = $batches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $batch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($batch->id); ?>" <?php if(isset($_GET['batch_id'])): ?> <?php if($batch->batch_id == $_GET['batch_id']): ?> selected <?php endif; ?> <?php endif; ?>><?php echo e($batch->batch_name ?? ''); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    </select>
                                </div>
                                <?php endif; ?>
                                
                                
                                
                                
                                
                                
                                
                                
                                
                            </div>

                        </form>

                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="filter_table" class="table table-striped">
                            <thead>
                                <tr>
                                <th>#</th>
                                <th>Image</th>
                                <th>Name</th>

                                <th>Roll No<br><span class="second-line">Registration No</span></th>
                                <th>Phone</th>
                                <th>Course Name</th>

                                <th>Branch Name</th>
                                <th>Batch Name</th>
                                    <th>Status</th>






                                
                            </tr>
                            </thead>
                            <?php $i=1; ?>
                            <tbody>

                                <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($i++); ?></td>
                                    <td>
                                        <?php if($item->student && $item->student->student_image != null): ?>
                                            <img src="<?php echo e(asset($item->student->student_image ?? '')); ?>" class="rounded-circle" width="50px" alt="">
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($item->student->student_name ?? ''); ?></td>
                                    <td><?php echo e($item->student_roll ?? ''); ?> <br><span><?php echo e($item->student_registration ?? ''); ?></span></td>
                                    <td><?php echo e($item->student->student_phone ?? ''); ?></td>
                                    <td><?php echo e($item->course->course_name ?? ''); ?></td>
                                    <td><?php echo e($item->branch->branch_name ?? ''); ?></td>
                                    <td><?php echo e($item->batch->batch_name ?? ''); ?></td>
                                    <td>
                                        <?php if($item->status != 3): ?>
                                            <form action="<?php echo e(route('teacher.student.status.change')); ?>" id="statusChangeForm<?php echo e($item->id); ?>" method="post">
                                                <?php echo csrf_field(); ?>
                                                <input type="hidden" value="<?php echo e($item->id); ?>" name="id">
                                                <select name="status" id="status<?php echo e($item->id); ?>" class="form-control" onchange="submitForm(<?php echo e($item->id); ?>)">
                                                    <option value="1" <?php echo e($item->status == '1' ? 'selected':''); ?>>On Going</option>
                                                    <option value="4" <?php echo e($item->status == '4' ? 'selected':''); ?>>Dropped</option>
                                                    <option value="3" <?php echo e($item->status == '3' ? 'selected':''); ?>>Completed</option>
                                                    <option value="2" <?php echo e($item->status == '2' ? 'selected':''); ?>>Banned</option>
                                                </select>
                                            </form>
                                        <?php else: ?>
                                            Completed
                                        <?php endif; ?>

                                    </td>


                                </tr>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                        <?php echo e($items->links('pagination::bootstrap-5')); ?>

                    </div>

                </div>
            </div>
        </div>
    </div>
    <div class="modal" id="myModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <form action="<?php echo e(route('teacher.student.status.change')); ?>"  method="post">
                    <?php echo csrf_field(); ?>
                <div class="modal-header">
                    <h5 class="modal-title">Reason</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="status" id="reason_status" value="">
                    <input type="hidden" value="" name="id" id="reason_id">
                    <textarea name="comment" class="form-control" placeholder="Enter Reason" id="" cols="30" rows="10" required></textarea>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Submit</button>
                </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>
    <script>
        function filter(){
            jQuery('#filterForm').submit()
        }
        function submitForm(id){
            var value = jQuery('#status'+id).val();
            if(value == 2 || value == 4){
                jQuery('#reason_status').val(value);
                jQuery('#reason_id').val(id);
                jQuery('#myModal').modal('show');
            }
            else {
                jQuery('#myModal').modal('hide');
                jQuery('#statusChangeForm'+id).submit();
            }

        }
    </script>












<?php $__env->stopPush(); ?>


<?php echo $__env->make('admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/tanmvcyz/freelancing-career.com/resources/views/teacher/student/list.blade.php ENDPATH**/ ?>