<?php $__env->startSection('title'); ?>
    Session List
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="text-center text-success"><?php echo e(session('message')); ?></h4>
                    <h3 class="text-center"><strong>View Session List</strong>
                        <a href="<?php echo e(route('admin.session.add')); ?>" class="float-right btn btn-primary">Add Session</a>
                    </h3>
                    <hr>
                    <form action="" id="filterForm">
                        <div class="row">
                            <div class="form-group col-md-4"><label for="" class="form-control-label">Status</label>
                                <select name="session_status_id" onchange="filter()" id="" class="form-control">
                                    <option value="">All</option>
                                    <option value="1" <?php if(isset($_GET['session_status_id'])): ?><?php echo e($_GET['session_status_id'] == 1 ? 'selected':''); ?><?php endif; ?>>Active</option>
                                    <option value="0" <?php if(isset($_GET['session_status_id'])): ?><?php echo e($_GET['session_status_id'] == 0 ? 'selected':''); ?><?php endif; ?>>Inactive</option>
                                </select>
                            </div>

                        </div>
                    </form>
                </div>
                <div class="card-body">
                    <table class="table table-striped">
                        <tr>
                            <th>#</th>
                            <th>Session Title</th>
                            <th>Starting Date</th>
                            <th>Ending Date</th>
                            <th>Total Courses</th>
                            <th>Total Students</th>
                            <th>Admission Fee</th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                        <?php $i=1; ?>
                        <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                            <tr>
                                <td><?php echo e($i++); ?></td>
                                <td><?php echo e($item->session_name); ?></td>
                                <td><?php echo e($item->session_start_day); ?> <?php echo e($months[$item->session_start_month-1]); ?>, <?php echo e($item->session_start_year); ?></td>
                                <td><?php echo e($item->session_end_day); ?> <?php echo e($months[$item->session_end_month-1]); ?>, <?php echo e($item->session_end_year); ?></td>
                                <td><?php echo e(count(getCoursesBySessionId($item->id))); ?></td>
                                <td><?php echo e(count(getStudentsBySessionId($item->id))); ?></td>
                                <td><?php echo e($item->admission_fee); ?></td>
                                <td class="text-center">
                                    <div class="">
                                        <span class="<?php echo e($item->session_status_id == 1 ? 'bg-success':'bg-danger'); ?> p-2 text-white" style="border-radius:5px">
                                    <?php echo e($item->session_status_id == 1 ? 'Active':'Inactive'); ?></span>
                                    </div>
                                </td>

                                <td class="btn-group">
                                    <a href="<?php echo e(route('admin.session.edit', ['id'=>$item->id])); ?>" title="Edit" class="btn btn-primary"><i class="fa fa-pencil"></i></a>
                                    <form action="<?php echo e(route('admin.session.remove')); ?>" onclick="return confirm('Please Confirm Before Deleting it!!')" method="post">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" name="id" value="<?php echo e($item->id); ?>">
                                        <button type="submit" title="Remove" class="btn btn-danger" style="margin-left: 5px"><i class="fa fa-trash"></i></button>
                                    </form>

                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </table>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/tanmvcyz/freelancing-career.com/resources/views/admin/session/list.blade.php ENDPATH**/ ?>