<?php


use App\Http\Controllers\ExamAttendanceController;
use App\Http\Controllers\OfferController;
use App\Http\Controllers\TeacherController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\WebinarBookingController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\BranchApplyController;
use App\Http\Controllers\UserMessageController;
use App\Http\Controllers\BkashController;

//frontend section

Route::get('/', [HomeController::class, 'index'])->name('home');
Route::get('/branch/apply', [BranchApplyController::class, 'index'])->name('branch.apply');
Route::post('/branch/apply/submit', [BranchApplyController::class, 'submit'])->name('branch.apply.submit');
Route::get('/exam-result', [HomeController::class, 'examResult'])->name('exam.results');
Route::get('/courses', [HomeController::class, 'courses'])->name('courses');
Route::get('/course/details/{slug}', [HomeController::class, 'courseDetail'])->name('course.details');
Route::get('/course-categories', [HomeController::class, 'courseCategory'])->name('course.categories');
Route::get('/course/category/{slug}', [HomeController::class, 'categoryCourses'])->name('category.course');
Route::get('/gallery', [HomeController::class, 'gallery'])->name('gallery');
Route::get('/resources', [HomeController::class, 'resources'])->name('resources');
Route::get('/contact-us', [HomeController::class, 'contact'])->name('contact');
Route::get('/faq', [HomeController::class, 'faq'])->name('faq');
Route::post('/qustion/submit', [HomeController::class, 'submitQustion'])->name('submit.qustion');
Route::get('/branches/all', [HomeController::class, 'branches'])->name('branches.all');

Route::get('/about-us', [HomeController::class, 'about'])->name('about.us');
Route::get('/all-webinar', [HomeController::class, 'allWebinar'])->name('all.webinar');
Route::get('/privacy-policy', [HomeController::class, 'privacyPolicy'])->name('privacy-policy');
Route::get('/terms-conditions', [HomeController::class, 'terms'])->name('terms-conditions');
Route::get('/cookies', [HomeController::class, 'cookies'])->name('cookies');
Route::get('/help', [HomeController::class, 'help'])->name('help');
Route::get('/404-not-found', [HomeController::class, 'notFound'])->name('not-found');
Route::get('app-link', [HomeController::class, 'appLink'])->name('app-link');
Route::post('submit/verify', [HomeController::class, 'submitVerify'])->name('submit.verify');
Route::post('/user/message/send', [UserMessageController::class, 'submit'])->name('user.message.send');
Route::post('/webinar/booking/submit', [WebinarBookingController::class, 'submit'])->name('webinar.booking.submit');

//Route::get('buser', [LoginController::class, 'name'])->name('buser');

Route::get('get-branch-by-course', [TeacherController::class, 'getBranchByCourseId'])->name('get-branch-by-course');
Route::get('get-batch-by-course', [TeacherController::class, 'getBatchByCourseId'])->name('get-batch-by-course');
Route::get('get-batch-by-branch', [TeacherController::class, 'getBatchByBranchId'])->name('get-batch-by-branch');
Route::get('get-batch-by-branch-course', [TeacherController::class, 'getBatchByBranchCourseId'])->name('get-batch-by-branch-course');
Route::get('get-course-by-id', [TeacherController::class, 'getCourseById'])->name('get-course-by-id');
Route::get('verify-certificate', [HomeController::class, 'verifyCertificate'])->name('certificate.verify');
Route::get('checkout/{slug}', [HomeController::class, 'checkout'])->name('checkout');
Route::get('offers/all', [OfferController::class, 'list'])->name('offer.all');
Route::get('offer/details/{slug}', [OfferController::class, 'detail'])->name('offer.details');

// Route::get('/get-batches/{branch_id}', 'HomeController@getBatchesByBranch');
Route::get('/get-batches/{branch_id}/{course_id}/{batch_type}', [HomeController::class, 'getBatchesByBranchAndCourse']);

Route::post('/apply-coupon', [HomeController::class, 'applyCoupon'])->name('coupon.apply');
Route::post('/apply-coupon-ajax', [HomeController::class, 'applyCouponAjax'])->name('coupon.apply.ajax');
Route::post('/remove-coupon', [HomeController::class, 'removeCoupon'])->name('coupon.remove');
Route::post('/bkash/create', [BkashController::class, 'checkout'])->name('bkash.checkout');
Route::get('/bkash/callback', [BkashController::class, 'callback'])->name('bkash.callback');
Route::get('/bkash/success', [BkashController::class, 'success'])->name('bkash.success');
Route::get('/payment/error', [BkashController::class, 'error'])->name('bkash.error');





//common routes for teacher & admin
Route::prefix('/')->name('admin.')->middleware('auth')->group(function () {
    Route::get('dashboard', [DashboardController::class, 'index'])->name('dashboard');

});
Route::middleware(['auth'])->group(function () {
    Route::get('/profile/edit', [UserController::class, 'edit'])->name('profile.edit');
    Route::post('profile/update', [UserController::class, 'update'])->name('profile.update');
    Route::get('/password/edit', [UserController::class, 'passwordEdit'])->name('password.edit');
    Route::post('password/update', [UserController::class, 'passwordUpdate'])->name('password.update');

    //exam attendance
    Route::prefix('exam/attendance/')->name('exam.attendance.')->group(function () {
        Route::get('list', [ExamAttendanceController::class, 'list'])->name('list');
        Route::get('details/{id}', [ExamAttendanceController::class, 'details'])->name('details');
        Route::get('print/{id}', [ExamAttendanceController::class, 'print'])->name('print');
    });
});
