<?php


use App\Http\Controllers\CourseController;
use App\Http\Controllers\ExamAttendanceController;
use App\Http\Controllers\NoticeController;
use App\Http\Controllers\TeacherController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ClassScheduleController;



Route::prefix('teacher/')->name('teacher.')->middleware('teacher')->group(function () {
//        notice-module
    Route::prefix('notice/')->name('notice.')->group(function () {
        Route::get('add', [NoticeController::class, 'add'])->name('add');
        Route::post('submit', [NoticeController::class, 'submit'])->name('submit');
        Route::get('list', [NoticeController::class, 'list'])->name('list');
        Route::get('edit/{id}', [NoticeController::class, 'edit'])->name('edit');
        Route::post('update', [NoticeController::class, 'update'])->name('update');
        Route::post('remove', [NoticeController::class, 'remove'])->name('remove');
    });

    Route::get('course/assigned', [TeacherController::class, 'assignedCourses'])->name('course.assigned');
    Route::get('batches/assigned', [TeacherController::class, 'assignedBatches'])->name('batch.assigned');
    Route::get('batches/complete/request/{id}', [TeacherController::class, 'batchCompletion'])->name('batch.complete.request');
    Route::get('student/list', [TeacherController::class, 'studentList'])->name('student.list');
    Route::post('student/status/change', [TeacherController::class, 'changeEnrollmentStatus'])->name('student.status.change');
    Route::get('student/list/view/{id}', [TeacherController::class, 'studentListByBatch'])->name('student.list.by-batch');

    Route::prefix('schedule/')->name('schedule.')->group(function () {
        Route::get('add', [ClassScheduleController::class, 'add'])->name('add');
        Route::post('submit', [ClassScheduleController::class, 'submit'])->name('submit');
        Route::get('list/{id}', [ClassScheduleController::class, 'list'])->name('list');
        Route::get('all', [ClassScheduleController::class, 'allSchedules'])->name('all');
        Route::get('edit/{id}', [ClassScheduleController::class, 'edit'])->name('edit');
        Route::post('update', [ClassScheduleController::class, 'update'])->name('update');
        Route::post('remove', [ClassScheduleController::class, 'remove'])->name('remove');
        Route::post('end', [ClassScheduleController::class, 'endClass'])->name('end');
    });

    Route::get('get-course', [CourseController::class, 'getCourse'])->name('get-course');

    //attendance Module
    Route::prefix('attendance/')->name('attendance.')->group(function () {
        Route::get('add', [ExamAttendanceController::class, 'add'])->name('add');
        Route::post('submit', [ExamAttendanceController::class, 'submit'])->name('submit');
        Route::get('list', [ExamAttendanceController::class, 'list'])->name('list');
//        Route::get('details/{id}', [ExamAttendanceController::class, 'details'])->name('details');
        Route::get('edit/{id}', [ExamAttendanceController::class, 'edit'])->name('edit');
        Route::post('update', [ExamAttendanceController::class, 'update'])->name('update');
        Route::post('remove', [ExamAttendanceController::class, 'remove'])->name('remove');
        Route::get('details/{id}', [ExamAttendanceController::class, 'details'])->name('details');
        Route::get('print/{id}', [ExamAttendanceController::class, 'print'])->name('print');

    });

    Route::get('get-schedule-by-batch', [ClassScheduleController::class, 'getSchedule'])->name('get-schedule-by-batch');

});
