<?php

use App\Http\Controllers\TestimonialController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\CourseEnrollmentController;
use App\Http\Controllers\StudentController;


Route::prefix('student')->name('student.')->group(function () {
    Route::get('/sign-in', [StudentController::class, 'studentSignIn'])->name('sign-in');
    Route::get('/sign-up', [StudentController::class, 'studentSignUp'])->name('sign-up');
    Route::get('/verify-email', [StudentController::class, 'emailVerify'])->name('email.verification');
    Route::get('/verification-code/resend', [StudentController::class, 'resendCode'])->name('verification-code.resend');
    Route::post('/verify-email/submit', [StudentController::class, 'verificationSubmit'])->name('email.verify');
    Route::post('/sign-in/submit', [StudentController::class, 'studentSignInSubmit'])->name('sign-in.submit');
    Route::post('/sign-up/submit', [StudentController::class, 'studentSignUpSubmit'])->name('sign-up.submit');
    Route::get('/check/enroll/{id}', [CourseEnrollmentController::class, 'enrollCheck'])->name('enroll');


    Route::prefix('forget-password')->name('forget-password.')->group(function () {
        Route::get('/', [StudentController::class, 'forgetPassword'])->name('view');
        Route::post('/send-code', [StudentController::class, 'forgetPasswordSubmit'])->name('send-code');
        Route::get('/verify', [StudentController::class, 'forgetPasswordVerify'])->name('verify');
        Route::post('/verify/submit', [StudentController::class, 'forgetPasswordVerification'])->name('verify.submit');

    });
    Route::get('/password/change', [StudentController::class, 'passwordChange'])->name('password.change');
    Route::post('/password/update', [StudentController::class, 'passwordUpdate'])->name('password.update');

    Route::middleware('student')->group(function () {
        Route::post('/payment', [CourseEnrollmentController::class, 'payment'])->name('course.pay');
        Route::post('/course/enroll', [CourseEnrollmentController::class, 'store'])->name('course.enroll');
        Route::get('/dashboard', [StudentController::class, 'dashboard'])->name('dashboard');
        Route::get('/profile/edit', [StudentController::class, 'edit'])->name('profile.edit');
        Route::get('/password/get', [StudentController::class, 'getPassword'])->name('get-password');
        Route::post('/profile/update', [StudentController::class, 'profileUpdate'])->name('profile.update');
        Route::get('/courses', [StudentController::class, 'courses'])->name('courses');
        Route::get('/course/curriculum/{slug}', [StudentController::class, 'curriculum'])->name('curriculum');
        Route::get('/notices', [StudentController::class, 'notice'])->name('notice');
        Route::get('/review/course/{slug}', [StudentController::class, 'reviewCourse'])->name('course.review');
        Route::post('/review/submit', [TestimonialController::class, 'submit'])->name('review.submit');
    });


});
