@extends('admin.master')
@section('title')
    Course Schedule
@endsection
@section('content')
    @php $route = Route::currentRouteName(); @endphp
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="text-center text-success">{{session('message')}}</h4>
                    <div class="d-flex justify-content-between">
                        <h3 class="text-center"><strong>View Classes</strong></h3>
                       @if(count($items) > 0 && $route == 'teacher.schedule.list')
                            <a href="{{route('teacher.schedule.edit', $items->first()->batch_id)}}" class=" ms-3 btn btn-success"  title="Edit Class Schedule"><i class="fa fa-pencil"> Edit Schedule</i></a>
                        @endif
                    </div>


                </div>
                <div class="card-body table-responsive">
                    <table class="table table-striped">
                        <tr>
                            <th>#</th>
                            <th>Course</th>
                            <th>Branch</th>
                            <th>Batch</th>
                            <th>Date</th>
                            <th>Time</th>
                            <th>Status</th>
                            <th>Action</th>

                        </tr>
                        @php $i=1; @endphp
                        @foreach($items as $item)
                            <tr>
                                <td>{{$i++}}</td>
                                <td>{{$item->course->course_name ?? 'N/A'}}</td>
                                <td>{{$item->branch->branch_name ?? 'N/A'}}</td>
                                <td>{{$item->batch->batch_name ?? 'N/A'}}</td>
                                <td width="150px">{{$item->date}}</td>
                                <td>{{$item->batch->time ?? 'N/A'}}</td>
                                <td>
                                    <div class="mt-2">
                                        <span class="{{$item->status == 1 ? 'bg-success':'bg-danger'}} p-2 text-white" style="border-radius:5px">
                                    {{$item->status == 1 ? 'Active':'Ended'}}</span>
                                    </div>
                                </td>

                                <td class="btn-group">
                                    @if($item->status == 1)
                                    <a href="{{$item->link}}" title="Join Class" class="btn btn-primary"><i class="fa fa-sign-in"></i></a>
                                    <a href="{{$item->link}}" data-toggle="modal" data-target="#exampleModal" title="End Class" class="btn btn-danger mx-2"><i class="fa fa-window-close"></i></a>
                                    @endif
                                    <!-- Button trigger modal -->


                                    <!-- Modal -->
                                    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                        <div class="modal-dialog" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="exampleModalLabel">Class Summary</h5>
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <form action="{{route('teacher.schedule.end')}}" method="post">
                                                    @csrf
                                                    <input type="hidden" name="id" value="{{$item->id}}">
                                                    <div class="modal-body">
                                                        <textarea name="summary" placeholder="Write Class Summary" id="" class="summernote form-control" cols="30" rows="10" required></textarea>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                                        <button type="submit" class="btn btn-primary">Save changes</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>

                                </td>

                            </tr>
                        @endforeach

                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection
@push('script')

    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.js"></script>
    <script>
        jQuery(document).ready(function() {
            jQuery('.summernote').summernote();
        });
    </script>
@endpush
