@extends('admin.master')
@section('title')
    @isset($item)Edit @else Add @endisset Class Schedule
@endsection
@section('content')
    <div class="card">
        <div class="card-header text-center">
            <h2><strong> @isset($item)Edit @else Add @endisset Class Schedule Form</strong></h2>
            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
            <h4 class="text-center text-danger">{{session('message')}}</h4>
            <h4 class="text-center text-info" id="course_date_container"></h4>
        </div>
        <div class="card-body card-block">
            @if(Auth::user()->role == 4)
              @php  $route = 'teacher'; @endphp
            @else
               @php $route = 'admin'; @endphp
            @endif
            <form action="@isset($item){{route($route.'.schedule.update')}}@else{{route($route.'.schedule.submit')}}@endisset" method="post">
                @csrf
                <input type="hidden" name="" id="total_class" value="">
                <input type="hidden" name="" id="class-counter" value="@isset($item){{count($item)}}@else{{1}}@endisset">
                <div class="row mb-3">
                    <div class="form-group col-md-6"><label for="company" class=" form-control-label">Course
                            <span class="text-danger">*</span></label>
                        <select name="course_id" id="course_id" class="form-control @error('branch_id') is-invalid @enderror" required>
                            <option value="" >Select Course</option>
                            @foreach($assigned_courses as $course)
                                <option value="{{$course->course_id}}" @isset($item){{$item->first()->course_id == $course->id ? 'selected': ''}}@endisset>{{$course->course->course_name}} ({{$course->course->course_code}})</option>
                            @endforeach
                        </select>
                        @error('course_id')
                        <div class="invalid-feedback" role="alert">{{$message}}</div>
                        @enderror
                    </div>
                    <div class="form-group col-md-6"><label for="company" class=" form-control-label">Batch
                            <span class="text-danger">*</span></label>
                        <select name="batch_id" id="batch_id" class="form-control @error('batch_id') is-invalid @enderror" required>
                            <option>Select Batch</option>
                            @isset($item)
                                <option value="{{$item->first()->batch_id}}" selected>{{$item->first()->batch->batch_name ?? ''}}</option>
                            @endisset
                        </select>
                        @error('batch_id')
                        <div class="invalid-feedback" role="alert">{{$message}}</div>
                        @enderror
                    </div>


                </div>

               @isset($item)
                   @foreach($item as $key=> $item)
                        <div class="row" id="class-{{$key+1}}">
                            <div class="form-group col-md-6"><label for="company" class=" form-control-label">Class Date
                                    <span class="text-danger">*</span> <span class="text-white bg-danger py-1 px-2 " onclick="removeClass({{$key+1}})"><i class="fa fa-minus"></i></span></label>
                                <input type="date" name="date[]" id="company" value="{{$item->date}}" class="form-control"
                                       required>
                                @error('date')
                                <div class="invalid-feedback" role="alert">{{$message}}</div>
                                @enderror
                            </div>
                            <div class="form-group col-md-6"><label for="company" class=" form-control-label">Class Link
                                    <span class="text-danger">*</span></label>
                                <input type="url" id="company" name="link[]"
                                       class="form-control" value="{{$item->link}}">
                                @error('link')
                                <div class="invalid-feedback" role="alert">{{$message}}</div>
                                @enderror
                            </div>
                        </div>
                   @endforeach
                @else
                    <div class="row">
                        <div class="form-group col-md-6"><label for="company" class=" form-control-label">Class Date
                                <span class="text-danger">*</span></label>
                            <input type="date" name="date[]" id="company" class="form-control"
                                   required>
                            @error('date')
                            <div class="invalid-feedback" role="alert">{{$message}}</div>
                            @enderror
                        </div>
                        <div class="form-group col-md-6"><label for="company" class=" form-control-label">Class Link
                                <span class="text-danger">*</span></label>
                            <input type="url" id="company" name="link[]"
                                   class="form-control" value="" required>
                            @error('link')
                            <div class="invalid-feedback" role="alert">{{$message}}</div>
                            @enderror
                        </div>
                    </div>
                @endisset
                <div id="class_container">

                </div>
                <div class="row mb-3">
                    <div class="col-md-12 d-flex justify-content-end"><a class="btn btn-primary"
                                                                       id="addClassBtn"><i class="fa fa-plus"></i> Add Class</a></div>
                </div>

                <div class="row mb-3">
                    <div class="form-group col-md-12">
                        <label for="" class="form-control-label"></label>
                        <button type="submit" class="btn btn-primary form-control">@isset($item)Update @else Add @endisset Class Schedule</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection

@push('script')
    <script>
        jQuery(document).ready(function () {
            // alert();
            jQuery('#course_id').change(function () {

                var course_id = jQuery('#course_id').val();
                jQuery('#batch_id').empty()
                if(course_id != ''){
                    jQuery.ajax({
                        method: 'GET',
                        url: '{{route('teacher.get-course')}}',
                        data:{
                            course_id: course_id
                        },
                        success: function (data){
                            console.log('data');
                            var text = 'The Classes Starts From ' + data.start_date;
                            if(data != null){
                                jQuery('#total_class').val(data.total_lectures);
                                jQuery('#course_date_container').text(text)
                            }
                        }
                    });

                    jQuery.ajax({
                        method: 'GET',
                        url: '{{route('get-batch-by-course')}}',
                        data: {
                            course_id: course_id,
                        },
                        success:function (data) {
                            console.log('date',data);
                            var html = ``;
                            jQuery.each(data, function (key, data) {
                                html += `<option value="${data.id}">${data.batch_name} (${data.time})</option>`;
                            })

                            jQuery('#batch_id').append(html);
                        }
                    })
                }
            });
        })
    </script>
    <script>
        jQuery('#addClassBtn').click(function () {
            event.preventDefault();
            var counter = parseInt(jQuery('#class-counter').val());
            var total_class = jQuery('#total_class').val();
            if(counter == total_class){
                alert('Cannot Add More Classes');
            }
            else{
                counter++;
                jQuery('#class-counter').val(counter);
                var html = `
                <div class="row " id="class-${counter}">
                        <div class="form-group col-md-6"><label for="company" class=" form-control-label">Class Date
                                <span class="text-danger">*</span> <span class="text-white bg-danger py-1 px-2 " onclick="removeClass(${counter})"><i class="fa fa-minus"></i></span></label>
                            <input type="date" name="date[]" id="company" class="form-control"
                                    required>

                </div>
                <div class="form-group col-md-6"><label for="company" class=" form-control-label">Class Link
                        <span class="text-danger">*</span></label>
                    <input type="url" id="company" name="link[]"
                           class="form-control">

                </div>
            </div>`;
                           console.log(html);
                jQuery('#class_container').append(html);
            }
        })
    </script>
    <script>
        function removeClass(count){
            jQuery('#class-'+count).remove();
        }
    </script>
@endpush
