@extends('admin.master')
@section('title')
    Assigned Batch List
@endsection
@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">

                    <div class="row">
                        <div class="col-md-10">
                            <h4 class="text-center text-success">{{session('message')}}</h4>
                            <h3 class="text-center"><strong>View Assigned Batch List</strong></h3>
                        </div>
                    </div>

                    <hr>
                    <form action="" id="filterForm">
                        <div class="row mb-3">
                            <div class="form-group col-sm-5"><label for="" class="form-control-label">Status</label>
                                <select name="course_status_id" onchange="filter()" id="" class="form-control">
                                    <option value="">All</option>
                                    <option value="1" @isset($_GET['course_status_id']){{$_GET['course_status_id'] == '1' ? 'selected':''}}@endisset>Active</option>
                                    <option value="0" @isset($_GET['course_status_id']){{$_GET['course_status_id'] == '0' ? 'selected':''}}@endisset>Inactive</option>
                                </select>

                            </div>
                            <div class="form-group col-sm-5"><label for="" class="form-control-label">Course Type</label>
                                <select name="course_type" onchange="filter()" id="" class="form-control">
                                    <option value="">All</option>
                                    <option value="online"
                                    @isset($_GET['course_type']){{$_GET['course_type'] == 'online' ? 'selected':''}}@endisset>
                                        Offline</option>
                                    <option value="offline" @isset($_GET['course_type']){{$_GET['course_type'] == 'offline' ? 'selected':''}}@endisset
                                    >Online</option>
                                </select>
                            </div>

                        </div>

                    </form>
                </div>
                <div class="card-body">
                    <table class="table table-striped">
                        <tr>
                            <th>#</th>
                            <th>Course Name<br><span class="second-line">Course Code</span></th>
                            <th>Branch Name</th>
                            <th>Batch Name</th>
                            <th>Duration<br><span class="second-line">Lectures</span></th>
                            <th><span class="second-line">Type</span></th>
                            <th><span class="second-line">Total Students</span></th>
                            <th><span class="second-line">Status</span></th>
                            <th>Action</th>
                        </tr>
                        @php $i=1; @endphp
                        @foreach($items as $item)
                            <tr>
                                <td>{{$i++}}</td>
                                <td>{{$item->course->course_name ?? ''}}<br><span>{{$item->course->course_code ?? ''}}</span></td>
                                <td>{{$item->branch->branch_name ?? ''}}</td>
                                <td>{{$item->batch_name ?? ''}}</td>
                                <td>{{$item->course->course_duration}}<br><span>{{$item->course->total_lectures}}</span></td>
                                <td><span>{{ $item->course->course_type}} <br></span><a href="{{$item->course->course_type == 'online' ? $item->course->course_link:''}}">{{$item->course->course_type == 'online' ? $item->course->course_link:''}}</a></td>

                                <td class="text-center">
                                    <span>{{count(getStudentsByBatchId($item->id))}}</span>
                                    </td>
                                <td class="text-center">@if($item->completion_request == 1 ) Completion Requested @elseif($item->status == 1)Ongoing @elseif($item->status == 3) Completed @else Inactive @endif </td>
                                <td class="btn-group">
                                    <a href="{{route('teacher.student.list.by-batch', $item->id)}}" class=" ms-3 btn btn-primary"  title="View Students"><i class="fa fa-users"></i></a>
                                    <a href="{{route('teacher.schedule.list', $item->id)}}" class="btn btn-success mx-1" title="View Class Schedule"><i class="fa fa-calendar"></i></a>
                                @if($item->status != 4  && $item->completion_request != 1)
                                        <a href="{{route('teacher.batch.complete.request', $item->id)}}" class="btn btn-info" title="Complete Course"><i class="fa fa-check"></i></a>
                                    @endif
                                </td>

                            </tr>
                        @endforeach
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection
