@extends('frontend.master')
@section('title')
Profile Edit
@endsection
@section('content')
<!-- =======================
Page Banner START -->
@php
    $user = findUser();
    $enrolled_course_count = getEnrolledCourses()->get();
@endphp
@include('frontend.student.include.header')
<!-- =======================
Page Banner END -->

<!-- =======================
Page content START -->
<section class="pt-0">
	<div class="container">
		<div class="row">

			@include('frontend.student.include.sidebar')

			<div class="col-xl-9">
				<!-- Edit profile START -->
				<div class="card bg-transparent border rounded-3">
					<!-- Card header -->
					<div class="card-header bg-transparent border-bottom">
						<h3 class="card-header-title mb-0">Edit Profile</h3>
                        @if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif
					</div>
					<!-- Card body START -->
					<div class="card-body">
						<!-- Form -->
						<form class="row g-4" action="{{ route('student.profile.update') }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <input type="hidden" name="id" value="{{ $item->id }}">
                            <input type="hidden" name="password" value="{{ $item->password }}">
							<!-- Profile picture -->
							<div class="col-12 justify-content-center align-items-center">
								<label class="form-label">Profile Picture</label>
								<div class="d-flex align-items-center">
									<label class="position-relative me-4" for="uploadfile-1" title="Replace this pic">
										<!-- Avatar place holder -->


										@if ($item->student_image == Null)
                                        <span class="avatar avatar-xl">
											<img id="uploadfile-1-preview" class="avatar-img rounded-circle border border-white border-3 shadow" src=" {{ asset('admin-assets') }}/images/default.jpg" alt="">
										</span>
                                        @else
                                        <span class="avatar avatar-xl">
											<img id="uploadfile-1-preview" class="avatar-img rounded-circle border border-white border-3 shadow" src="{{ asset($item->student_image) }}" alt="">
										</span>
                                        @endif
										<!-- Remove btn -->
										{{-- <button type="button" class="uploadremove"><i class="bi bi-x text-white"></i></button> --}}
									</label>
									<!-- Upload button -->
									<label class="btn btn-primary-soft mb-0" for="uploadfile-1">Change</label>
									<input id="uploadfile-1" name="student_image" class="form-control d-none" type="file" accept="image/*" onchange="readURL(this)">
                                    @error('student_image')
                                    <div class="invalid-feedback" role="alert">{{ $message }}</div>
                                    @enderror
								</div>
							</div>

							<!-- Full name -->
							<div class="col-12">
								<label class="form-label">Full Name<span style="color:red">*</span></label>
								<div class="input-group">
									<input type="text" name="student_name" class="form-control @error('student_name') is-invalid @enderror"  placeholder="Full Name" value="{{ $item->student_name }}" required>
                                    @error('student_name')
                                    <div class="invalid-feedback" role="alert">{{ $messsage }}</div>
                                    @enderror

								</div>
							</div>

							<!-- Username -->
							<div class="col-md-6">
								<label class="form-label">Father's Name</label>
								<div class="input-group">

									<input type="text" name="father_name" class="form-control @error('father_name') is-invalid @enderror" value="{{ $item->father_name }}">
                                   
								</div>
							</div>
                            <!-- Location -->
							<div class="col-md-6">
								<label class="form-label">Mother's Name</label>
								<input name="mother_name" class="form-control @error('mother_name') is-invalid @enderror" type="text" value="{{ $item->mother_name }}">
                                
							</div>

							<!-- Email id -->
							<div class="col-md-6">
								<label class="form-label">Email Address<span style="color:red">*</span></label>
								<input name="student_email" class="form-control @error('student_email') is-invalid @enderror" type="email" value="{{ $item->student_email }}" placeholder="Email">
                                @error('student_email')
                                <div class="invalid-feedback" role="alert">{{ $messsage }}</div>
                                @enderror
							</div>

							<!-- Phone number -->
							<div class="col-md-6">
								<label class="form-label">Phone Number<span style="color:red">*</span></label>
								<input type="text" name="student_phone" class="form-control @error('student_phone') is-invalid @enderror" value="{{ $item->student_phone }}" placeholder="Phone number" required>
                                @error('student_phone')
                                <div class="invalid-feedback" role="alert">{{ $messsage }}</div>
                                @enderror
							</div>



							<!-- Save button -->
							<div class="d-sm-flex justify-content-end">
								<button type="submit" class="btn btn-primary mb-0">Save changes</button>
							</div>
						</form>
					</div>
					<!-- Card body END -->
				</div>
				<!-- Edit profile END -->

				<div class="row g-4 mt-3">



                    <form action="{{ route('student.password.update') }}" id='passwordChangeForm'  method="POST">
                        @csrf
                        <div class="col-xl-9">
                            <div class="card border bg-transparent rounded-3">
                                <!-- Card header -->
                                <div class="card-header bg-transparent border-bottom">
                                    <h5 class="card-header-title mb-0">Update Password</h5>
                                </div>
                                <!-- Card body START -->
                                <div class="card-body">
                                    <!-- Current password -->
                                    <div class="mb-3">
                                        <label class="form-label">Current Password</label>
                                        <input class="form-control" id="current_password"  type="password" placeholder="Enter Current Password">
                                        <div > <span id="password_error" class="text-danger"></span></div>
                                    </div>
                                    <!-- New password -->
                                    <div class="mb-3">
                                        <label class="form-label"> Enter New Password</label>
                                        <div class="input-group">
                                            <input name="password" class="form-control" type="password" placeholder="Enter New Password">
                                            {{-- <span class="input-group-text p-0 bg-transparent">
                                                <i class="far fa-eye cursor-pointer p-2 w-40px"></i>
                                            </span> --}}
                                        </div>
                                        <div class="rounded mt-1" id="psw-strength"></div>
                                    </div>
                                    <!-- Confirm password -->
                                    <div>
                                        <label class="form-label">Confirm New Password</label>
                                        <input name="password_confirmation" class="form-control" type="password" placeholder="Enter New Password">
                                    </div>
                                    <!-- Button -->
                                    <div class="d-flex justify-content-end mt-4">
                                        <button type="submit" onclick="return checkPassword()"   class="btn btn-primary mb-0">Change password</button>
                                    </div>
                                </div>
                                <!-- Card body END -->
                            </div>
                        </div>
                    </form>
					<!-- Password change START -->

					<!-- Password change end -->
				</div>
			</div>
		</div>
	</div>
</section>
<!-- =======================
Page content END -->
@endsection
@push('js')
<script>
    function readURL(input) {
    if (input.files && input.files[0]) {

        var reader = new FileReader();
        reader.onload = function (e) {
            document.querySelector("#uploadfile-1-preview").setAttribute("src",e.target.result);
        };

        reader.readAsDataURL(input.files[0]);
    }
}
</script>
<script>
    function checkPassword(){
        event.preventDefault();
        var password = $('#current_password').val();
        if(password != null){
            $.ajax({
            type: 'GET',
            url: '{{ route('student.get-password') }}',
            dataType: 'json',
            data:{
                id: {{ Auth::user()->id }},
            },
            success: function(data) {
                if(password != data){
                    $('#password_error').text('Password Does not Match');

                    return false;
                }
                else{
                    $('#passwordChangeForm').submit();
                    return true;
                }
            }
        });
        }

    }
</script>

@endpush
