@extends('frontend.master')
@section('title')
    Course Curriculum
@endsection
@section('content')
    <!-- =======================
        Page Banner START -->
    @php
        $user = findUser();
        $enrolled_course_count = getEnrolledCourses()->get();
    @endphp
    @include('frontend.student.include.header')
    <!-- =======================
        Page Banner END -->

    <!-- =======================
        Page content START -->
    <section class="pt-0">
        <div class="container">
            <div class="row">
                @include('frontend.student.include.sidebar')


                <!-- Main content START -->
                <div class="col-xl-9">
                    <div class="col-12">
                        <!-- Title -->
                        <h2>{{ $item->course_name }}</h2>
                        {{-- <p>Satisfied conveying a dependent contented he gentleman agreeable do be. Warrant private blushes removed an in equally totally if. Delivered dejection necessary objection do Mr prevailed. Mr feeling does chiefly cordial in do.</p> --}}
                        <!-- Content -->
                        {{-- <ul class="list-inline mb-0">
                            <li class="list-inline-item fw-light h6 me-3 mb-1 mb-sm-0"><i class="fas fa-star me-2"></i>4.5/5.0</li>
                            <li class="list-inline-item fw-light h6 me-3 mb-1 mb-sm-0"><i class="fas fa-user-graduate me-2"></i>12k Enrolled</li>
                            <li class="list-inline-item fw-light h6 me-3 mb-1 mb-sm-0"><i class="fas fa-signal me-2"></i>All levels</li>
                            <li class="list-inline-item fw-light h6 me-3 mb-1 mb-sm-0"><i class="bi bi-patch-exclamation-fill me-2"></i>Last updated 09/2021</li>
                            <li class="list-inline-item fw-light h6"><i class="fas fa-globe me-2"></i>English</li>
                        </ul> --}}
                    </div>
                    @if (count($resources) > 0)
                        <div class="col-12 mt-3">
                            <div class="card border rounded-3">
                                <!-- Card header START -->
                                <div class="card-header border-bottom">
                                    <h3 class="mb-0">Course Content</h3>
                                </div>
                                <!-- Card header END -->

                                <!-- Card body START -->
                                <div class="card-body">
                                    <div class="row g-5">
                                        <!-- Lecture item START -->
                                        <div class="col-12">
                                            <!-- Curriculum item -->
                                            @php $prev_resource_type = $resources->first()->type; @endphp
                                            @foreach ($resources as $key => $resource)

                                                <div class="mb-3">
                                                    @if($resource->type != $prev_resource_type)
                                                        <hr>
                                                        @php $prev_resource_type = $resource->type @endphp
                                                    @endif
{{--                                                    <h5 class="mb-4">--}}
{{--                                                        @if ($resource->type == 'video')--}}
{{--                                                            Video--}}
{{--                                                        @elseif($resource->type == 'note')--}}
{{--                                                            Note--}}
{{--                                                        @elseif($resource->type == 'discussion')--}}
{{--                                                            Discussion--}}
{{--                                                        @endif--}}
{{--                                                    </h5>--}}
                                                    <div class="d-sm-flex justify-content-sm-between align-items-center">
                                                        <div class="d-flex">
                                                            @if ($resource->type == 'video')
                                                               <span class=" btn-danger-soft btn-round mb-0">
                                                                    <i class=" fas fa-play"></i>
                                                                @elseif($resource->type == 'discussion')
                                                                    <span
                                                                        class=" btn-primary-soft btn-round mb-0">
                                                                        <i class="fa fa-blog"></i>
                                                                    @else
                                                                        <span
                                                                            class="btn-warning-soft btn-round mb-0">
                                                                            <i class="fa fa-book"></i>
                                                            @endif
                                                            </span>
                                                            <div class="ms-2 ms-sm-3 mt-1 mt-sm-0">

                                                                @if ($resource->type == 'video')
                                                                    <h6 class="mb-0 mt-2"> <a
                                                                            href="{{ $resource->resource }}">{{ $resource->title }}</a>
                                                                    </h6>
                                                                @elseif($resource->type == 'note')
                                                                    <h6 class="mb-0 mt-2"><a
                                                                            href="{{ env('app_url') }}/{{ $resource->resource }}"
                                                                            target="_blank">
                                                                            {{ Str::after($resource->resource, 'uploads/course-files/') }}</a>
                                                                    </h6>
                                                                @else
                                                                    <h6 class="mb-0 mt-2">
                                                                        {{ $resource->title }}</h6>
                                                                    {{ $resource->resource }}
                                                                @endif
                                                            </div>
                                                        </div>


                                                        <!-- Button -->
                                                        @if ($resource->type == 'video')
                                                            <a href="{{ $resource->resource }}"
                                                                class="btn btn-sm btn-success mb-0">Play</a>
                                                        @endif
                                                    </div>
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                </div>
                                <!-- Card body START -->
                            </div>
                        </div>
                    @endif
                    <div class="col-xl-12 mt-3">
                        <div class="card bg-transparent border rounded-3">
                            <!-- Card header START -->
                            <div class="card-header bg-transparent border-bottom">
                                <h3 class="mb-0">Completed Classes</h3>
                            </div>
                            <!-- Card header END -->

                            <!-- Card body START -->
                            <div class="card-body">


                                <!-- Course list table START -->
                                <div class="table-responsive border-0">
                                    <table class="table table-dark-gray align-middle p-4 mb-0 table-hover">
                                        <!-- Table head -->
                                        <thead>
                                        <tr>
                                            <th scope="col" class="border-0 rounded-start">Class Title</th>
                                            <th scope="col" class="border-0">Held On</th>
                                            <th scope="col" class="border-0 text-center rounded-end">Action</th>
                                        </tr>
                                        </thead>

                                        <!-- Table body START -->
                                        <tbody>
                                        @if(count($completed_classes) >0)
                                            @foreach ($completed_classes as $key=> $item)
{{--                                                @php--}}
{{--                                                    $content = getCourseContent($item->id);--}}
{{--                                                    $completion_percent = 100;--}}
{{--                                                    if($item->total_content > 0){--}}
{{--                                                        $completion_percent = ($item->completed_content/$item->total_content)*100;--}}
{{--                                                    }--}}

{{--                                                @endphp--}}

                                                <tr>
                                                    <!-- Table data -->
                                                    <td>Class-{{ $key+1 }}</td>
                                                    <td>{{ date('d M, Y', strtotime($item->created_at)) }}</td>
                                                    <!-- Table data -->


                                                    <!-- Table data -->
                                                    {{-- <td>{{ $item->completed_content }}</td> --}}

                                                    <!-- Table data -->
                                                    <td class="text-center">
{{--                                                        <button class="btn btn-sm btn-success-soft me-1 mb-1 mb-md-0"><i class="fa fa-sticky-note me-2"></i>View Notes</button>--}}
                                                        <!-- Button trigger modal -->
                                                        <button type="button" class="btn btn-primary modalView" data-bs-toggle="modal" data-bs-target="#noteModal{{$item->id}}">
                                                            <i class="fa fa-sticky-note me-2"></i>View Notes
                                                        </button>

                                                        <!-- Modal -->
                                                        <div class="modal fade" id="noteModal{{$item->id}}" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                                            <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
                                                                <div class="modal-content">
                                                                    <div class="modal-header">
                                                                        <h1 class="modal-title fs-5" id="exampleModalLabel">Modal title</h1>
                                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                                    </div>
                                                                    <div class="modal-body">
                                                                        {!! $item->summary !!}
                                                                    </div>
{{--                                                                    <div class="modal-footer">--}}
{{--                                                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>--}}
{{--                                                                        <button type="button" class="btn btn-primary">Save changes</button>--}}
{{--                                                                    </div>--}}
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </td>

                                                </tr>

                                            @endforeach
                                        @else
                                            <tr>
                                                <td colspan="4" class="text-center">No Notes Available</td>
                                            </tr>
                                        @endif

                                        <!-- Table item -->

                                        </tbody>
                                        <!-- Table body END -->
                                    </table>
{{--                                    {{$enrolled_courses->links('pagination::bootstrap-5')}}--}}
                                </div>
                                <!-- Course list table END -->


                            </div>
                            <!-- Card body START -->
                        </div>
                        <!-- Main content END -->
                    </div><!-- Row END -->
                </div><!-- Row END -->
            </div>
        </div>
    </section>
    <!-- =======================
        Page content END -->
@endsection
@push('js')
    <script >
        $('.modalView').click(function () {
            // alert('ok');
            $('.modal-backdrop').remove();
        })
    </script>
@endpush
