@extends('frontend.master')
@section('title')
    All Offers
@endsection

@section('meta')
    <meta name="title" content="Freelancing-Career in Bangladesh: From Learning to Earning">
    <meta name="description" content="Start your freelancing career with expert-led courses on in-demand skills and live projects. Get certified and have a chance to join our agency!">
    <meta name="keywords" content="freelancing career courses in Bangladesh">
    
    <meta name="og:title" content="Freelancing-Career in Bangladesh: From Learning to Earning">
    <meta name="og:image" content="{{asset('frontend-assets')}}/images/meta_image.png">
@endsection


@section('content')
    <!-- =======================
Page Banner START -->
    <section class="bg-dark align-items-center d-flex" style="background:url({{asset('frontend-assets')}}/images/04.png) no-repeat center center; background-size:cover;">
        <!-- Main banner background image -->
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <!-- Title -->
                    <h1 class="text-white">All Offers</h1>
                    <!-- Breadcrumb -->
                    <div class="d-flex">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb breadcrumb-dark breadcrumb-dots mb-0">
                                <li class="breadcrumb-item"><a href="{{route('home')}}">Home</a></li>
                                <li class="breadcrumb-item " aria-current="page">Offers</li>
                                <li class="breadcrumb-item active" aria-current="page">All</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- =======================
    Page Banner END -->

    <!-- =======================
    Page content START -->
    <section class="pb-0 py-sm-5">
        <div class="container">
{{--            <!-- Title and select START -->--}}
{{--            <div class="row g-3 align-items-center mb-4">--}}
{{--                <!-- Content -->--}}
{{--                <div class="col-md-4">--}}
{{--                    <h4 class="mb-0">Showing 1-7 of 32 result</h4>--}}
{{--                </div>--}}

{{--                <!-- Select option -->--}}
{{--                <div class="col-md-8">--}}
{{--                    <div class="row g-3 align-items-center justify-content-md-end me-auto">--}}

{{--                        <!-- List and Grid icon -->--}}
{{--                        <div class="col-sm-4 col-xl-6 text-md-end d-none d-md-block">--}}
{{--                            <ul class="list-inline mb-0">--}}
{{--                                <!-- Grid icon -->--}}
{{--                                <li class="list-inline-item"><a href="course-grid.html" class="btn btn-outline-light mb-0 me-2"><i class="fas fa-fw fa-th-large"></i></a></li>--}}
{{--                                <!-- list icon -->--}}
{{--                                <li class="list-inline-item"><a href="course-list.html" class="btn btn-outline-light mb-0 me-2"><i class="fas fa-fw fa-list-ul"></i></a></li>--}}
{{--                            </ul>--}}
{{--                        </div>--}}

{{--                        <!-- Short by filter -->--}}
{{--                        <form class="col-md-4 border rounded p-1 input-borderless">--}}
{{--                            <select class="form-select js-choice z-index-9" aria-label=".form-select-sm">--}}
{{--                                <option value="">Sort by</option>--}}
{{--                                <option>Free</option>--}}
{{--                                <option>Newest</option>--}}
{{--                                <option>Most popular</option>--}}
{{--                                <option>Most Viewed</option>--}}
{{--                            </select>--}}
{{--                        </form>--}}

{{--                        <!-- Advanced filter responsive toggler START -->--}}
{{--                        <div class="col-4 text-md-end">--}}
{{--                            <button class="btn btn-primary mb-0 d-xl-none" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasSidebar" aria-controls="offcanvasSidebar">--}}
{{--                                <i class="fas fa-sliders-h me-1"></i> Show filter--}}
{{--                            </button>--}}
{{--                        </div>--}}
{{--                        <!-- Advanced filter responsive toggler END -->--}}

{{--                    </div>--}}
{{--                </div>--}}
{{--            </div>--}}
{{--            <!-- Title and select END -->--}}

            <div class="row">
                <!-- Main content START -->
                <div class="col-xl-12 col-xxl-12">

                    <!-- Course list START -->
                    <div class="row g-4">
                        @if(count($items) > 0)
                        @else
                            <div class="col-12 text-center">
                                <h3 class="text-primary">
                                    No Offers Available. Keep An Eye For Our Upcoming Offers.
                                </h3>
                            </div>
                        @endif
                        @foreach($items as $item)
                            <!-- Card list START -->
                            <div class="col-12">
                                <div class="card shadow overflow-hidden p-2">
                                    <div class="row g-0">
                                        <div class="col-md-5 overflow-hidden">
                                            <img src="{{asset($item->image)}}" class="rounded-2" alt="Card image">
                                            <!-- Ribbon -->
{{--                                            <div class="card-img-overlay">--}}
{{--                                                <div class="ribbon"><span>Free</span></div>--}}
{{--                                            </div>--}}
                                        </div>
                                        <div class="col-md-7">
                                            <div class="card-body">
                                                <!-- Badge and rating -->
                                                <div class="d-flex justify-content-between align-items-center mb-2">
                                                    <!-- Badge -->
{{--                                                    <a href="#" class="badge text-bg-primary mb-2 mb-sm-0">Development</a>--}}
                                                    <!-- Rating and wishlist -->
{{--                                                    <div>--}}
{{--                                                        <span class="h6 fw-light me-3"><i class="fas fa-star text-warning me-1"></i>4.5</span>--}}
{{--                                                        <a href="#" class="text-danger"><i class="fas fa-heart"></i></a>--}}
{{--                                                    </div>--}}
                                                </div>

                                                <!-- Title -->
                                                <h5 class="card-title"><a href="#">{{$item->title}} <span class="text-primary">{{$item->start_date > date('Y-m-d') ? '(Upcoming)':''}}</span></a></h5>
                                                <p class="text-truncate-2 d-none d-lg-block">{!! $item->description !!}</p>

                                                <!-- Info -->
                                                <ul class="list-inline">
                                                    <li class="list-inline-item h6 fw-light mb-1 mb-sm-0"><i class="far fa-clock text-danger me-2"></i>{{date('d M, Y', strtotime($item->start_date))}} - {{date('d M, Y', strtotime($item->end_date))}}</li>
                                                    <li class="list-inline-item h6 fw-light">
                                                        <i class="fas fa-hourglass-half text-warning me-2"></i> <span class="fw-bold">{{$item->start_date > date('Y-m-d') ? 'Starting In: ':'Ending In:'}}</span>
                                                        <span class="countdown-timer" data-end-date="{{$item->start_date > date('Y-m-d') ? $item->start_date:$item->end_date}}"></span>
                                                    </li>
{{--                                                    <li class="list-inline-item h6 fw-light mb-1 mb-sm-0"><i class="fas fa-table text-orange me-2"></i>--}}
{{--                                                        <span class="coupon-code" data-bs-toggle="tooltip" title="Click to copy!"--}}
{{--                                                              data-coupon="{{ $item->coupon->coupon_code ?? '' }}">--}}
{{--                                                            {{$item->coupon->coupon_code ?? 'No Coupon'}}--}}
{{--                                                        </span>--}}
{{--                                                    </li>--}}
                                                    <li class="list-inline-item h6 fw-light"><i class="fas fa-users text-success me-2"></i>{{$item->coupon->total_use_limit ?? 0}} Coupon{{$item->coupon && $item->coupon->total_use_limit > 0 ? 's':''}} {{$item->start_date > date('Y-m-d') ? 'Available':'Remaining'}} <small class="text-danger">(Conditions Apply)</small></li>
                                                </ul>

                                                <!-- Price and avatar -->
                                                <div class="d-sm-flex justify-content-sm-{{$item->start_date <= date('Y-m-d') ? 'between':'end'}} align-items-center">
                                                    <!-- Price -->
                                                    @if($item->start_date <= date('Y-m-d'))
                                                        <div class="mt-3 mt-sm-0">
                                                            <h6 class="mb-0 border border-1 border-secondary d-flex justify-content-between align-items-center" style="border-radius: 0.325rem"><span class="mx-3">{{$item->coupon->coupon_code ?? 'No Coupon'}}</span>
                                                                <span class="btn btn-primary coupon-code mb-0 rounded-end"  data-coupon="{{ $item->coupon->coupon_code ?? '' }}">
                                                <i class="fa fa-copy"></i>
                                            </span>
                                                            </h6>
                                                            {{--                                                        <button  class="coupon-code btn btn-primary" data-coupon="{{ $item->coupon->coupon_code ?? '' }}">Copy Code</button>--}}
                                                        </div>
                                                    @endif
                                                    <div class="mt-3 mt-sm-0">
                                                        <a href="{{route('offer.details', $item->slug)}}" class="btn btn-dark">View Details</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- Card list END -->
                        @endforeach


                    </div>
                    <!-- Course list END -->

                    <!-- Pagination START -->
                    <div class="col-12">
                        {{$items->links('pagination::bootstrap-5')}}
                    </div>
                    <!-- Pagination END -->
                </div>
                <!-- Main content END -->

{{--                <!-- Right sidebar START -->--}}
{{--                <div class="col-lg-3 col-xxl-4">--}}
{{--                    <!-- Responsive offcanvas body START -->--}}
{{--                    <div class="offcanvas-xl offcanvas-end" tabindex="-1" id="offcanvasSidebar">--}}
{{--                        <div class="offcanvas-header bg-light">--}}
{{--                            <h5 class="offcanvas-title" id="offcanvasNavbarLabel">Advance Filter</h5>--}}
{{--                            <button type="button" class="btn-close" data-bs-dismiss="offcanvas" data-bs-target="#offcanvasSidebar" aria-label="Close"></button>--}}
{{--                        </div>--}}
{{--                        <div class="offcanvas-body p-3 p-xl-0">--}}
{{--                            <form>--}}
{{--                                <!-- Category START -->--}}
{{--                                <div class="card card-body shadow p-4 mb-4">--}}
{{--                                    <!-- Title -->--}}
{{--                                    <h4 class="mb-4">Category</h4>--}}
{{--                                    <div class="row">--}}
{{--                                        <!-- Category group -->--}}
{{--                                        <div class="col-xxl-6">--}}
{{--                                            <!-- Checkbox -->--}}
{{--                                            <div class="form-check">--}}
{{--                                                <input class="form-check-input" type="checkbox" value="" id="flexCheckDefault9">--}}
{{--                                                <label class="form-check-label" for="flexCheckDefault9">All</label>--}}
{{--                                            </div>--}}
{{--                                            <!-- Checkbox -->--}}
{{--                                            <div class="form-check">--}}
{{--                                                <input class="form-check-input" type="checkbox" value="" id="flexCheckDefault10">--}}
{{--                                                <label class="form-check-label" for="flexCheckDefault10">Development</label>--}}
{{--                                            </div>--}}
{{--                                            <!-- Checkbox -->--}}
{{--                                            <div class="form-check">--}}
{{--                                                <input class="form-check-input" type="checkbox" value="" id="flexCheckDefault11">--}}
{{--                                                <label class="form-check-label" for="flexCheckDefault11">Design</label>--}}
{{--                                            </div>--}}
{{--                                            <!-- Checkbox -->--}}
{{--                                            <div class="form-check">--}}
{{--                                                <input class="form-check-input" type="checkbox" value="" id="flexCheckDefault12">--}}
{{--                                                <label class="form-check-label" for="flexCheckDefault12">Accounting</label>--}}
{{--                                            </div>--}}
{{--                                            <!-- Checkbox -->--}}
{{--                                            <div class="form-check">--}}
{{--                                                <input class="form-check-input" type="checkbox" value="" id="flexCheckDefault17">--}}
{{--                                                <label class="form-check-label" for="flexCheckDefault17">Translation</label>--}}
{{--                                            </div>--}}
{{--                                        </div>--}}

{{--                                        <!-- Category group -->--}}
{{--                                        <div class="col-xxl-6">--}}
{{--                                            <!-- Checkbox -->--}}
{{--                                            <div class="form-check">--}}
{{--                                                <input class="form-check-input" type="checkbox" value="" id="flexCheckDefault13">--}}
{{--                                                <label class="form-check-label" for="flexCheckDefault13">Finance</label>--}}
{{--                                            </div>--}}
{{--                                            <!-- Checkbox -->--}}
{{--                                            <div class="form-check">--}}
{{--                                                <input class="form-check-input" type="checkbox" value="" id="flexCheckDefault14">--}}
{{--                                                <label class="form-check-label" for="flexCheckDefault14">Legal</label>--}}
{{--                                            </div>--}}
{{--                                            <!-- Checkbox -->--}}
{{--                                            <div class="form-check">--}}
{{--                                                <input class="form-check-input" type="checkbox" value="" id="flexCheckDefault15">--}}
{{--                                                <label class="form-check-label" for="flexCheckDefault15">Photography</label>--}}
{{--                                            </div>--}}
{{--                                            <!-- Checkbox -->--}}
{{--                                            <div class="form-check">--}}
{{--                                                <input class="form-check-input" type="checkbox" value="" id="flexCheckDefault16">--}}
{{--                                                <label class="form-check-label" for="flexCheckDefault16">Writing</label>--}}
{{--                                            </div>--}}
{{--                                            <!-- Checkbox -->--}}
{{--                                            <div class="form-check">--}}
{{--                                                <input class="form-check-input" type="checkbox" value="" id="flexCheckDefault18">--}}
{{--                                                <label class="form-check-label" for="flexCheckDefault18">Marketing</label>--}}
{{--                                            </div>--}}
{{--                                        </div>--}}
{{--                                    </div><!-- Row END -->--}}
{{--                                </div>--}}
{{--                                <!-- Category END -->--}}

{{--                                <!-- Price START -->--}}
{{--                                <div class="card card-body shadow p-4 mb-4">--}}
{{--                                    <!-- Title -->--}}
{{--                                    <h4 class="mb-3">Price Level</h4>--}}
{{--                                    <ul class="list-inline mb-0">--}}
{{--                                        <!-- Price item -->--}}
{{--                                        <li class="list-inline-item">--}}
{{--                                            <input type="radio" class="btn-check" name="options" id="option1">--}}
{{--                                            <label class="btn btn-light btn-primary-soft-check" for="option1">All</label>--}}
{{--                                        </li>--}}
{{--                                        <!-- Price item -->--}}
{{--                                        <li class="list-inline-item">--}}
{{--                                            <input type="radio" class="btn-check" name="options" id="option2">--}}
{{--                                            <label class="btn btn-light btn-primary-soft-check" for="option2">Free</label>--}}
{{--                                        </li>--}}
{{--                                        <!-- Price item -->--}}
{{--                                        <li class="list-inline-item">--}}
{{--                                            <input type="radio" class="btn-check" name="options" id="option3">--}}
{{--                                            <label class="btn btn-light btn-primary-soft-check" for="option3">Paid</label>--}}
{{--                                        </li>--}}
{{--                                    </ul>--}}
{{--                                </div>--}}
{{--                                <!-- Price END -->--}}

{{--                                <!-- Skill level START -->--}}
{{--                                <div class="card card-body shadow p-4 mb-4">--}}
{{--                                    <!-- Title -->--}}
{{--                                    <h4 class="mb-3">Skill level</h4>--}}
{{--                                    <ul class="list-inline mb-0">--}}
{{--                                        <!-- Item -->--}}
{{--                                        <li class="list-inline-item mb-2">--}}
{{--                                            <input type="checkbox" class="btn-check" id="btn-check-12">--}}
{{--                                            <label class="btn btn-light btn-primary-soft-check" for="btn-check-12">All levels</label>--}}
{{--                                        </li>--}}
{{--                                        <!-- Item -->--}}
{{--                                        <li class="list-inline-item mb-2">--}}
{{--                                            <input type="checkbox" class="btn-check" id="btn-check-9">--}}
{{--                                            <label class="btn btn-light btn-primary-soft-check" for="btn-check-9">Beginner</label>--}}
{{--                                        </li>--}}
{{--                                        <!-- Item -->--}}
{{--                                        <li class="list-inline-item mb-2">--}}
{{--                                            <input type="checkbox" class="btn-check" id="btn-check-10">--}}
{{--                                            <label class="btn btn-light btn-primary-soft-check" for="btn-check-10">Intermediate</label>--}}
{{--                                        </li>--}}
{{--                                        <!-- Item -->--}}
{{--                                        <li class="list-inline-item mb-2">--}}
{{--                                            <input type="checkbox" class="btn-check" id="btn-check-11">--}}
{{--                                            <label class="btn btn-light btn-primary-soft-check" for="btn-check-11">Advanced</label>--}}
{{--                                        </li>--}}
{{--                                    </ul>--}}
{{--                                </div>--}}
{{--                                <!-- Skill level END -->--}}

{{--                                <!-- Language START -->--}}
{{--                                <div class="card card-body shadow p-4 mb-4">--}}
{{--                                    <!-- Title -->--}}
{{--                                    <h4 class="mb-3">Language</h4>--}}
{{--                                    <ul class="list-inline mb-0 g-3">--}}
{{--                                        <!-- Item -->--}}
{{--                                        <li class="list-inline-item mb-2">--}}
{{--                                            <input type="checkbox" class="btn-check" id="btn-check-2">--}}
{{--                                            <label class="btn btn-light btn-primary-soft-check" for="btn-check-2">English</label>--}}
{{--                                        </li>--}}
{{--                                        <!-- Item -->--}}
{{--                                        <li class="list-inline-item mb-2">--}}
{{--                                            <input type="checkbox" class="btn-check" id="btn-check-3">--}}
{{--                                            <label class="btn btn-light btn-primary-soft-check" for="btn-check-3">Francas</label>--}}
{{--                                        </li>--}}
{{--                                        <!-- Item -->--}}
{{--                                        <li class="list-inline-item mb-2">--}}
{{--                                            <input type="checkbox" class="btn-check" id="btn-check-4">--}}
{{--                                            <label class="btn btn-light btn-primary-soft-check" for="btn-check-4">Hindi</label>--}}
{{--                                        </li>--}}
{{--                                        <!-- Item -->--}}
{{--                                        <li class="list-inline-item mb-2">--}}
{{--                                            <input type="checkbox" class="btn-check" id="btn-check-5">--}}
{{--                                            <label class="btn btn-light btn-primary-soft-check" for="btn-check-5">Russian</label>--}}
{{--                                        </li>--}}
{{--                                        <!-- Item -->--}}
{{--                                        <li class="list-inline-item mb-2">--}}
{{--                                            <input type="checkbox" class="btn-check" id="btn-check-6">--}}
{{--                                            <label class="btn btn-light btn-primary-soft-check" for="btn-check-6">Spanish</label>--}}
{{--                                        </li>--}}
{{--                                        <!-- Item -->--}}
{{--                                        <li class="list-inline-item mb-2">--}}
{{--                                            <input type="checkbox" class="btn-check" id="btn-check-7">--}}
{{--                                            <label class="btn btn-light btn-primary-soft-check" for="btn-check-7">Bengali</label>--}}
{{--                                        </li>--}}
{{--                                        <!-- Item -->--}}
{{--                                        <li class="list-inline-item mb-2">--}}
{{--                                            <input type="checkbox" class="btn-check" id="btn-check-8">--}}
{{--                                            <label class="btn btn-light btn-primary-soft-check" for="btn-check-8">Portuguese</label>--}}
{{--                                        </li>--}}
{{--                                    </ul>--}}
{{--                                </div>--}}
{{--                                <!-- Language END -->--}}
{{--                            </form><!-- Form End -->--}}
{{--                        </div>--}}

{{--                        <!-- Button -->--}}
{{--                        <div class="d-grid p-2 p-xl-0 bg-body text-center">--}}
{{--                            <button class="btn btn-primary mb-0">Filter Results</button>--}}
{{--                        </div>--}}
{{--                    </div>--}}
{{--                    <!-- Responsive offcanvas body END -->--}}
{{--                </div>--}}
{{--                <!-- Right sidebar END -->--}}

            </div><!-- Row END -->
        </div>
    </section>
    <!-- =======================
    Page content END -->
@endsection
@push('js')
    <script>
        $(document).ready(function() {
            // Function to calculate and update the countdown timer
            function updateCountdown() {
                // Loop through each countdown-timer element
                $('.countdown-timer').each(function() {
                    // Get the end date from the data attribute
                    var endDateStr = $(this).data('end-date');
                    var endDate = new Date(endDateStr);

                    // Get the current date and time
                    var now = new Date();

                    // Calculate the difference in milliseconds
                    var diff = endDate - now;

                    // Convert milliseconds into days, hours, minutes, and seconds
                    var days = Math.floor(diff / (1000 * 60 * 60 * 24));
                    var hours = Math.floor((diff % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                    var minutes = Math.floor((diff % (1000 * 60 * 60)) / (1000 * 60));
                    var seconds = Math.floor((diff % (1000 * 60)) / 1000);

                    // Update the countdown timer text
                    if (diff > 0) {
                        $(this).text(days + "d " + hours + "h " + minutes + "m " + seconds + "s");
                    } else {
                        // If time is expired
                        $(this).text("Expired");
                    }
                });
            }

            // Update countdown every second
            setInterval(updateCountdown, 1000);
        });
    </script>
    <script>
        $(document).ready(function() {
            // Initialize Bootstrap tooltips
            $('[data-bs-toggle="tooltip"]').tooltip();

            // Function to copy coupon code to clipboard
            $(document).on('click', '.coupon-code', function() {
                // Get the coupon code from data attribute
                var couponCode = $(this).data('coupon');

                // Create a temporary input element to copy the text
                var tempInput = $('<input>');
                $('body').append(tempInput);
                tempInput.val(couponCode).select();
                document.execCommand('copy');
                tempInput.remove();

                // Update tooltip to show success message
                $(this).attr('title', 'Coupon Code Copied!').tooltip('show');

                // Revert back to the original tooltip after a short delay
                // var _this = $(this);
                // setTimeout(function() {
                //     _this.attr('title', 'Click to copy!').tooltip('hide');
                // }, 1500);
            });
        });
    </script>


@endpush
