@extends('frontend.master')
@section('title')
    Home
@endsection
@section('content')
    <!-- =======================
    Main Banner START -->
    <section class="pt-0 position-relative overflow-hidden h-700px h-sm-600px h-lg-700px rounded-top-4 mx-2 mx-md-4" style="background-image:url({{asset('frontend-assets')}}/images/03_2.jpg); background-position: center; background-size: cover;">
        <div class="bg-overlay bg-dark opacity-5"></div>
        <!-- SVG decoration for curve -->
        <figure class="position-absolute bottom-0 left-0 w-100 d-md-block mb-n3 z-index-9">
            <svg class="fill-body" width="100%" height="150" viewBox="0 0 500 150" preserveAspectRatio="none">
                <path d="M0,150 L0,40 Q250,150 500,40 L580,150 Z"></path>
            </svg>
        </figure>
        <!-- SVG decoration -->
        <!--<figure class="position-absolute top-0 start-50 translate-middle-x z-index-9 mt-5">-->
        <!--    <svg width="29px" height="29px">-->
        <!--        <path class="fill-orange" d="M29.004,14.502 C29.004,22.512 22.511,29.004 14.502,29.004 C6.492,29.004 -0.001,22.512 -0.001,14.502 C-0.001,6.492 6.492,-0.001 14.502,-0.001 C22.511,-0.001 29.004,6.492 29.004,14.502 Z"></path>-->
        <!--    </svg>-->
        <!--</figure>-->

        <div class="container z-index-9 position-relative">
            <!-- SVG decoration -->
            <!--<figure class="position-absolute bottom-0 end-0 z-index-9 ms-5 mb-5">-->
            <!--    <svg width="23px" height="23px">-->
            <!--        <path class="fill-primary" d="M23.003,11.501 C23.003,17.854 17.853,23.003 11.501,23.003 C5.149,23.003 -0.001,17.854 -0.001,11.501 C-0.001,5.149 5.149,-0.000 11.501,-0.000 C17.853,-0.000 23.003,5.149 23.003,11.501 Z"></path>-->
            <!--    </svg>-->
            <!--</figure>-->

            <div class="row py-0 py-md-5 align-items-center text-center text-sm-start">
                <div class="col-sm-10 col-lg-8 col-xl-6 all-text-white my-5 mt-md-0">
                    <div class="py-0 py-md-5 my-5">

                        <!-- Badge with content -->
                        <div class="d-inline-block bg-white px-3 py-2 rounded-pill mb-3">
                            <p class="mb-0 text-dark"><span class="badge text-bg-success rounded-pill me-1">New</span>	One to one video call using web browser</p>
                        </div>

                        <!-- Title -->
                        <h1 class="text-white display-5">Start learning from <span style="color: #066ac9">best institutions</span></h1>
                        <p class="text-white">Demesne far-hearted suppose venture excited see had has. Dependent on so extremely delivered by. Yet no jokes worse her why.</p>

                        <div class="d-sm-flex align-items-center mt-4">
                            <!-- Button -->
                            <a href="{{ route('student.sign-up') }}" class="btn btn-primary me-2 mb-4 mb-sm-0">Get Started</a>
                            <!-- Video button -->
                            <div class="d-flex align-items-center justify-content-center py-2 ms-0 ms-sm-4">
                                <a data-glightbox="" data-gallery="office-tour" href="#" class="btn btn-round btn-white-shadow text-danger me-7 mb-0 overflow-visible">
                                    <i class="fas fa-play"></i>
                                    <h6 class="mb-0 ms-3 text-white fw-normal position-absolute start-100 top-50 translate-middle-y">Watch video</h6>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- =======================
    Main Banner END -->
    <!-- =======================
    Course slider START -->
    <section>
        <div class="container">
            <div class="row">
{{--                <div class="col-lg-8 mb-4">--}}
{{--                    <h2 class="mb-0">Our <span class="text-primary">Recent Course</span> Categories</h2>--}}
{{--                </div>--}}
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="bg-light rounded-3 p-4">
                        <!-- Slider START -->
                        <div class="tiny-slider arrow-round arrow-creative arrow-blur arrow-hover py-1">
                            <div class="tiny-slider-inner" data-autoplay="true" data-gutter="80" data-arrow="true" data-dots="false" data-items="5" data-items-lg="3" data-items-md="2" data-items-xs="1">
                                @foreach ($course_categories as $category)
                                    <div>
                                        <div class="bg-body text-center rounded-2 border py-2 px-1 position-relative">
                                            <img src="{{asset($category->image)}}" class="h-40px" alt=""><br>
                                            <a href="{{ route('category.course', $category->id) }}" class="text-primary-hover stretched-link"><span class="h6 ms-2">{{ $category->name }}</span></a>
                                        </div>
                                    </div>
                                @endforeach
                                <!-- Item -->
                            </div>
                        </div>
                        <!-- Slider END -->
                    </div>
                </div>
            </div> <!-- Row END -->
        </div>
    </section>
    <!-- =======================
    Course slider END -->



    <!-- =======================
    Recent Course START -->
    <section class="pb-0 pb-md-5 bg-light">
        <div class="container">
            <!-- Title -->
            <div class="row mb-4">
                <h2 class="mb-0">Our <span class="text-primary">Recent</span> Courses</h2>
                <p class="mb-0">Check out our latest courses</p>
            </div>

            <div class="row">
                <!-- Slider START -->
                <div class="tiny-slider arrow-round arrow-blur arrow-hover">
                    <div class="tiny-slider-inner pb-1" data-autoplay="true" data-arrow="true" data-edge="2" data-dots="false" data-items="3" data-items-lg="2" data-items-sm="1">
                        @foreach ($recent_courses as $item)


                            <!-- Card item START -->
                        <div>
                            <div class="card ">
                                <div class="rounded-top overflow-hidden">
                                    <div class="card-overlay-hover">
                                        <!-- Image -->
                                        <img src="{{asset($item->image)}}" class="card-img-top" alt="course image">
                                    </div>
                                    <!-- Hover element -->

                                </div>
                                <!-- Card body -->
                                <div class="card-body">
                                    <!-- Rating and avatar -->
                                    <div class="d-flex justify-content-between">
                                        <!-- Rating and info -->
                                        <ul class="list-inline hstack gap-2 mb-0">
                                            <!-- Info -->
                                            <li class="list-inline-item d-flex justify-content-center align-items-center">
                                                <div class="icon-md bg-orange bg-opacity-10 text-orange rounded-circle"><i class="fas fa-clock"></i></div>
                                                <span class="h6 fw-light mb-0 ms-2">{{ $item->course_duration }}</span>
                                            </li>


                                        </ul>
                                        <!-- Avatar -->
                                        <div class="d-flex justify-content-center align-items-center">
                                            <div class="icon-md bg-primary bg-opacity-15 text-primary rounded-circle"><i class="fas fa-table"></i></div>
                                            <span class="h6 fw-light mb-0 ms-2">{{ $item->total_lectures }} Lecture{{ $item->total_lectures > 1 ? 's':'' }}</span>
                                        </div>
                                    </div>
                                    <!-- Divider -->
                                    <hr>
                                    <!-- Title -->
                                    <h5 class="card-title"><a href="{{ route('course.details', $item->id) }}">{{ $item->course_name }}</a></h5>
                                    <!-- Badge and Price -->
                                    <div class="d-flex justify-content-between align-items-center mb-0">
                                        <a href="{{ route('category.course', $item->category_id) }}" class="badge bg-info bg-opacity-10 text-info me-2"><i class="fas fa-circle small fw-bold"></i> {{ $item->category->name ?? '' }} </a>
                                        <!-- Price -->
                                        <h5 class="text-success mb-0">{{ $item->course_fee }} BDT</h5>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Card item END -->

                        @endforeach


                    </div>
                </div>
                <!-- Slider END -->
            </div>
        </div>
    </section>
    <!-- =======================
    Recent Course END -->

    <!-- =======================
    Trending courses START -->
    <section class="pb-0 pb-md-5 bg-light">
        <div class="container">
            <!-- Title -->
            <div class="row mb-4">
                <h2 class="mb-0">Our <span class="text-primary">Trending</span> Courses</h2>
                <p class="mb-0">Check out most ðŸ”¥ courses in the market</p>
            </div>
            <div class="row">
                <!-- Slider START -->
                <div class="tiny-slider arrow-round arrow-blur arrow-hover">
                    <div class="tiny-slider-inner pb-1" data-autoplay="true" data-arrow="true" data-edge="2" data-dots="false" data-items="3" data-items-lg="2" data-items-sm="1">
                        @foreach ($popular_courses as $item)
                        {{-- @php
                            $total_enrollment = count(getCourseEnrollments($item->id));
                        @endphp --}}

                            <!-- Card item START -->
                        <div>
                            <div class="card ">
                                <div class="rounded-top overflow-hidden">
                                    <div class="card-overlay-hover">
                                        <!-- Image -->
                                        <img src="{{asset($item->image)}}" class="card-img-top" alt="course image">
                                    </div>
                                    <!-- Hover element -->

                                </div>
                                <!-- Card body -->
                                <div class="card-body">
                                    <!-- Rating and avatar -->
                                    <div class="d-flex justify-content-between">
                                        <!-- Rating and info -->
                                        <ul class="list-inline hstack gap-2 mb-0">
                                            <!-- Info -->
                                            <li class="list-inline-item d-flex justify-content-center align-items-center">
                                                <div class="icon-md bg-orange bg-opacity-10 text-orange rounded-circle"><i class="fas fa-clock"></i></div>
                                                <span class="h6 fw-light mb-0 ms-2">{{ $item->course_duration }}</span>
                                            </li>
                                            <!-- Rating -->



                                        </ul>
                                        <!-- Avatar -->
                                        <div class="d-flex justify-content-center align-items-center">
                                            <div class="icon-md bg-primary bg-opacity-15 text-primary rounded-circle"><i class="fas fa-table"></i></div>
                                            <span class="h6 fw-light mb-0 ms-2">{{ $item->total_lectures }} Lecture{{ $item->total_lectures > 1 ? 's':'' }}</span>
                                        </div>
                                    </div>
                                    <!-- Divider -->
                                    <hr>
                                    <!-- Title -->
                                    <h5 class="card-title"><a href="{{ route('course.details', $item->id) }}">{{ $item->course_name }}</a></h5>
                                    <!-- Badge and Price -->
                                    <div class="d-flex justify-content-between align-items-center mb-0">
                                        <a href="{{ route('category.course', $item->category_id) }}" class="badge bg-info bg-opacity-10 text-info me-2"><i class="fas fa-circle small fw-bold"></i> {{ $item->category->name ?? '' }} </a>
                                        <!-- Price -->
                                        <h5 class="text-success mb-0">{{ $item->course_fee }} BDT</h5>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Card item END -->

                        @endforeach


                    </div>
                </div>
                <!-- Slider END -->
            </div>
        </div>
    </section>
    <!-- =======================
    Trending courses END -->

    <!-- =======================
Video divider START -->
    <section class="position-relative">
        <!-- SVG decoration -->
        <figure class="position-absolute bottom-0 start-0 d-none ">
            <svg width="822.2px" height="301.9px" viewBox="0 0 822.2 301.9">
                <path class="fill-warning" d="M752.5,51.9c-4.5,3.9-8.9,7.8-13.4,11.8c-51.5,45.3-104.8,92.2-171.7,101.4c-39.9,5.5-80.2-3.4-119.2-12.1 c-32.3-7.2-65.6-14.6-98.9-13.9c-66.5,1.3-128.9,35.2-175.7,64.6c-11.9,7.5-23.9,15.3-35.5,22.8c-40.5,26.4-82.5,53.8-128.4,70.7 c-2.1,0.8-4.2,1.5-6.2,2.2L0,301.9c3.3-1.1,6.7-2.3,10.2-3.5c46.1-17,88.1-44.4,128.7-70.9c11.6-7.6,23.6-15.4,35.4-22.8 c46.7-29.3,108.9-63.1,175.1-64.4c33.1-0.6,66.4,6.8,98.6,13.9c39.1,8.7,79.6,17.7,119.7,12.1C634.8,157,688.3,110,740,64.6 c4.5-3.9,9-7.9,13.4-11.8C773.8,35,797,16.4,822.2,1l-0.7-1C796.2,15.4,773,34,752.5,51.9z"></path>
            </svg>
        </figure>

        <!-- SVG decoration -->
        <figure class="position-absolute top-0 end-0">
            <svg width="822.2px" height="301.9px" viewBox="0 0 822.2 301.9">
                <path class="fill-primary" d="M752.5,51.9c-4.5,3.9-8.9,7.8-13.4,11.8c-51.5,45.3-104.8,92.2-171.7,101.4c-39.9,5.5-80.2-3.4-119.2-12.1 c-32.3-7.2-65.6-14.6-98.9-13.9c-66.5,1.3-128.9,35.2-175.7,64.6c-11.9,7.5-23.9,15.3-35.5,22.8c-40.5,26.4-82.5,53.8-128.4,70.7 c-2.1,0.8-4.2,1.5-6.2,2.2L0,301.9c3.3-1.1,6.7-2.3,10.2-3.5c46.1-17,88.1-44.4,128.7-70.9c11.6-7.6,23.6-15.4,35.4-22.8 c46.7-29.3,108.9-63.1,175.1-64.4c33.1-0.6,66.4,6.8,98.6,13.9c39.1,8.7,79.6,17.7,119.7,12.1C634.8,157,688.3,110,740,64.6 c4.5-3.9,9-7.9,13.4-11.8C773.8,35,797,16.4,822.2,1l-0.7-1C796.2,15.4,773,34,752.5,51.9z"></path>
            </svg>
        </figure>

        <!-- SVG decoration -->
        <figure class="position-absolute bottom-0 start-50 translate-middle-x ms-n9 mb-5">
            <svg width="23px" height="23px">
                <path class="fill-primary" d="M23.003,11.501 C23.003,17.854 17.853,23.003 11.501,23.003 C5.149,23.003 -0.001,17.854 -0.001,11.501 C-0.001,5.149 5.149,-0.000 11.501,-0.000 C17.853,-0.000 23.003,5.149 23.003,11.501 Z"></path>
            </svg>
        </figure>

        <!-- SVG decoration -->
        <figure class="position-absolute bottom-0 end-0 me-5 mb-5">
            <svg width="22px" height="22px">
                <path class="fill-warning" d="M22.003,11.001 C22.003,17.078 17.077,22.003 11.001,22.003 C4.925,22.003 -0.001,17.078 -0.001,11.001 C-0.001,4.925 4.925,-0.000 11.001,-0.000 C17.077,-0.000 22.003,4.925 22.003,11.001 Z"></path>
            </svg>
        </figure>

        <div class="container position-relative">
            <div class="row justify-content-between align-items-center my-5">

                <div class="col-lg-5 position-relative">
                    <!-- SVG decoration -->
                    <figure class="position-absolute top-0 start-0 translate-middle mt-n5">
                        <svg width="29px" height="29px">
                            <path class="fill-orange" d="M29.004,14.502 C29.004,22.512 22.511,29.004 14.502,29.004 C6.492,29.004 -0.001,22.512 -0.001,14.502 C-0.001,6.492 6.492,-0.001 14.502,-0.001 C22.511,-0.001 29.004,6.492 29.004,14.502 Z"></path>
                        </svg>
                    </figure>

                    <!-- Title -->
                    <h2 class="h1">About Us</h2>
                    <p align="justify">
                        {!! $about->value !!}
                    </p>
                </div>

                <div class="col-lg-5 position-relative mt-4 mt-lg-0">
                    <!-- Image -->
                    <img src="{{asset('frontend-assets')}}/images/04_2.jpg" class="border border-5 border-white rounded-2" alt="">
                    <div class="position-absolute top-50 start-50 translate-middle">
                        <!-- Video link -->
                        <a href="https://www.youtube.com/embed/tXHviS-4ygo" class="btn text-danger btn-round btn-white-shadow btn-lg mb-0" data-glightbox="" data-gallery="video-tour">
                            <i class="fas fa-play"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- =======================
    Video divider END -->
    <!-- =======================
    About START -->
    <section class="bg-light">
        <div class="container">
            <div class="row g-4 align-items-center">
                <div class="col-lg-5">
                    <!-- Title -->
                    <h2>Why Choose <span class="text-primary">Universal IT Institute</span></h2>
                    <!-- Image -->
                    <img src="{{asset('frontend-assets')}}/images/03_3.jpg" class="rounded-2" alt="">
                </div>
                <div class="col-lg-7">
                    <div class="row g-4">
                        <!-- Item -->
                        <div class="col-sm-6 col-6">
                            <div class="icon-lg bg-orange bg-opacity-10 text-orange rounded-2"><i class="fas fa-user-tie fs-5"></i></div>
                            <h5 class="mt-2">Learn with Experts</h5>
                            <p class="mb-0">In no impression assistance contrasted Manners she wishing justice hastily new anxious At discovery objection we</p>
                        </div>
                        <!-- Item -->
                        <div class="col-sm-6 col-6">
                            <div class="icon-lg bg-info bg-opacity-10 text-info rounded-2"><i class="fas fa-book fs-5"></i></div>
                            <h5 class="mt-2">Learn Anything</h5>
                            <p class="mb-0">Smile spoke total few great had never their too Amongst moments do in arrived at my replied Fat weddings believed prospect</p>
                        </div>
                        <!-- Item -->
                        <div class="col-sm-6 col-6">
                            <div class="icon-lg bg-success bg-opacity-10 text-success rounded-2"><i class="bi bi-alarm-fill fs-5"></i></div>
                            <h5 class="mt-2">Flexible Learning</h5>
                            <p class="mb-0">Denote simple fat denied add worthy little use As some he so high down am week Conduct denied add worthy little use As</p>
                        </div>
                        <!-- Item -->
                        <div class="col-sm-6 col-6">
                            <div class="icon-lg bg-purple bg-opacity-10 text-purple rounded-2"><i class="fas fa-university fs-5"></i></div>
                            <h5 class="mt-2">Industrial Standards</h5>
                            <p class="mb-0">Pleasure and so read the was hope entire first decided the so must have as on was want up of to traveling so all</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- =======================
    About END -->

    <!-- =======================
    Client START -->
    <section class="pt-lg-8 pt-sm-5 d-none">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-12">
                    <!-- Slider START -->
                    <div class="tiny-slider">
                        <div class="tiny-slider-inner" data-arrow="false" data-dots="false" data-gutter="80" data-items-xl="6" data-items-lg="5" data-items-md="4" data-items-sm="3" data-items-xs="2" data-autoplay="2000">
                            <!-- Slide item START -->
                            <div class="item"> <img class="grayscale" src="{{asset('frontend-assets')}}/fonts/coca-cola.svg" alt="client-logo"> </div>
                            <div class="item"> <img class="grayscale" src="{{asset('frontend-assets')}}/fonts/android.svg" alt="client-logo"> </div>
                            <div class="item"> <img class="grayscale" src="{{asset('frontend-assets')}}/fonts/envato.svg" alt="client-logo"> </div>
                            <div class="item"> <img class="grayscale" src="{{asset('frontend-assets')}}/fonts/microsoft.svg" alt="client-logo"> </div>
                            <div class="item"> <img class="grayscale" src="{{asset('frontend-assets')}}/fonts/netflix.svg" alt="client-logo"> </div>
                            <div class="item"> <img class="grayscale" src="{{asset('frontend-assets')}}/fonts/google.svg" alt="client-logo"> </div>
                            <div class="item"> <img class="grayscale" src="{{asset('frontend-assets')}}/fonts/linkedin.svg" alt="client-logo"> </div>
                            <!-- Slide item END -->
                        </div>
                    </div>
                    <!-- Slider END -->
                </div>
            </div>
        </div>
    </section>
    <!-- =======================
    Client END -->

    <!-- =======================
Action box START -->
    <section class="banner bg-light">
        <div class="container pt-lg-5 pt-0 pb-5">
            <div class="row">
                <div class="col-12 position-relative z-index-1">
                    <!-- Image -->
                    <div class="d-none d-lg-block position-absolute bottom-0 start-0 ms-3 ms-xl-5">
                        <img src="{{asset('frontend-assets')}}/images/01_1.png" alt="" style="max-width: 83%">
                    </div>
                    <!-- Pencil and cap SVG -->
                    <div class="position-absolute top-0 end-0 mt-n4 me-5">
                        <img src="{{asset('frontend-assets')}}/fonts/pencil.svg" alt="">
                    </div>
                    <div class="position-absolute bottom-0 start-50 mb-n4">
                        <img src="{{asset('frontend-assets')}}/fonts/graduated.svg" class="rotate-74" alt="">
                    </div>

                    <div class="bg-grad-pink p-4 p-sm-5 rounded position-relative z-index-n1 overflow-hidden">
                        <!-- SVG decoration -->
                        <figure class="position-absolute top-0 start-0 mt-3 ms-n3 opacity-5">
                            <svg width="818.6px" height="235.1px" viewBox="0 0 818.6 235.1">
                                <path class="fill-white" d="M735,226.3c-5.7,0.6-11.5,1.1-17.2,1.7c-66.2,6.8-134.7,13.7-192.6-16.6c-34.6-18.1-61.4-47.9-87.3-76.7 c-21.4-23.8-43.6-48.5-70.2-66.7c-53.2-36.4-121.6-44.8-175.1-48c-13.6-0.8-27.5-1.4-40.9-1.9c-46.9-1.9-95.4-3.9-141.2-16.5 C8.3,1.2,6.2,0.6,4.2,0H0c3.3,1,6.6,2,10,3c46,12.5,94.5,14.6,141.5,16.5c13.4,0.6,27.3,1.1,40.8,1.9 c53.4,3.2,121.5,11.5,174.5,47.7c26.5,18.1,48.6,42.7,70,66.5c26,28.9,52.9,58.8,87.7,76.9c58.3,30.5,127,23.5,193.3,16.7 c5.8-0.6,11.5-1.2,17.2-1.7c26.2-2.6,55-4.2,83.5-2.2v-1.2C790,222,761.2,223.7,735,226.3z"></path>
                            </svg>
                        </figure>
                        <!-- SVG decoration -->
                        <figure class="position-absolute top-50 start-0 translate-middle-y ms-5">
                            <svg width="473px" height="234px">
                                <path fill-rule="evenodd" opacity="0.051" fill="rgb(255, 255, 255)" d="M0.004,222.303 L364.497,-0.004 L472.998,32.563 L100.551,233.991 L0.004,222.303 Z"></path>
                            </svg>
                        </figure>
                        <!-- SVG decoration -->
                        <figure class="position-absolute top-50 end-0 translate-middle-y">
                            <svg width="355.6px" height="396.1px">
                                <path class="fill-danger rotate-10" d="M32.8,364.1c16.1-14.7,36-21.5,56.8-26.7c20-5.1,40.5-9.7,57.8-21.4c35.7-24.3,51.1-68.5,57.2-109.4 c6.8-45.7,4.6-93.7,21.6-137.5c8.3-21.4,22.3-41.4,43.3-51.9c17.4-8.7,36.2-7.9,54.2-1.5c10.2,3.6,19.8,8.5,29.4,13.5l2.5-4.3 c-2.7-1.4-5.4-2.8-8.2-4.2c-15.8-8-32.9-15.3-50.9-15.2C276,5.6,256.9,16,243.3,31c-16.6,18.3-25.3,42.2-30.5,66 c-5,22.9-6.8,46.3-8.8,69.6c-3.9,44.4-9.7,92.8-40.1,128c-7.1,8.2-15.4,15.4-24.9,20.8c-9.3,5.4-19.5,8.9-29.8,11.8 c-20.2,5.7-41.3,9.1-59.9,19.2c-19.3,10.4-35.1,27.2-44.2,47.1c0,0,0,0.1,0,0.1l4.4,2.6C15,384,22.9,373.1,32.8,364.1z"></path>
                            </svg>
                        </figure>

                        <div class="row g-3 align-items-center justify-content-lg-end position-relative py-4">
                            <!-- Title -->
                            <div class="col-md-6">
                                <h2 class="text-white">Become a Learner!</h2>
                                <p class="text-white mb-0">Gather Knowledge with ease!</p>
                            </div>
                            <!-- Button -->
                            <div class="col-md-6 col-lg-3 text-md-end">
                                <a href="{{ route('student.sign-up') }}" class="btn btn-white mb-0">Get Started Now!</a>
                            </div>
                        </div> <!-- Row END -->
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- =======================
    Action box END -->

    <section>
        <div class="container">
            <!-- Title -->
            <div class="row mb-4">
                <div class="col-12">
                    <h2 class="fs-1 fw-bold">
                        <span class="position-relative z-index-9">Our Recent</span>
                        <span class="position-relative z-index-1">Reviews
                            <!-- SVG START -->
						<span class="position-absolute top-50 start-50 translate-middle z-index-n1">
							<svg width="205.3px" height="63.3px">
								<path class="fill-warning" d="M204,26.9c-0.1-0.5-0.2-1.1-0.4-1.6c-0.1-0.3-0.3-0.6-0.5-0.9c-0.3-0.5-0.8-0.9-1.6-1.2l0.1-0.1l-0.1,0.1 c0.1-0.5-0.2-0.6-0.6-0.7c-0.1,0-0.1,0-0.2,0c-0.1-0.1-0.3-0.2-0.4-0.4c0-0.4,0-0.7-0.3-0.9c-0.1-0.1-0.4-0.2-0.7-0.2 c0-0.3-0.1-0.6-0.3-0.7c-0.2-0.1-0.4-0.2-0.6-0.2c-0.1,0-0.2,0-0.3,0c-0.6-0.5-1.2-1-1.8-1.4c0-0.1,0-0.1,0-0.1 c-0.1-0.1-0.2-0.2-0.4-0.2c-1.1-0.6-2.2-1.2-3.3-1.9c-7.6-4.5-16.6-5.5-25-7.9c-5.1-1.5-10.6-1.8-15.9-2.5 c-7.1-0.9-14.3-0.8-21.4-1.3c-2.9-0.2-5.8-0.4-8.6-0.4c-1.5,0-3-0.3-4.5-0.1c-3.1,0.5-6.2,0.8-9.3,0.9c-1,0.1-2.1,0.1-3.1,0.1 c-0.1,0-0.2,0-0.3,0c-0.1,0-0.2,0-0.3,0c-1.1,0-2.3,0.1-3.4,0.1c-1.1,0-2.3,0-3.4,0c-6.9-0.4-13.6,0.9-20.2,1.9 c-3.2,0.5-6.4,1.2-9.6,1.9c-3.5,0.8-7.1,0.9-10.6,1.7c-5.1,1.2-10.3,2.3-15.6,3.2c-5.1,0.9-10.1,2.1-15.1,3.4 c-4.6,1.2-8.7,3.2-12.7,5.2c-2.4,1.2-4.8,2.2-6.6,4.1c-2.2,2.3-3.5,5-5.4,7.5c-1.2,1.7-0.9,3.2,0.2,4.9c2.5,3.9,6.9,5.5,11.4,7.2 c2.2,0.8,4.6,1.3,6.7,2.3c2.9,1.4,5.8,2.9,8.9,4.1c6.6,2.5,13.4,4.3,20.4,5.6c3.8,0.7,7.8,1.1,11.7,1.4c6,0.4,12,1.3,18.1,1 c0.4,0.4,0.8,0.4,1.1-0.1c0.9-0.4,1.8,0.1,2.7-0.1c4.7-0.8,9.5-0.4,14.3-0.3c2.7,0,5.4,0.4,8.1,0.3c5-0.2,10.1-0.6,15.1-1 c6.9-0.6,13.8-1.3,20.4-2.8c0.2,0.2,0.3,0.1,0.3-0.1c0.6-0.1,1.2-0.2,1.8-0.3c0.1,0.2,0.3,0.1,0.3,0c0.7-0.1,1.3-0.3,2-0.4 c4.2-0.4,8.4-0.7,12.6-1.3c2.6-0.3,5.2-1,7.8-1.5c0.2,0.1,0.4,0.2,0.6,0.1c0.1,0,0.2-0.1,0.2-0.1c0,0,0.1-0.1,0.1-0.1 c0,0,0.1-0.1,0.1-0.1c0.3-0.1,0.5-0.2,0.8-0.2c0.1,0,0.1,0,0.2,0c0.2,0,0.3-0.1,0.3-0.2c0,0,0,0,0,0l0,0c0,0,0,0,0,0 c0.2,0,0.5-0.1,0.7-0.1c0,0,0,0,0,0c0.1,0,0.2,0,0.3,0c0.2,0,0.4-0.1,0.4-0.4c0.6-0.2,1.2-0.4,1.7-0.7c0.1,0,0.2,0,0.3,0 c0,0,0.1,0,0.1-0.1c0,0,0.1-0.1,0.1-0.1c0,0,0.1,0,0.1-0.1c0,0,0.1,0,0.1,0c0.3,0.1,0.6,0.1,0.7,0c0.1,0,0.2-0.1,0.2-0.2 c0.1-0.1,0.1-0.2,0.2-0.3c0.7-0.3,1.3-0.6,2-0.8c2-0.9,3.9-1.7,6-2.4c6-1.8,11.5-4.2,16.1-8c1-0.2,1.6-0.7,2-1.3 c0.3-0.4,0.4-0.8,0.6-1.2c0.6-0.1,0.9-0.3,1.1-0.6c0.2-0.3,0.3-0.7,0.4-1.1c0-0.1,0-0.1,0.1-0.2c0.6,0,0.7-0.4,1-0.7 C203.7,32.1,204.6,29.6,204,26.9z M4.4,38.1C4.2,37.6,4,37,4.3,36.5c2.3-3.7,4.3-7.6,8.5-10.2c3.5-2.1,7.4-3.7,11.3-5.3 c5.4-2.3,11.3-3.2,17.1-4.4c0,0.1,0,0.2,0,0.3l0,0c-1.4,0.5-2.7,0.9-4.1,1.4c-4.1,1.4-8.2,2.7-12.2,4.2c-5.4,2.1-9.7,5.3-12.8,9.5 c-0.6,0.8-1.3,1.7-2,2.5c-2.7,3.4-1.2,5.9,1.5,8.8c0.2,0.2,0.4,0.4,0.5,0.6C8.7,42.8,5.7,41.2,4.4,38.1z M198.5,31.8 c-2.1,3.5-5.2,6.4-8.9,8.6c-2.6,1.6-5.6,2.7-8.7,3.7c-4.1,1.3-8.1,3-12,4.6c-5,2-10.2,3.2-15.7,3.6c-7.5,0.6-14.9,1.9-22.2,3.2 c-6.1,1.1-12.4,1.3-18.6,1.9c-7,0.7-14.1,0.2-21.2,0.1c-4-0.1-7.9,0.4-11.8,0.6c-3.3,0.2-6.5,0.2-9.8-0.1c-4.9-0.4-9.9-0.7-14.8-1.2 c-3.5-0.3-7-0.9-10.4-1.8c-4-1.1-8-2.1-12-3.2c-0.6-0.2-1.2-0.3-1.7-0.7c-0.2-0.1-0.5-0.2-0.8-0.3c0.1,0,0.1,0,0.2-0.1 c0.3-0.1,0.6,0,0.9,0.1c0,0,0,0,0,0c4.3,0.6,8.7,1.5,13.1,1.7c0.6,0,1.3,0,1.9,0c0.6,0,1.6,0.3,1.6-0.3c0-0.7-0.9-1.1-1.8-1.1 c-2.7,0-5.3-0.3-7.9-0.7c-5.8-0.9-11.5-1.8-16.9-3.8c-3.7-1.4-6.8-3.4-8.7-6.6c-0.6-1-0.6-2-0.1-3c4-7.8,11.4-12.4,20.6-15.4 c8.4-2.7,16.7-5.6,25.5-7.6c6.3-1.4,12.7-2.3,18.9-3.7C88,8.1,99,7.5,110.1,7.1c4.5-0.2,9-1.1,13.6-0.7c10.5,0.8,21.1,1.5,31.6,3 c5.7,0.8,11.4,1.5,17.2,2.1c4.5,0.5,9,1.8,13.2,3.5c4,1.6,7.5,3.6,10.7,6.3C199.7,24.1,200.6,28.4,198.5,31.8z"></path>
							</svg>
						</span>
                            <!-- SVG END -->
					</span>
                    </h2>
                    <p class="mb-0">Some Valuable Thoughts About Our Institute</p>
                </div>
            </div>

            <div class="row">
                <!-- Slider START -->
                <div class="tiny-slider arrow-round arrow-creative arrow-blur">
                    <div class="tiny-slider-inner" data-autoplay="true" data-arrow="true" data-dots="false" data-items="4" data-items-lg="3" data-items-md="2" data-items-xs="1">

                        <!-- Card item START -->
                        <div class="card bg-transparent">
                            <div class="position-relative">
                                <!-- Image -->
                                <img src="{{asset('frontend-assets')}}/images/02_7.jpg" class="card-img reviewer-img rounded-circle" alt="course image">
                                <!-- Overlay -->
                                <div class="card-img-overlay d-flex flex-column p-3">
                                    <div class="w-100 mt-auto text-end">
                                        <!-- Card category -->
                                    </div>
                                </div>
                            </div>
                            <!-- Card body -->
                            <div class="card-body text-center h-200px">
                                <!-- Title -->
                                <p>The online courses are comprehensive and easy to follow. </p>
                                <h5 class="card-title"><a href="#">Jacqueline Miller</a></h5>
                                <p class="mb-2">Computer Teacher</p>
                                <!-- Rating -->
                                <!--								<ul class="list-inline hstack justify-content-center">-->
                                <!--									<li class="list-inline-item ms-2 h6 fw-light mb-0">4.5/5.0</li>-->
                                <!--									<li class="list-inline-item me-0 small"><i class="fas fa-star text-warning"></i></li>-->
                                <!--									<li class="list-inline-item me-0 small"><i class="fas fa-star text-warning"></i></li>-->
                                <!--									<li class="list-inline-item me-0 small"><i class="fas fa-star text-warning"></i></li>-->
                                <!--									<li class="list-inline-item me-0 small"><i class="fas fa-star text-warning"></i></li>-->
                                <!--									<li class="list-inline-item me-0 small"><i class="fas fa-star-half-alt text-warning"></i></li>-->
                                <!--								</ul>-->
                            </div>
                        </div>
                        <div class="card bg-transparent">
                            <div class="position-relative">
                                <!-- Image -->
                                <img src="{{asset('frontend-assets')}}/images/01.jpg" class="card-img reviewer-img rounded-circle" alt="course image">
                                <!-- Overlay -->
                                <div class="card-img-overlay d-flex flex-column p-3">
                                    <div class="w-100 mt-auto text-end">
                                        <!-- Card category -->
                                    </div>
                                </div>
                            </div>
                            <!-- Card body -->
                            <div class="card-body text-center h-200px">
                                <!-- Title -->
                                <p>I love the offline courses they offer hands-on experience and direct interaction.</p>
                                <h5 class="card-title"><a href="#">Jacky Roy</a></h5>
                                <p class="mb-2">Student</p>
                                <!-- Rating -->
                                <!--								<ul class="list-inline hstack justify-content-center">-->
                                <!--									<li class="list-inline-item ms-2 h6 fw-light mb-0">4.5/5.0</li>-->
                                <!--									<li class="list-inline-item me-0 small"><i class="fas fa-star text-warning"></i></li>-->
                                <!--									<li class="list-inline-item me-0 small"><i class="fas fa-star text-warning"></i></li>-->
                                <!--									<li class="list-inline-item me-0 small"><i class="fas fa-star text-warning"></i></li>-->
                                <!--									<li class="list-inline-item me-0 small"><i class="fas fa-star text-warning"></i></li>-->
                                <!--									<li class="list-inline-item me-0 small"><i class="fas fa-star-half-alt text-warning"></i></li>-->
                                <!--								</ul>-->
                            </div>
                        </div>
                        <div class="card bg-transparent">
                            <div class="position-relative">
                                <!-- Image -->
                                <img src="{{asset('frontend-assets')}}/images/11_1.jpg" class="card-img reviewer-img rounded-circle" alt="course image">
                                <!-- Overlay -->
                                <div class="card-img-overlay d-flex flex-column p-3">
                                    <div class="w-100 mt-auto text-end">
                                        <!-- Card category -->
                                    </div>
                                </div>
                            </div>
                            <!-- Card body -->
                            <div class="card-body text-center h-200px">
                                <!-- Title -->
                                <p>The customer service is prompt and helpful, ensuring all queries are resolved quickly.</p>
                                <h5 class="card-title"><a href="#">Jason Derula</a></h5>
                                <p class="mb-2">Normal Visitor</p>
                                <!-- Rating -->
                                <!--								<ul class="list-inline hstack justify-content-center">-->
                                <!--									<li class="list-inline-item ms-2 h6 fw-light mb-0">4.5/5.0</li>-->
                                <!--									<li class="list-inline-item me-0 small"><i class="fas fa-star text-warning"></i></li>-->
                                <!--									<li class="list-inline-item me-0 small"><i class="fas fa-star text-warning"></i></li>-->
                                <!--									<li class="list-inline-item me-0 small"><i class="fas fa-star text-warning"></i></li>-->
                                <!--									<li class="list-inline-item me-0 small"><i class="fas fa-star text-warning"></i></li>-->
                                <!--									<li class="list-inline-item me-0 small"><i class="fas fa-star-half-alt text-warning"></i></li>-->
                                <!--								</ul>-->
                            </div>
                        </div>
                        <div class="card bg-transparent">
                            <div class="position-relative">
                                <!-- Image -->
                                <img src="{{asset('frontend-assets')}}/images/12_1.jpg" class="card-img reviewer-img rounded-circle" alt="course image">
                                <!-- Overlay -->
                                <div class="card-img-overlay d-flex flex-column p-3">
                                    <div class="w-100 mt-auto text-end">
                                        <!-- Card category -->
                                    </div>
                                </div>
                            </div>
                            <!-- Card body -->
                            <div class="card-body text-center h-200px">
                                <!-- Title -->
                                <p>The variety of courses available is impressive, covering a wide range of topics. </p>
                                <h5 class="card-title"><a href="#">Anjelina Kapoor</a></h5>
                                <p class="mb-2">Instructor</p>
                                <!-- Rating -->
                                <!--								<ul class="list-inline hstack justify-content-center">-->
                                <!--									<li class="list-inline-item ms-2 h6 fw-light mb-0">4.5/5.0</li>-->
                                <!--									<li class="list-inline-item me-0 small"><i class="fas fa-star text-warning"></i></li>-->
                                <!--									<li class="list-inline-item me-0 small"><i class="fas fa-star text-warning"></i></li>-->
                                <!--									<li class="list-inline-item me-0 small"><i class="fas fa-star text-warning"></i></li>-->
                                <!--									<li class="list-inline-item me-0 small"><i class="fas fa-star text-warning"></i></li>-->
                                <!--									<li class="list-inline-item me-0 small"><i class="fas fa-star-half-alt text-warning"></i></li>-->
                                <!--								</ul>-->
                            </div>
                        </div>
                        <div class="card bg-transparent">
                            <div class="position-relative">
                                <!-- Image -->
                                <img src="{{asset('frontend-assets')}}/images/06_19.jpg" class="card-img reviewer-img rounded-circle" alt="course image">
                                <!-- Overlay -->
                                <div class="card-img-overlay d-flex flex-column p-3">
                                    <div class="w-100 mt-auto text-end">
                                        <!-- Card category -->
                                    </div>
                                </div>
                            </div>
                            <!-- Card body -->
                            <div class="card-body text-center h-200px">
                                <!-- Title -->
                                <p>The website is well-organized and makes it easy to find and enroll in courses.</p>
                                <h5 class="card-title"><a href="#">Samuel Hasan</a></h5>
                                <p class="mb-2">Reviewer</p>
                                <!-- Rating -->
                                <!--								<ul class="list-inline hstack justify-content-center">-->
                                <!--									<li class="list-inline-item ms-2 h6 fw-light mb-0">4.5/5.0</li>-->
                                <!--									<li class="list-inline-item me-0 small"><i class="fas fa-star text-warning"></i></li>-->
                                <!--									<li class="list-inline-item me-0 small"><i class="fas fa-star text-warning"></i></li>-->
                                <!--									<li class="list-inline-item me-0 small"><i class="fas fa-star text-warning"></i></li>-->
                                <!--									<li class="list-inline-item me-0 small"><i class="fas fa-star text-warning"></i></li>-->
                                <!--									<li class="list-inline-item me-0 small"><i class="fas fa-star-half-alt text-warning"></i></li>-->
                                <!--								</ul>-->
                            </div>
                        </div>
                        <div class="card bg-transparent">
                            <div class="position-relative">
                                <!-- Image -->
                                <img src="{{asset('frontend-assets')}}/images/07_18.jpg" class="card-img reviewer-img rounded-circle" alt="course image">
                                <!-- Overlay -->
                                <div class="card-img-overlay d-flex flex-column p-3">
                                    <div class="w-100 mt-auto text-end">
                                        <!-- Card category -->
                                    </div>
                                </div>
                            </div>
                            <!-- Card body -->
                            <div class="card-body text-center h-200px">
                                <!-- Title -->
                                <p>The content quality is top-notch, with detailed explanations and practical examples.</p>
                                <h5 class="card-title"><a href="#">David Miller</a></h5>
                                <p class="mb-2">Student</p>
                                <!-- Rating -->
                                <!--								<ul class="list-inline hstack justify-content-center">-->
                                <!--									<li class="list-inline-item ms-2 h6 fw-light mb-0">4.5/5.0</li>-->
                                <!--									<li class="list-inline-item me-0 small"><i class="fas fa-star text-warning"></i></li>-->
                                <!--									<li class="list-inline-item me-0 small"><i class="fas fa-star text-warning"></i></li>-->
                                <!--									<li class="list-inline-item me-0 small"><i class="fas fa-star text-warning"></i></li>-->
                                <!--									<li class="list-inline-item me-0 small"><i class="fas fa-star text-warning"></i></li>-->
                                <!--									<li class="list-inline-item me-0 small"><i class="fas fa-star-half-alt text-warning"></i></li>-->
                                <!--								</ul>-->
                            </div>
                        </div>
                        <!-- Card item END -->

                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- =======================
    Instructor END -->

    <!-- =======================
Newsletter START -->
    <section class="position-relative z-index-9 d-none">
        <div class="container">
            <div class="row">
                <div class="col-11 col-md-10 mx-auto">
                    <div class="bg-warning rounded-3 shadow p-3 p-sm-4 position-relative overflow-hidden">
                        <!-- SVG decoration -->
                        <figure class="position-absolute top-100 start-100 translate-middle mt-n6 ms-n5">
                            <svg width="211px" height="211px">
                                <path class="fill-white opacity-4" d="M210.030,105.011 C210.030,163.014 163.010,210.029 105.012,210.029 C47.013,210.029 -0.005,163.014 -0.005,105.011 C-0.005,47.015 47.013,-0.004 105.012,-0.004 C163.010,-0.004 210.030,47.015 210.030,105.011 Z"></path>
                            </svg>
                        </figure>
                        <!-- SVG decoration -->
                        <figure class="position-absolute top-100 start-0 translate-middle mt-n6 ms-5">
                            <svg width="141px" height="141px">
                                <path class="fill-white opacity-4" d="M140.520,70.258 C140.520,109.064 109.062,140.519 70.258,140.519 C31.454,140.519 -0.004,109.064 -0.004,70.258 C-0.004,31.455 31.454,-0.003 70.258,-0.003 C109.062,-0.003 140.520,31.455 140.520,70.258 Z"></path>
                            </svg>
                        </figure>
                        <!-- SVG decoration -->
                        <figure class="position-absolute top-0 start-50 mt-4 ms-n9">
                            <svg width="41px" height="41px">
                                <path class="fill-white opacity-4" d="M40.531,20.265 C40.531,31.458 31.457,40.531 20.265,40.531 C9.072,40.531 -0.001,31.458 -0.001,20.265 C-0.001,9.073 9.072,-0.001 20.265,-0.001 C31.457,-0.001 40.531,9.073 40.531,20.265 Z"></path>
                            </svg>
                        </figure>

                        <!-- Icon logos START -->
                        <div class="p-2 bg-white shadow rounded-3 rotate-74 position-absolute top-0 start-0 ms-3 mt-5 d-none d-sm-block">
                            <img src="{{asset('frontend-assets')}}/fonts/science.svg" class="h-40px" alt="Icon">
                        </div>
                        <div class="p-1 bg-white shadow rounded-3 rotate-74 position-absolute top-0 end-0 mt-5 me-5 d-none d-sm-block">
                            <img src="{{asset('frontend-assets')}}/fonts/angular.svg" class="h-30px" alt="Icon">
                        </div>
                        <div class="p-2 bg-white shadow rounded-3 rotate-130 position-absolute bottom-0 start-50 ms-5 mb-2 d-none d-lg-block">
                            <img src="{{asset('frontend-assets')}}/fonts/figma.svg" class="h-20px" alt="Icon">
                        </div>
                        <!-- Icon logos END -->

                        <div class="row">
                            <div class="col-md-8 mx-auto text-center py-5 position-relative">
                                <!-- Title -->
                                <h2>Subscribe to our Newsletter for Newest Course Updates</h2>
                                <!-- Form -->
                                <form class="row align-items-center justify-content-center mt-3">
                                    <div class="col-lg-8">
                                        <div class="bg-body shadow rounded-pill p-2">
                                            <div class="input-group">
                                                <input class="form-control border-0 me-1" type="email" placeholder="Enter your email">
                                                <button type="button" class="btn btn-blue mb-0 rounded-pill">Subscribe!</button>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div> <!-- Row END -->
                    </div>
                </div>
            </div> <!-- Row END -->
        </div>
    </section>
    <!-- =======================
    Newsletter END -->
@endsection
