@extends('frontend.master')
@section('title')
    FAQ
@endsection

@section('meta')
    <meta name="title" content="Freelancing-Career in Bangladesh: From Learning to Earning">
    <meta name="description" content="Start your freelancing career with expert-led courses on in-demand skills and live projects. Get certified and have a chance to join our agency!">
    <meta name="keywords" content="freelancing career courses in Bangladesh">
    
    <meta name="og:title" content="Freelancing-Career in Bangladesh: From Learning to Earning">
    <meta name="og:image" content="{{asset('frontend-assets')}}/images/meta_image.png">
@endsection


@section('content')
    <!-- =======================
    Page Banner START -->
    <section class="bg-light py-5">
        <div class="container">
            <div class="row g-4 g-md-5 position-relative">
                <!-- SVG decoration -->
                <figure class="position-absolute top-0 start-0 d-none d-sm-block">
                    <svg width="22px" height="22px" viewBox="0 0 22 22">
                        <polygon class="fill-purple"
                            points="22,8.3 13.7,8.3 13.7,0 8.3,0 8.3,8.3 0,8.3 0,13.7 8.3,13.7 8.3,22 13.7,22 13.7,13.7 22,13.7 ">
                        </polygon>
                    </svg>
                </figure>

                <!-- Title and Search -->
                <div class="col-lg-10 mx-auto text-center position-relative">
                    <!-- SVG decoration -->
                    <figure class="position-absolute top-50 end-0 translate-middle-y">
                        <svg width="27px" height="27px">
                            <path class="fill-orange"
                                d="M13.122,5.946 L17.679,-0.001 L17.404,7.528 L24.661,5.946 L19.683,11.533 L26.244,15.056 L18.891,16.089 L21.686,23.068 L15.400,19.062 L13.122,26.232 L10.843,19.062 L4.557,23.068 L7.352,16.089 L-0.000,15.056 L6.561,11.533 L1.582,5.946 L8.839,7.528 L8.565,-0.001 L13.122,5.946 Z">
                            </path>
                        </svg>
                    </figure>
                    <!-- Title -->
                    <h1 class="display-6">Hello, how can we help?</h1>
                    <!-- Search bar -->
                    <div class="col-lg-8 mx-auto text-center mt-4">
                        <button class="btn btn-primary mb-0 rounded border" data-bs-toggle="modal" data-bs-target="#questionModal">Ask a question</button>
                    </div>

                    <div class="modal fade" id="questionModal" tabindex="-1" aria-labelledby="questionModalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="questionModalLabel">Submit Your Question</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                </div>
                                <form id="questionForm" action="{{ route('submit.qustion') }}" method="POST">
                                    @csrf
                                    <div class="modal-body">
                                        <div class="mb-3">
                                            <input class="form-control" name="qustion" required type="text" placeholder="Ask a question..." >
                                        </div>
                                        <div class="mb-3">
                                            <input class="form-control" name="email" required type="email" placeholder="Your email" >
                                        </div>
                                        <div class="mb-3">
                                            <input class="form-control" name="phone" required type="number" placeholder="Your phone">
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                        <button type="submit" class="btn btn-primary">Submit</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>


            </div>
        </div>
    </section>
    <!-- =======================
        Page Banner END -->

    <!-- =======================
        Page content START -->
    <section class="pt-5 pb-0 pb-lg-5">
        <div class="container">

            <div class="row g-4 g-md-5">
                <!-- Main content START -->
                <div class="col-lg-8">
                    <!-- Title -->
                    <h3 class="mb-4">Frequently Asked Questions</h3>

                    <!-- FAQ START -->
                    <div class="accordion accordion-icon accordion-bg-light" id="accordionExample2">
                        <!-- Item -->
                        <div class="accordion-item mb-3">
                            <h6 class="accordion-header font-base" id="heading-1">
                                <button class="accordion-button fw-bold rounded d-inline-block collapsed" type="button"
                                    data-bs-toggle="collapse" data-bs-target="#collapse-1" aria-expanded="true"
                                    aria-controls="collapse-1">
                                    How do I enroll in a course?
                                </button>
                            </h6>
                            <!-- Body -->
                            <div id="collapse-1" class="accordion-collapse collapse show" aria-labelledby="heading-1"
                                data-bs-parent="#accordionExample2">
                                <div class="accordion-body mt-3">
                                    To enroll in a course at Freelancing Career, start by signing up and then logging in. 
                                    Once you're signed in, choose the course you want to take, navigate to the course details page, 
                                    and click the ‘Enroll Now’ button. This will direct you to the checkout page, where you can enter 
                                    a coupon code if you have one. Finally, select your payment method, click ‘Pay & Confirm,’ 
                                    and your payment will be processed, confirming your enrollment.
                                </div>
                            </div>
                        </div>

                        <!-- Item -->
                        <div class="accordion-item mb-3">
                            <h6 class="accordion-header font-base" id="heading-2">
                                <button class="accordion-button fw-bold rounded d-inline-block collapsed d-block pe-5"
                                    type="button" data-bs-toggle="collapse" data-bs-target="#collapse-2"
                                    aria-expanded="false" aria-controls="collapse-2">
                                    How long does it take to complete a course?
                                </button>
                            </h6>
                            <!-- Body -->
                            <div id="collapse-2" class="accordion-collapse collapse" aria-labelledby="heading-2"
                                data-bs-parent="#accordionExample2">
                                <div class="accordion-body mt-3">
                                    It depends on the course length. Every listed course has its length mentioned. 
                                    To learn the course duration, follow the directions: 
                                    Go to Home > Click on Course Categories > Select Course > Scroll down > Navigate "This Course Includes" section > 
                                    Learn Course Duration and Starting Time.
                                </div>
                            </div>
                        </div>

                        <!-- Item -->
                        <div class="accordion-item mb-3">
                            <h6 class="accordion-header font-base" id="heading-3">
                                <button class="accordion-button fw-bold collapsed rounded d-block pe-5" type="button"
                                    data-bs-toggle="collapse" data-bs-target="#collapse-3" aria-expanded="false"
                                    aria-controls="collapse-3">
                                    Can I learn at my own pace?
                                </button>
                            </h6>
                            <!-- Body -->
                            <div id="collapse-3" class="accordion-collapse collapse" aria-labelledby="heading-3"
                                data-bs-parent="#accordionExample2">
                                <div class="accordion-body mt-3">
                                    Since all courses will be conducted live online with a set number of classes, 
                                    it’s highly recommended to attend each session for the best results. 
                                    While recorded materials will be available, we encourage active participation 
                                    in live classes to maximize interaction with your mentor. Relying solely on 
                                    recordings may reduce the full learning experience.
                                </div>
                            </div>
                        </div>

                        <!-- Item -->
                        <div class="accordion-item mb-3">
                            <h6 class="accordion-header font-base" id="heading-4">
                                <button class="accordion-button fw-bold collapsed rounded d-block pe-5" type="button"
                                    data-bs-toggle="collapse" data-bs-target="#collapse-4" aria-expanded="false"
                                    aria-controls="collapse-4">
                                    Can I pay my fees in installments
                                </button>
                            </h6>
                            <!-- Body -->
                            <div id="collapse-4" class="accordion-collapse collapse" aria-labelledby="heading-4"
                                data-bs-parent="#accordionExample2">
                                <div class="accordion-body mt-3">
                                    We're sorry, but this facility isn't available just yet. We're working on it.
                                </div>
                            </div>
                        </div>

                        <!-- Item -->
                        <div class="accordion-item mb-3">
                            <h6 class="accordion-header font-base" id="heading-5">
                                <button class="accordion-button fw-bold collapsed rounded d-block pe-5" type="button"
                                    data-bs-toggle="collapse" data-bs-target="#collapse-5" aria-expanded="false"
                                    aria-controls="collapse-5">
                                    How do I become an instructor?
                                </button>
                            </h6>
                            <!-- Body -->
                            <div id="collapse-5" class="accordion-collapse collapse" aria-labelledby="heading-5"
                                data-bs-parent="#accordionExample2">
                                <div class="accordion-body mt-3">
                                    To become an instructor, please contact us at +88-01970-707287 or 
                                    visit our office in Mohammadpur, Dhaka, during working days.
                                </div>
                            </div>
                        </div>

                        <!-- Item -->
                        <div class="accordion-item mb-3">
                            <h6 class="accordion-header font-base" id="heading-6">
                                <button class="accordion-button fw-bold collapsed rounded d-block pe-5" type="button"
                                    data-bs-toggle="collapse" data-bs-target="#collapse-6" aria-expanded="false"
                                    aria-controls="collapse-6">
                                    What if I have technical difficulties?
                                </button>
                            </h6>
                            <!-- Body -->
                            <div id="collapse-6" class="accordion-collapse collapse" aria-labelledby="heading-6"
                                data-bs-parent="#accordionExample2">
                                <div class="accordion-body mt-3">
                                    If you have any technical problems, contact your mentor right away to get help quickly.
                                </div>
                            </div>
                        </div>
                        
                        <!-- Item -->
                        <div class="accordion-item mb-3">
                            <h6 class="accordion-header font-base" id="heading-7">
                                <button class="accordion-button fw-bold collapsed rounded d-block pe-5" type="button"
                                    data-bs-toggle="collapse" data-bs-target="#collapse-7" aria-expanded="false"
                                    aria-controls="collapse-7">
                                    What payment methods do you accept?
                                </button>
                            </h6>
                            <!-- Body -->
                            <div id="collapse-7" class="accordion-collapse collapse" aria-labelledby="heading-7"
                                data-bs-parent="#accordionExample2">
                                <div class="accordion-body mt-3">
                                    Right now, we only accept bKash payments, 
                                    but we’ll be adding more payment options soon. 
                                    Please contact us for any payment difficulties.
                                </div>
                            </div>
                        </div>
                        <!-- Item -->
                        <div class="accordion-item">
                            <h6 class="accordion-header font-base" id="heading-8">
                                <button class="accordion-button fw-bold collapsed rounded d-block pe-5" type="button"
                                    data-bs-toggle="collapse" data-bs-target="#collapse-8" aria-expanded="false"
                                    aria-controls="collapse-8">
                                    Where can I get my certificate?
                                </button>
                            </h6>
                            <!-- Body -->
                            <div id="collapse-8" class="accordion-collapse collapse" aria-labelledby="heading-8"
                                data-bs-parent="#accordionExample2">
                                <div class="accordion-body mt-3">
                                    Once you complete your course, your certificate will be available 
                                    on your dashboard, and a copy will also be sent to your email.
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- FAQ END -->
                </div>
                <!-- Main content END -->

                <!-- Right sidebar START -->
                <div class="col-lg-4">
                    <div class="row mb-5 mb-lg-0">
                        <div class="col-12 col-sm-6 col-lg-12">
                            <!-- Category START -->
                            {{-- <div class="mb-4">
                                <div class="d-flex justify-content-between align-items-center bg-info bg-opacity-10 rounded p-2 position-relative mb-3">
                                    <h6 class="m-0 text-info">Last Question</h6>
                                    <a href="#" class="badge bg-info stretched-link">2D ago</a>
                                </div>
                                <div class="d-flex justify-content-between align-items-center bg-danger bg-opacity-10 rounded p-2 position-relative mb-3">
                                    <h6 class="m-0 text-danger">Total Question</h6>
                                    <a href="#" class="badge bg-danger stretched-link">15,525</a>
                                </div>
                                <div class="d-flex justify-content-between align-items-center bg-success bg-opacity-10 rounded p-2 position-relative mb-3">
                                    <h6 class="m-0 text-success">Answer</h6>
                                    <a href="#" class="badge bg-success stretched-link">12536</a>
                                </div>
                            </div> --}}
                            <!-- Category END -->

                            <!-- Related Topic START -->
                            <div class="card card-body shadow p-4 mb-4">
                                <!-- Title -->
                                <h4 class="mb-3">View Course Categories</h4>
                                @foreach ($course_categories as $category)
                                    @php
                                        $course = findCategoryCourse($category->id);

                                    @endphp
                                    <!-- Item -->
                                    <div class="d-flex justify-content-between align-items-center mb-2">
                                        <a href="{{ route('category.course', $category->slug) }}" class="h6 fw-light"><i
                                                class="fas fa-caret-right text-orange me-2"></i>{{ $category->name }}</a>
                                        <span class="small">({{ count($course) }})</span>
                                    </div>
                                    <!-- Item -->
                                @endforeach


                            </div>
                            <!-- Related Topic END -->
                        </div>

                        <div class="col-12 col-sm-6 col-lg-12 d-none">
                            <!-- Tags START -->
                            <div class="card card-body shadow p-4">
                                <h4 class="mb-3">Popular Tags</h4>
                                <ul class="list-inline mb-0">
                                    <li class="list-inline-item"><a class="btn btn-outline-light btn-sm"
                                            href="#">blog</a></li>
                                    <li class="list-inline-item"><a class="btn btn-outline-light btn-sm"
                                            href="#">business</a></li>
                                    <li class="list-inline-item"><a class="btn btn-outline-light btn-sm"
                                            href="#">theme</a></li>
                                    <li class="list-inline-item"><a class="btn btn-outline-light btn-sm"
                                            href="#">bootstrap</a></li>
                                    <li class="list-inline-item"><a class="btn btn-outline-light btn-sm"
                                            href="#">data science</a></li>
                                    <li class="list-inline-item"><a class="btn btn-outline-light btn-sm"
                                            href="#">web development</a></li>
                                    <li class="list-inline-item"><a class="btn btn-outline-light btn-sm"
                                            href="#">tips</a></li>
                                    <li class="list-inline-item"><a class="btn btn-outline-light btn-sm"
                                            href="#">machine learning</a></li>
                                </ul>
                            </div>
                            <!-- Tags END -->
                        </div>
                    </div><!-- Row End -->
                </div>
                <!-- Right sidebar END -->
            </div><!-- Row END -->
        </div>
    </section>
    <!-- =======================
        Page content END -->
@endsection
