@extends('frontend.master')
@section('title')
    {{ $item->course_name }} Course
@endsection

@section('meta')
    <meta name="title" content="Freelancing-Career in Bangladesh: From Learning to Earning">
    <meta name="description" content="Start your freelancing career with expert-led courses on in-demand skills and live projects. Get certified and have a chance to join our agency!">
    <meta name="keywords" content="freelancing career courses in Bangladesh">
    
    <meta name="og:title" content="Freelancing-Career in Bangladesh: From Learning to Earning">
    <meta name="og:image" content="{{asset('frontend-assets')}}/images/meta_image.png">
@endsection

@push('css')
<style>
        .btn-white-shadow.animate {
            box-shadow: 0 0 0 12px rgba(255, 255, 255, 0.4);
        }
        .benefit-card {
            height: 275px;
        }
        .benefit-title {
            font-size: 17px;
        }
        .benefit-description {
            font-size: 13px;
        }
        
        footer {
            margin-bottom: 70px;
        }
        
        @media (min-width: 1200px) {
            .media-image-h {
                height: 60vh;
            }
        }
        
        @media (max-width: 767px) {
            .fixed-bottom-enroll-wrapper {
                bottom: 60px;
            }
            
            .fixed-bottom-enroll-title {
                font-size: 10px;
            }
            
            .fixed-bottom-enroll-price {
                font-size: 8px;
            }
            
            .fixed-bottom-enroll-button {
                font-size: 9px;
                padding: 7px;
            }
            
            .software-title {
                font-size: 12px;
            }
            
            .software-img {
                height: 40px;
                width: 40px;
            }
            
            footer {
                margin-bottom: 40px !important;
            }
        }
    </style>
@endpush

@section('content')
    @php
        $enroll_check = null;
        if (Auth::user() && Auth::user()->role == 3) {
            $enroll_check = findEnrollment($item->id);
        }
    @endphp
    <section class="pt-3">
        <div class="container" data-sticky-container="">
            <div class="row g-4">
                <h4 class="text-center text-success d-none">{{ Session('message') }}</h4>
                <!-- Main content START -->
                <div class="col-xl-8">

                    <div class="row g-4">
                        <!-- Title START -->
                        <div class="col-12">
                            <!-- Title -->
                            <h2 class="text-center text-sm-start">{{ $item->course_name }}
                                @if ($item->course_status_id == 2)
                                    <span style="color: #EB343C">( Upcoming )</span>
                                @endif
                            </h2>

                        </div>
                        <div class="col-12">
                            <img src="{{ asset($item->image) }}" class=" rounded-3 w-100 " style="" alt="">
                        </div>
                        <!-- Title END -->

                        <div class="col-12 d-none">
                            <h5><span style="color: #EB343C">Instructors</span> :
                                @foreach ($teachers as $index => $teacher)
                                    <a href="#instructor">{{ $teacher->teacher->name }}</a>
                                    @if ($index < count($batches) - 2)
                                        ,
                                    @endif
                                @endforeach
                            </h5>
                        </div>
                        @if ($webinar)
                            <div class="col-12">
                                <div
                                    class=" d-flex flex-column flex-lg-row justify-content-center align-items-center gap-3 gap-lg-4">
                                    <!-- Image Section -->
                                    <div class="col-lg-6 col-md-6 col-12 order-2 order-lg-1">
                                        <div class="w-100 w-md-100 aspect-ratio rounded-3 "
                                            style="background-color: #faf0f3;height: 100%;padding: 20px;">
                                            <h3>
                                                Join The Webinar to Learn The Following Topics
                                            </h3>
                                            @foreach ($topics as $topic)
                                                <div class="pb-2 d-flex align-items-center">
                                                    <img class="me-2" width="20px"
                                                        src="{{ asset('frontend-assets') }}/icons/check-box.png"
                                                        alt="" srcset="">
                                                    <span>{{ $topic->topic }}</span>
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                    <!-- Text and Button Section -->
                                    <div class="col-lg-6 col-md-6 col-12 order-1 order-lg-2">
                                        <div
                                            class="w-100 w-md-auto d-flex flex-column align-items-start gap-3 flex-shrink-0">
                                            <!-- Promo Badge and Title -->
                                            <div class="w-100 w-md-auto d-flex flex-column gap-2">
                                                <div class="d-flex bg-danger bg-opacity-20 rounded-pill py-1 px-3 align-items-center gap-2"
                                                    style="width: 180px;">
                                                    <div class="">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="18"
                                                            height="18" viewBox="0 0 12 12" fill="none">
                                                            <path
                                                                d="M2.4645 2.5L3.1715 3.207C2.79952 3.57804 2.50453 4.01893 2.30348 4.50434C2.10244 4.98975 1.9993 5.5101 2 6.0355C2 7.1405 2.4475 8.1405 3.1715 8.864L2.465 9.5705C1.99999 9.10682 1.63118 8.55583 1.37977 7.94918C1.12836 7.34253 0.999298 6.69218 1 6.0355C0.999167 5.37877 1.12812 4.72835 1.37944 4.12161C1.63077 3.51487 1.99952 2.96378 2.4645 2.5ZM9.5355 2.5C10.0005 2.96378 10.3692 3.51487 10.6206 4.12161C10.8719 4.72835 11.0008 5.37877 11 6.0355C11.0008 6.69223 10.8719 7.34265 10.6206 7.94939C10.3692 8.55613 10.0005 9.10722 9.5355 9.571L8.8285 8.864C9.20049 8.49296 9.49548 8.05207 9.69652 7.56666C9.89757 7.08125 10.0007 6.5609 10 6.0355C10 4.9305 9.5525 3.9305 8.8285 3.207L9.535 2.5005L9.5355 2.5ZM3.8785 3.914L4.586 4.6215C4.39999 4.80696 4.25245 5.02736 4.15189 5.27002C4.05132 5.51268 3.99971 5.77282 4 6.0355C4 6.588 4.224 7.088 4.586 7.4495L3.8785 8.157C3.59952 7.8787 3.37829 7.54801 3.22752 7.18393C3.07676 6.81985 2.99944 6.42956 3 6.0355C3 5.207 3.336 4.457 3.8785 3.914ZM8.1215 3.914C8.40049 4.1923 8.62172 4.52299 8.77249 4.88707C8.92325 5.25115 9.00057 5.64144 9 6.0355C9.00057 6.42956 8.92325 6.81985 8.77249 7.18393C8.62172 7.54801 8.40049 7.8787 8.1215 8.157L7.414 7.4495C7.60002 7.26404 7.74755 7.04364 7.84812 6.80098C7.94869 6.55832 8.0003 6.29818 8 6.0355C8.0003 5.77282 7.94869 5.51268 7.84812 5.27002C7.74755 5.02736 7.60002 4.80696 7.414 4.6215L8.1215 3.914ZM6 7.0355C5.73479 7.0355 5.48043 6.93014 5.2929 6.74261C5.10536 6.55507 5 6.30072 5 6.0355C5 5.77028 5.10536 5.51593 5.2929 5.32839C5.48043 5.14086 5.73479 5.0355 6 5.0355C6.26522 5.0355 6.51957 5.14086 6.70711 5.32839C6.89465 5.51593 7 5.77028 7 6.0355C7 6.30072 6.89465 6.55507 6.70711 6.74261C6.51957 6.93014 6.26522 7.0355 6 7.0355Z"
                                                                fill="#ffffff"></path>
                                                        </svg>

                                                    </div>
                                                    <p style="color: white" class="text-uppercase mb-0">Webinar </p>
                                                </div>
                                                <p class="h4 h-md-2 text-center text-md-start pt-2" style="color: black;">
                                                    {{ $webinar->title }}</p>
                                            </div>
                                            <!-- Details and Button -->
                                            <div class="d-flex flex-column gap-2" style="width: 100%">
                                                <p class="mb-2 text-body text-center text-md-start" style="color: black;">
                                                    Join And Get Details</p>
                                                <div class="d-flex flex-column flex-md-row justify-content-between align-items-center py-3 px-4 w-100 rounded-3"
                                                    style="background-color: #D6293E">
                                                    <div class="d-flex flex-column align-items-start gap-2">
                                                        <p class="mb-1" style="color: white;">
                                                            @if ($webinar->price == 0)
                                                                Free Webinar
                                                            @else
                                                                {{ $webinar->price }} BDT
                                                            @endif
                                                        </p>
                                                        <div class="d-flex align-items-center gap-2">
                                                            <i
                                                                class="fa fa-calendar"style="font-size: 16px;color: white;"></i>
                                                            <p class="mb-0" style="color: white;">
                                                                {{ date('d M, Y', strtotime($webinar->date)) }}
                                                                {{ date('H:i a', strtotime($webinar->time)) }}</p>
                                                        </div>
                                                    </div>
                                                    <button type="button" class="btn btn-dark btn-lg mt-3 mt-lg-0 p-2"
                                                        data-bs-toggle="modal" data-bs-target="#webinarModal">
                                                        <span>Click Here</span>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endif

                        <!-- Course description START -->
                        <div class="col-12">
                            <div class="card shadow">
                                <!-- Card header START -->
                                <div class="card-header border-bottom">
                                    <h4 class="mb-0">Course Description</h4>
                                </div>
                                <!-- Card header END -->

                                <!-- Card body START -->
                                <div class="card-body">
                                    <p class="mb-3">Welcome to the <strong> {{ $item->course_name }}(Over
                                            {{ $item->course_duration }} of content)</strong></p>
                                    <p class="mb-0">
                                        {!! $item->course_description !!}
                                    </p>

                                </div>
                                <!-- Card body START -->
                            </div>
                        </div>

                        {{-- ===================== Batches ================= --}}


                        <div class="col-12">
                            <div class="card shadow">
                                <div class="card-header border-bottom">
                                    <h4 class="mb-0 text-start text-md-start">Batches</h4>
                                </div>
    
                                <div class="card-body">
                                    <ul class="nav nav-pills my-4 mt-1" id="pills-tab" role="tablist">
        
                                        @foreach ($course_branches as $branch)
                                            <li class="nav-item" role="presentation">
                                                <button class="nav-link {{ $loop->first ? 'active' : '' }}"
                                                    id="pills-{{ $branch->id }}-tab" data-bs-toggle="pill"
                                                    data-bs-target="#pills-{{ $branch->id }}" type="button" role="tab"
                                                    aria-controls="pills-{{ $branch->id }}"
                                                    aria-selected="{{ $loop->first ? 'true' : 'false' }}">
                                                    {{ $branch->branch_name }}
                                                </button>
                                            </li>
                                        @endforeach
                                    </ul>
        
                                    <div class="tab-content" id="pills-tabContent">
                                        @foreach ($course_branches as $branch)
                                            <div class="tab-pane fade {{ $loop->first ? 'show active' : '' }}"
                                                id="pills-{{ $branch->id }}" role="tabpanel"
                                                aria-labelledby="pills-{{ $branch->id }}-tab">
                                                @if (isset($batches[$branch->id]) && count($batches[$branch->id]) > 0)
                                                    <div class="col-md-12">
                                                        <div class="w-100">
                                                            <div class="row">
                                                                @foreach ($batches[$branch->id] as $batch_key=> $batch)
                                                                    <!--<div class="{{ count($batches[$branch->id]) > 1 ? 'col-12 col-md-6' : 'col-12 col-md-12' }} @if($batch_key > 1) mt-3 @elseif($batch_key > 0) mt-3 mt-md-0 @endif">-->
                                                                    <div class="col-sm-6 @if($batch_key > 1) mt-3 @elseif($batch_key > 0) mt-3 mt-md-0 @endif">
                                                                        <div class="py-3 px-4 rounded-3"
                                                                            style="background-color: #EB343C;">
                                                                            <div class="d-flex flex-column align-items-start gap-2">
                                                                                <p class="mb-1" style="color: white;">
                                                                                    {{ $batch->batch_name }}</p>
                                                                                <div class="d-flex align-items-center gap-2">
                                                                                    <i class="fa fa-calendar mb-auto mt-1 me-2"
                                                                                        style="font-size: 16px;color: white;"></i>
                                                                                    <div class="mb-0" style="color: white;">
                                                                                        <div class="batch_days"
                                                                                            style="font-size: 13px; height: 40px">
                                                                                            @php
                                                                                                $days = json_decode(
                                                                                                    $batch->days,
                                                                                                );
                                                                                                $week_days = [
                                                                                                    'Saturday',
                                                                                                    'Sunday',
                                                                                                    'Monday',
                                                                                                    'Tuesday',
                                                                                                    'Wednesday',
                                                                                                    'Thursday',
                                                                                                    'Friday',
                                                                                                ];
                                                                                            @endphp
                                                                                            @foreach ($days as $key5 => $day)
                                                                                                {{ $week_days[$day - 1] }}
                                                                                                @if ($key5 + 1 < count($days))
                                                                                                    ,
                                                                                                @endif
                                                                                            @endforeach
                                                                                        </div>
                                                                                        <span
                                                                                            class="mt-2">{{ $batch->time }} ({{$batch->batch_type == 1 ? 'Online':'Offline'}})</span>
                                                                                          
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                @endforeach
                                                            </div>
                                                        </div>
                                                    </div>
                                                @else
                                                    <p>No batches available for this branch.</p>
                                                @endif
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        </div>

                        {{-- =================== End Batches ============= --}}

                        {{-- =======================What You Will Learn================== --}}
                        @if (count($outcomes) > 0)
                            <!-- FAQs START -->
                            <div class="col-12">
                                <div class="card shadow rounded-3">
                                    <!-- Card header START -->
                                    <div class="card-header border-bottom">
                                        <h4 class="mb-0">What You Will Learn</h4>
                                    </div>
                                    <!-- Card header END -->

                                    <!-- Card body START -->
                                    <div class="row card-body">
                                        <!-- FAQ item -->
                                        @foreach ($outcomes as $key => $outcome)
                                            <div
                                                class="col-md-6 col-sm-6 col-12 {{ $key==1 ? 'mt-1 mt-sm-0' : '' }} {{ $key>1 ? 'mt-1' : '' }}">
                                                <img class="me-2" width="20px"
                                                    src="{{ asset('frontend-assets') }}/icons/check-box.png"
                                                    alt="" srcset="">
                                                {{ $outcome->content }}
                                            </div>
                                        @endforeach
                                    </div>
                                    <!-- Card body START -->
                                </div>
                            </div>
                        @endif
                        {{-- =============== End What You Will Learn =============== --}}

                        {{-- ===================Softwares You Will Learn ==================== --}}
                        @if (count($software_learning) > 0)
                            <!-- FAQs START -->
                            <div class="col-12">
                                <div class="card shadow rounded-3">
                                    <!-- Card header START -->
                                    <div class="card-header border-bottom">
                                        <h4 class="mb-0">Softwares You Will Learn</h4>
                                    </div>
                                    <!-- Card header END -->

                                    <!-- Card body START -->
                                    <div class="row card-body">
                                        <!-- FAQ item -->
                                        @foreach ($software_learning as $software)
                                            <div class="col-lg-4 col-md-4 col-6 mb-4">
                                                <div class="d-flex">


                                                    <img class="software-img" src="{{ asset($software->image) }}" height="50px"
                                                        width="50px" alt="">


                                                    <div class="ms-2 ms-sm-3 my-auto">
                                                        <h6 class="mb-0 software-title" style="margin: 15px 0 font-size: 18px;">
                                                            {{ $software->content }}
                                                        </h6>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                    <!-- Card body START -->
                                </div>
                            </div>
                        @endif
                        {{-- ================== ENd Softwares You Will Learn=============== --}}

                        {{-- ======================= Benifits ======================== --}}
                        @if (count($benefits) > 0)
                        <div class="col-12">
                            <div class="card shadow rounded-3">
                                <div class="card-header border-bottom">
                                    <!-- Title -->
                                    <h4 class="mb-2 text-center text-md-start">What You Will Get</h4>
                                </div>
                                <div class="card-body row g-4 pt-3">
                                    <!-- Item -->
                                    @foreach ($benefits as $benefit)
                                        <div class="col-sm-6 col-md-4 col-xl-4">
                                            <div
                                                class="card card-body bg-success bg-opacity-10 text-center position-relative btn-transition benefit-card">
                                                <!-- Image -->
                                                <div class="icon-xl bg-body mx-auto rounded-circle mb-3">
                                                    <img src="{{ asset($benefit->thumbnail) }}" alt="">
                                                </div>
                                                <!-- Title -->
                                                <h5 class="mb-2 benefit-title"><span
                                                        class="stretched-link text-capitalize">{{ $benefit->benefit }}</span></h5>
                                                <p class="mb-0 benefit-description">{{ $benefit->description }}</p>
                                            </div>
                                        </div>
                                    @endforeach

                                </div>
                            </div>
                        </div>
                        @endif
                        {{-- ================== End Benifits ==================== --}}

                        @if($item->is_show_project == 1)
                            @if (count($projects) > 0)
                                {{-- ================= Real Life Projects ============= --}}
                                <div class="row g-4 mt-4">
                                    <h5>Real Life Projects</h5>
                                    @foreach ($projects as $project)
                                        <div class="col-md-6 col-xl-6 col-12 mt-3">
                                            <div class="card shadow card-body shadow p-2 border-0">
                                                <div class="row align-items-center">
                                                    <!-- Image -->
                                                    <div class="col-4 col-md-4 col-lg-4 col-xl-4 d-flex justify-content-center">
                                                        <img class="rounded-1 h-60px" src="{{ asset($project->thumbnail) }}"
                                                            alt="university logo">
                                                    </div>
    
                                                    <!-- University Name -->
                                                    <div class="col-8 col-md-8 col-lg-8 col-xl-8">
                                                        <h6 class="card-title mb-0 align-content-center">{{ $project->name }}</h6>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
    
    
                                </div>
                                {{-- =============== End Real Life Projects ================= --}}
                            @endif
                        @endif
                        
                        {{-- =================== FAQ ================= --}}
                        @if (count($faq) > 0)
                            <!-- FAQs START -->
                            <div class="col-12">
                                <div class="card shadow">
                                    <!-- Card header START -->
                                    <div class="card-header border-bottom">
                                        <h4 class="mb-0">Frequently Asked Questions</h4>
                                    </div>
                                    <!-- Card header END -->

                                    <!-- Card body START -->
                                    <div class="card-body">
                                        <!-- FAQ item -->
                                        <!-- FAQ START -->
                                        <div class="accordion accordion-icon accordion-bg-light" id="accordionExample2">


                                            @foreach ($faq as $key_query => $query)
                                                <div class="accordion-item mb-3">
                                                    <h6 class="accordion-header font-base"
                                                        id="heading-{{ $key_query }}">
                                                        <button
                                                            class="accordion-button fw-bold rounded d-inline-block {{ $key_query == 0 ? 'collapse' : 'collapsed d-block pe-5' }}"
                                                            type="button" data-bs-toggle="collapse"
                                                            data-bs-target="#collapse-{{ $key_query }}"
                                                            aria-expanded="{{ $key_query == 0 ? 'true' : 'false' }}"
                                                            aria-controls="collapse-{{ $key_query }}">
                                                            {{ $query->question }}
                                                        </button>
                                                    </h6>
                                                    <!-- Body -->
                                                    <div id="collapse-{{ $key_query }}"
                                                        class="accordion-collapse collapse {{ $key_query == 0 ? 'show' : '' }}"
                                                        aria-labelledby="heading-{{ $key_query }}"
                                                        data-bs-parent="#accordionExample2">
                                                        <div class="accordion-body mt-3">
                                                            {{ $query->answer }}
                                                        </div>
                                                    </div>
                                                </div>
                                            @endforeach

                                        </div>
                                        <!-- FAQ END -->

                                    </div>
                                    <!-- Card body START -->
                                </div>
                            </div>
                        @endif
                        
                        @if($item->is_show_more == 1)
                        <!-- Course description START -->
                        <div class="col-12">
                            <div class="card shadow">
                                <!-- Card header START -->
                                <div class="card-header border-bottom">
                                    <h4 class="mb-0">More About This Course</h4>
                                </div>
                                <!-- Card header END -->

                                <!-- Card body START -->
                                <div class="card-body">
                                    <p class="mb-0">
                                        {!! $item->more_about !!}
                                    </p>

                                </div>
                                <!-- Card body START -->
                            </div>
                        </div>
                        @endif
                    </div>
                </div>
                <!-- Main content END -->
                <style>
                    [data-sticky] {
                        position: -webkit-sticky;
                        position: sticky;
                        top: 28px;
                        /* Adjust this value if you have a fixed header or other elements */
                        z-index: 1000;
                        /* Ensure it stays above other content */
                    }
                </style>
                <!-- Right sidebar START -->
                <div class="col-xl-4">
                    <div data-sticky="" data-margin-top="" data-sticky-for="">
                        <div class="row g-4">
                            <div class="col-md-6 col-xl-12">
                                <div class="row">
                                    
                                    <div class="col-12" style="margin-bottom:1.6rem !important;">
                                        <div class="card shadow"
                                            style="
                                        height: 32vh;
                                    ">
                                            <div class="card-body p-0">
                                                <div class="overflow-hidden rounded-3 position-relative" style="height: 32vh">
                                                    <!-- Video iframe -->
                                                    <iframe src="{{ $item->intro_video }}" class="w-100"
                                                        style="height: 32vh" frameborder="0" allowfullscreen></iframe>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <!-- Course video -->
                                    <div class="col-12 text-center position-relative d-none" style="margin-bottom:1.6rem !important;">
                                        <img src="{{ asset(getContent('homepage_top_image')) }}" class="border border-5 border-white rounded-2"
                                            alt="">
                                        <div class="position-absolute top-50 start-50 translate-middle">
                                            <!-- Video link -->
                                            <a href=""
                                                class="btn text-danger btn-round btn-white-shadow animate btn-lg mb-0" data-glightbox=""
                                                data-gallery="course-tour">
                                                <i class="fas fa-play"></i>
                                            </a>
                                        </div>
                                    </div>
                                    <!-- Course video END -->
                                    
                                    @if ($item->course_status_id == 1)
                                        <div class="col-12" style="margin-bottom:1.6rem !important;" id="enrollNow">
                                            <div class="card shadow p-4 " id="pricingSection"
                                                style="background-color: #EB343C;">
                                                <div class="card-body">
                                                    <div class="text-center d-flex justify-content-center align-items-center flex-wrap"style="
                                                                                color: white;
                                                                            ">
                                                        <div class="d-flex align-items-baseline">
                                                            <h3 class="fw-bold mb-0 me-1"
                                                                style="
                                                color: white;
                                            ">
                                                                @if (session('coupon') != null && session('coupon')['discount_type'] == 0)
                                                                    @php
                                                                        $base_price =
                                                                            $item->course_fee;
                                                                        $final_price =
                                                                            $base_price - ($item->course_fee *session('coupon')['discount']) / 100;
                                                                    @endphp
                                                                    <span style="color: white;">
                                                                        <!-- Green check icons -->
                                                                        <svg xmlns="http://www.w3.org/2000/svg"
                                                                            width="16" height="16"
                                                                            viewBox="0 0 20 20" fill="none">
                                                                            <path
                                                                                d="M9.67094 11.4666L10.8476 12.6433L17.9026 5.58825L19.0809 6.76659L10.8476 14.9999L5.54427 9.69659L6.7226 8.51826L8.49344 10.2891L9.67094 11.4658V11.4666ZM9.6726 9.10992L13.7993 4.98242L14.9743 6.15742L10.8476 10.2849L9.6726 9.10992ZM7.31677 13.8224L6.13927 14.9999L0.835938 9.69659L2.01427 8.51826L3.19177 9.69576L3.19094 9.69659L7.31677 13.8224Z"
                                                                                fill="currentColor"></path>
                                                                        </svg>
                                                                        <!-- Final price -->
                                                                        {{ $final_price }}
                                                                    </span>
                                                                @elseif(session('coupon') != null && session('coupon')['discount_type'] == 1)
                                                                    <span style="color: white;">
                                                                        <!-- Green check icons -->
                                                                        <svg xmlns="http://www.w3.org/2000/svg"
                                                                            width="16" height="16"
                                                                            viewBox="0 0 20 20" fill="none">
                                                                            <path
                                                                                d="M9.67094 11.4666L10.8476 12.6433L17.9026 5.58825L19.0809 6.76659L10.8476 14.9999L5.54427 9.69659L6.7226 8.51826L8.49344 10.2891L9.67094 11.4658V11.4666ZM9.6726 9.10992L13.7993 4.98242L14.9743 6.15742L10.8476 10.2849L9.6726 9.10992ZM7.31677 13.8224L6.13927 14.9999L0.835938 9.69659L2.01427 8.51826L3.19177 9.69576L3.19094 9.69659L7.31677 13.8224Z"
                                                                                fill="currentColor"></path>
                                                                        </svg>
                                                                        <!-- Final price -->
                                                                        {{ $item->course_fee - (session('coupon')['discount']) }}
                                                                    </span>
                                                                @else
                                                                    {{ $item->course_fee - $item->discount }}
                                                                @endif
                                                            </h3>
                                                            <span class="fw-bold mb-0">BDT</span>
                                                        </div>
                                                        @if($item->discount && $item->discount > 0)
                                                            @php
                                                                $discountPercentage = (int) ($item->discount * 100 / $item->course_fee);
                                                            @endphp
                                                            <del class=" mb-0 ms-2">{{ $item->course_fee }} BDT <span class="badge text-bg-orange mb-0 ms-1">{{ $discountPercentage }}% off</span></del>
                                                        @endif
                                                        @if(session('coupon') != null)
                                                        <div class="d-flex align-items-center mt-2">
                                                            <small style="font-size: 10px" class="text-white">After Applying Coupon You Got {{session('coupon')['discount']}}{{session('coupon')['discount_type'] == 1 ? 'BDT':'%'}} Discount</small>
                                                        </div>
                                                        @endif
                                                        <div class="d-flex align-items-center mt-2" style="width:75%">
                                                            <!-- Icon -->
                                                            {{-- <img class="w-4 h-4 me-2 border-1 border-white"
                                                                src="{{ asset('frontend-assets') }}/icons/coupon.png"
                                                                alt="Coupon Icon"> --}}
                                                            <!--<img class="w-4 h-4 me-2 border-1 border-white" src="{{ asset('frontend-assets') }}/icons/coupon.png" alt="Coupon Icon">-->
                                                            <!--<img class="w-4 h-4 me-2 border-1 border-white" src="{{ asset('frontend-assets') }}/icons/discount.png" alt="Coupon Icon">-->
                                                            <img class="w-4 h-4 me-2 border-1 border-white"
                                                                src="{{ asset('frontend-assets') }}/icons/discount-1.png"
                                                                alt="Coupon Icon">
                                                            {{--                                                        <img class="w-4 h-4 me-2 " src="https://cdn.ostad.app/public/icons/coupon-3-line.svg" alt="Coupon Icon"> --}}
                                                            <!-- Promo Code Form -->
                                                            <form action="{{ route('coupon.apply') }}" method="POST"
                                                                class="d-flex align-items-center w-100">
                                                                @csrf
                                                                <div class="input-group">
                                                                    <input type="text" class="form-control"
                                                                        id="promoCode" name="coupon_code"
                                                                        placeholder="Promo Code" required>
                                                                    <input type="hidden" value="{{ $item->id }}"
                                                                        name="course_id">
                                                                    <button type="submit"
                                                                        class="btn btn-primary border-1 border-white">Apply</button>
                                                                </div>
                                                            </form>
                                                        </div>
                                                    </div>
                                                    <!-- Buttons -->
                                                    <div class="mt-3 d-grid">
                                                        @auth
                                                            @if (Auth::user()->role == 3 && $enroll_check == null)
                                                                <a href="{{ route('checkout',$item->slug) }}" class="btn"
                                                                    style="
                                                            background-color: white;
                                                            color: black;
                                                        ">Enroll
                                                                    Now</a>
                                                            @elseif(Auth::user()->role == 3 && $enroll_check != null)
                                                                <button type="button" class="btn btn-white"
                                                                    disabled>Enrolled</button>
                                                            @else
                                                                <a href="#" class="btn btn-white"
                                                                    style="
                                                            background-color: white;
                                                            color: black;
                                                        ">Enroll
                                                                    Now</a>
                                                            @endif
                                                        @endauth
                                                        @guest
                                                            {{-- @php
                                                        dd('ok');
                                                    @endphp --}}
                                                            <a href="{{ route('student.enroll', $item->slug) }}"
                                                                class="btn btn-white">Enroll Now</a>
                                                        @endguest
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                    @endif
                                    <div class="col-12" style="margin-bottom:1.6rem !important;">
                                        <div class="card shadow p-4 ">
                                            <!-- Course info START -->
                                            <div class="card-body">
                                                <!-- Price and share button -->
                                                <!-- Divider -->
                                                <!--<hr>-->
                                                <!-- Title -->
                                                <h5 class="mb-3">This Course Includes</h5>
                                                <ul class="list-group list-group-borderless border-0">
                                                    <li class="list-group-item px-0 d-flex justify-content-between">
                                                        <span class="h6 fw-light mb-0"><i
                                                                class="fas fa-fw fa-layer-group text-primary"></i>Course
                                                            Type</span>
                                                        <span>{{ Str::title($item->course_type) }}</span>
                                                    </li>
                                                    <li class="list-group-item px-0 d-flex justify-content-between">
                                                        <span class="h6 fw-light mb-0"><i
                                                                class="fas fa-fw fa-book-open text-primary"></i>Lectures</span>
                                                        <span>{{ $item->total_lectures }}</span>
                                                    </li>
                                                    <li class="list-group-item px-0 d-flex justify-content-between">
                                                        <span class="h6 fw-light mb-0"><i
                                                                class="fas fa-fw fa-project-diagram text-primary"></i>Projects</span>
                                                        <span>{{ $item->project ?? 0 }}</span>
                                                    </li>
                                                    <li class="list-group-item px-0 d-flex justify-content-between">
                                                        <span class="h6 fw-light mb-0"><i
                                                                class="fas fa-fw fa-clock text-primary"></i>Duration</span>
                                                        <span>{{ $item->course_duration }}</span>
                                                    </li>
                                                    <li class="list-group-item px-0 d-flex justify-content-between">
                                                        <span class="h6 fw-light mb-0"><i
                                                                class="fas fa-fw fa-user-clock text-primary"></i>Starting
                                                            Date</span>
                                                        <span>{{ date('d M, Y', strtotime($item->start_date)) }}</span>
                                                    </li>
                                                </ul>
                                            </div>
                                            <!-- Course info END -->

                                        </div>

                                    </div>
                                    <div class="col-12 d-none" style="margin-bottom:1.6rem !important">
                                        <div class="card card-body shadow p-4 mb-4">
                							<!-- Title -->
                							<h4 class="mb-3">Recently Viewed</h4>
                							<!-- Course item START -->
                							<div class="row gx-3 mb-3">
                								<!-- Image -->
                								<div class="col-4">
                									<img class="rounded" src="{{ asset('frontend-assets') }}/icons/discount-1.png" alt="">
                								</div>
                								<!-- Info -->
                								<div class="col-8">
                									<h6 class="mb-0"><a href="#">Fundamentals of Business Analysis</a></h6>
                									<ul class="list-group list-group-borderless mt-1 d-flex justify-content-between">
                										<li class="list-group-item px-0 d-flex justify-content-between">
                											<span class="text-success">$130</span>
                											<span class="h6 fw-light">4.5<i class="fas fa-star text-warning ms-1"></i></span>
                										</li>
                									</ul>
                								</div>
                							</div>
                							<!-- Course item END -->
                
                							<!-- Course item START -->
                							<div class="row gx-3">
                								<!-- Image -->
                								<div class="col-4">
                									<img class="rounded" src="{{ asset('frontend-assets') }}/icons/discount-1.png" alt="">
                								</div>
                								<!-- Info -->
                								<div class="col-8">
                									<h6 class="mb-0"><a href="#">The Complete Video Production Bootcamp</a></h6>
                									<ul class="list-group list-group-borderless mt-1 d-flex justify-content-between">
                										<li class="list-group-item px-0 d-flex justify-content-between">
                											<span class="text-success">$150</span>
                											<span class="h6 fw-light">4.0<i class="fas fa-star text-warning ms-1"></i></span>
                										</li>
                									</ul>
                								</div>
                							</div>
                							<!-- Course item END -->
                						</div>
                                    </div>
                                    <div class="col-12" style="margin-bottom:1.6rem !important;">
                                        <div class="card shadow p-4">
                                            <div class="card-body">
                                                <h5 class="mb-3">Good To Know</h5>
                                                @if (count($good_to_know) > 0)
                                                    <ul class="list-group list-group-borderless border-0">
                                                        @foreach ($good_to_know as $pre_req)
                                                            <li
                                                                class="list-group-item px-0 d-flex justify-content-between">
                                                                <span class="h6 fw-light mb-0"><i
                                                                        class="fas fa-fw fa-book text-primary"></i>{{ $pre_req->module_name }}</span>
                                                            </li>
                                                        @endforeach
                                                    </ul>
                                                @else
                                                    <span class="h6 fw-light mb-0">No Prior Knowledge Needed</span>
                                                @endif
                                            </div>
                                        </div>

                                    </div>
                                </div>

                                <!-- Good To Know Section END -->
                            </div>
                        </div><!-- Row End -->
                    </div>
                </div>


                <!-- Right sidebar END -->

            </div><!-- Row END -->
        </div>
    </section>
    <div class="custom-nav-container fixed-bottom-enroll-wrapper d-block" style="
            height: auto;
            padding-top: 10px;
            padding-bottom: 10px;
            background: #fff;
            box-shadow: 0px 0px 16px 0px #4444;
            z-index: 999999;
        ">
            <div class="container h-100">
                <div class="row h-100 align-items-center">
                    <div class="col-8 col-md-10 d-flex align-items-center">
                        <div>
                            <h5 class="m-0 fixed-bottom-enroll-title">{{ $item->course_name }}</h5>
                            <p class="m-0 fixed-bottom-enroll-price">Course Fee: {{ $item->course_fee - $item->discount }} BDT</p>
                        </div>
                    </div>
                    <div class="col-4 col-md-2 d-flex justify-content-end">
                        <a href="#enrollNow" class="btn btn-primary border m-0 fixed-bottom-enroll-button">Enroll Now</a>
                    </div>
                </div>
            </div>
    </div>
    <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Payment Information</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form action="{{ route('student.course.enroll') }}" method="POST">
                    @csrf
                    <input type="hidden" value="{{ $item->id }}" name="course_id">

                    @if (session('coupon') != null && session('coupon')['discount_type'] == 0)
                        @php
                            $base_price = $item->course_fee - $item->discount;
                        @endphp
                        <input type="hidden" value="{{ ($base_price * session('coupon')['discount']) / 100 }}"
                            name="coupon_discount">
                    @elseif(session('coupon') != null && session('coupon')['discount_type'] == 1)
                        <input type="hidden" value="{{ session('coupon')['discount'] }}" name="coupon_discount">
                    @else
                        <input type="hidden" value="0" name="coupon_discount">
                    @endif
                    <!-- course_id is stored here -->
                    <div class="modal-body">
                        <div class="row mb-3">
                            <div class="col-md-12">
                                @if ($item->course_type == 'online and offline')
                                    <div class="form-group mb-3">
                                        <label for="" class="form-control-label">Course Type <span
                                                class="text-danger">*</span></label>
                                        <select name="course_type" class="form-control" required>
                                            <option value="">Select Course Type</option>
                                            <option value="online">Online</option>
                                            <option value="offline">Offline</option>
                                        </select>
                                    </div>
                                @endif
                                <div class="form-group mb-3">
                                    <label for="" class="form-control-label">Branch <span
                                            class="text-danger">*</span></label>
                                    <select name="branch_id" id="branchSelect" class="form-control" required>
                                        <option value="">Select Branch</option>
                                        @foreach ($branches as $branch)
                                            <option value="{{ $branch->id }}">{{ $branch->branch_name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group mb-3">
                                    <label for="" class="form-control-label">Batch <span
                                            class="text-danger">*</span></label>
                                    <select id="batchSelect" name="batch_id" class="form-control" required>
                                        <option value="">Select Batch</option>
                                    </select>
                                </div>
                                <div class="form-group mb-3">
                                    <label for="" class="form-control-label">Payment Method <span
                                            class="text-danger">*</span></label>
                                    <select name="payment_method" id="" class="form-control" required>
                                        <option value="">Select Payment Method</option>
                                        <option value="Bkash">Bkash</option>
                                        <option value="Rocket">Rocket</option>
                                        <option value="Nagad">Nagad</option>
                                        <option value="Upay">Upay</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="" class="form-control-label">Payment Number <span
                                            class="text-danger">*</span></label>
                                    <input type="text" class="form-control" name="payment_number" required>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Enroll</button>
                    </div>
                </form>

            </div>
        </div>
    </div>
    <!-- =======================
                                            Page content END -->
@endsection
@push('js')
<script src="js/aos.js"></script>

	<!-- Template Functions -->
	<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
	<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.min.js"></script>
    <script>
        $(document).ready(function() {
            $('#branchSelect').change(function() {
                var branch_id = $(this).val();
                var course_id = $('input[name="course_id"]').val(); // Get the course_id value
                if (branch_id && course_id) {
                    $.ajax({
                        url: '/get-batches/' + branch_id + '/' + course_id,
                        type: 'GET',
                        success: function(batches) {
                            $('#batchSelect').empty().append(
                                '<option value="">Select Batch</option>');
                            $.each(batches, function(key, batch) {
                                $('#batchSelect').append('<option value="' + batch.id +
                                    '">' + batch.batch_name + ' - ' + batch.time +
                                    '</option>');
                            });
                        },
                        error: function() {
                            alert('Failed to fetch batches. Please try again.');
                        }
                    });
                } else {
                    $('#batchSelect').empty().append('<option value="">Select Batch</option>');
                }
            });
        });
    </script>
    <script>
        document.querySelector('.play-video-btn').addEventListener('click', function(e) {
            e.preventDefault(); // Prevent the default action of the link

            var videoUrl = this.href; // Get the video URL from the link
            var videoPlayer = document.querySelector('#videoPlayer');
            var playButton = this;

            // Hide the play button
            playButton.style.display = 'none';

            // Correct the iframe URL and ensure autoplay and mute parameters are added
            videoPlayer.src = videoUrl.replace("watch?v=", "embed/") + "?autoplay=1&mute=1";

            // Show the iframe in place of the button
            videoPlayer.style.display = 'block';
        });
    </script>
    <script>
        $(document).ready(function() {
            const targetButtons = $('.btn-white-shadow');

            setInterval(() => {
                targetButtons.each(function() {
                    $(this).toggleClass('animate');
                });
            }, 400); // Adjust the interval as needed
        });
    </script>
    
@endpush
