@extends('frontend.master')
@section('title')
    Contact Us
@endsection

@section('meta')
    <meta name="title" content="Contact Freelancing-Career – Let’s Connect">
    <meta name="description" content="Ready to start? Contact us or fill the form to learn about our training in essential skills for freelancing. Dive in now!">
    <meta name="keywords" content="contact freelancing career">
    
    <meta name="og:title" content="Contact Freelancing-Career – Let’s Connect">
    <meta name="og:image" content="{{asset('frontend-assets')}}/images/meta_image.png">
@endsection

@section('content')
    <!-- =======================
    Page Banner START -->
    <section class="pt-5 pb-0"
        style="background-image:url({{ asset('frontend-assets') }}/fonts/map.svg); background-position: center left; background-size: cover;">
        <div class="container">
            <div class="row">
                <div class="col-lg-8 col-xl-6 text-center mx-auto">
                    <!-- Title -->
                    <h6 class="text-primary">Contact us</h6>
                    <h1 class="mb-4">We're here to help!</h1>
                </div>
            </div>

            <div class="row">
                @foreach($branches as $branch)
                    @php
                        $colClass = 'col-lg-4';
                        if (count($branches) == 1) {
                            $colClass = 'col-lg-12';
                        } elseif (count($branches) == 2) {
                            $colClass = 'col-lg-6';
                        }
                    @endphp
                    <div class="{{ $colClass }} col-sm-12 mt-lg-0">
                        <div class="card card-body shadow py-5 text-center h-100">
                            <!-- Title -->
                            <h5 class="mb-3">{{ $branch->branchType->branch_type_name }} Address</h5>
                            <h6 class="mb-3">{{ $branch->branch_name }}</h6>
                            <ul class="list-inline mb-0">
                                <!-- Address -->
                                <li class="list-item mb-3 h6 fw-light">
                                    <!--<a href="">-->
                                        <i class="fas fa-fw fa-map-marker-alt me-2 mt-1"></i>{{ $branch->branch_area }}
                                    <!--</a>-->
                                </li>
                                <!-- Phone number -->
                                <li class="list-item mb-3 h6 fw-light">
                                    <a href="tel:{{ $branch->branch_phone  }}">
                                        <i class="fas fa-fw fa-phone-alt me-2"></i>{{ $branch->branch_phone  }}
                                    </a>
                                </li>
                                <!-- Email id -->
                                <li class="list-item mb-0 h6 fw-light">
                                    <a href="mailto:{{ $branch->branch_email  }}">
                                        <i class="far fa-fw fa-envelope me-2"></i>{{ $branch->branch_email  }}
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                @endforeach
            </div>


            <!-- Contact info box -->

        </div>
    </section>
    <!-- =======================
        Page Banner END -->

    <!-- =======================
        Image and contact form START -->
    <section>
        <div class="container">
            <div class="row g-4 g-lg-0 align-items-center">

                <div class="col-md-6 align-items-center text-center">
                    <!-- Image -->
                    <img src="{{ asset('frontend-assets') }}/fonts/contact.svg" class="h-400px" alt="">

                    <!-- Social media button -->
                    <div class="d-sm-flex align-items-center justify-content-center mt-2 mt-sm-4">
                        <h5 class="mb-0">Follow us on:</h5>
                        <ul class="list-inline mb-0 ms-sm-2">
                            <li class="list-inline-item"> <a class="btn btn-white btn-sm shadow px-2 text-facebook"
                                    href="{{ getSettings('facebook_url') }}"><i class="fab fa-fw fa-facebook-f"></i></a>
                            </li>
                            <li class="list-inline-item"> <a class="btn btn-white btn-sm shadow px-2 text-instagram"
                                    href="{{ getSettings('instagram_url') }}"><i class="fab fa-fw fa-instagram"></i></a>
                            </li>
                            <li class="list-inline-item"> <a class="btn btn-white btn-sm shadow px-2 text-twitter"
                                    href="{{ getSettings('twitter_url') }}"><i class="fab fa-fw fa-twitter"></i></a> </li>
                            <li class="list-inline-item"> <a class="btn btn-white btn-sm shadow px-2 text-linkedin"
                                    href="{{ getSettings('linkedIn_url') }}"><i class="fab fa-fw fa-linkedin-in"></i></a>
                            </li>
                            <li class="list-inline-item"> <a class="btn btn-white btn-sm shadow px-2 text-youtube"
                                    href="{{ getSettings('youtube_url') }}"><i class="fab fa-fw fa-youtube"></i></a> </li>
                        </ul>
                    </div>
                </div>

                <!-- Contact form START -->
                <div class="col-md-6">
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    <!-- Title -->
                    <h2 class="mt-4 mt-md-0">Let's talk</h2>
                    <p>To know about any course, curriculum or any suggestions related to which is perfect for you contact us now!</p>

                    <form action="{{ route('user.message.send') }}" method="POST">
                        @csrf
                        <!-- Name -->
                        <div class="mb-4 bg-light-input">
                            <label for="yourName" class="form-label">Your name *</label>
                            <input type="text" name="name" class="form-control form-control-lg" id="yourName"
                                required>
                        </div>
                        <!-- Email -->
                        <div class="mb-4 bg-light-input">
                            <label for="emailInput" class="form-label">Email address *</label>
                            <input type="email" name="email" class="form-control form-control-lg" id="emailInput"
                                required>
                        </div>
                        <!-- Message -->
                        <div class="mb-4 bg-light-input">
                            <label for="textareaBox" class="form-label">Message *</label>
                            <textarea class="form-control" name="message" id="textareaBox" rows="4" required></textarea>
                        </div>
                        <!-- reCAPTCHA -->
                        <div class="mb-4">
                            {!! NoCaptcha::display() !!}
                        </div>
                        <!-- Button -->
                        <div class="d-grid">
                            <button class="btn btn-lg btn-primary mb-0" type="submit">Send Message</button>
                        </div>
                    </form>
                </div>

                <!-- Contact form END -->
            </div>
        </div>
    </section>
    <!-- =======================
        Image and contact form END -->

    <!-- =======================
        Map START -->
    {{-- <section class="pt-0">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <iframe class="w-100 h-400px grayscale rounded" src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3022.9663095343008!2d-74.00425878428698!3d40.74076684379132!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x89c259bf5c1654f3%3A0xc80f9cfce5383d5d!2sGoogle!5e0!3m2!1sen!2sin!4v1586000412513!5m2!1sen!2sin" height="500" style="border:0;" aria-hidden="false" tabindex="0"></iframe>
                </div>
            </div>
        </div>
    </section> --}}
    <!-- =======================
        Map END -->
@endsection
