@extends('frontend.master')
@section('title')
    Checkout
@endsection

@section('meta')
    <meta name="title" content="Freelancing-Career in Bangladesh: From Learning to Earning">
    <meta name="description" content="Start your freelancing career with expert-led courses on in-demand skills and live projects. Get certified and have a chance to join our agency!">
    <meta name="keywords" content="freelancing career courses in Bangladesh">
    
    <meta name="og:title" content="Freelancing-Career in Bangladesh: From Learning to Earning">
    <meta name="og:image" content="{{asset('frontend-assets')}}/images/meta_image.png">
@endsection

@push('css')
    <style>
        .batch-card {
            cursor: pointer;
            border: 1px solid #ccc;
            transition: border 0.2s ease-in-out;
        }

        .batch-card.selected {
            border-color: #007bff;
            background-color: #f0f8ff;
        }
    </style>
@endpush
@section('content')
    @if ($errors->any())
        <div class="alert alert-danger">
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif
    {{-- <form action="{{ route('student.course.enroll') }}" method="POST"> --}}
    <form action="{{ route('student.course.pay') }}" method="POST">
        @csrf
        <input type="hidden" value="{{ $item->id }}" name="course_id">
        <input type="hidden" value="{{ $item->course_type }}" id="courseTypeHidden">

        <div class="container">
            <div class="row my-5">
                <div class="col-lg-8 ">
                    <!-- Course Details -->
                    <div class="card my-3 border rounded shadow-sm">
                        <div class="card-body mx-3 my-3">
                            <div class="d-flex mb-4">
                                <img class="img-fluid me-3 rounded" style="width: 120px; height: auto;"
                                    src="{{ asset($item->image) }}" alt="Course Image">
                                <div>
                                    <h4><a href="{{ route('course.details', $item->slug) }}">{{ $item->course_name }}</a></h4>
                                    <p>@if($item->course_type == 'online') Online Course @elseif($item->course_type == 'offline') Offline Course @endif</p>
                                </div>
                            </div>
                            <div class="row">
                                @if ($item->course_type != 'online')
                                    <div class="col-sm-6 @if($item->course_type == 'offline') d-none @endif">
                                        <div class="form-group mb-3">
                                            <label for="courseTypeSelect" class="form-control-label">Course Type <span
                                                    class="text-danger">*</span></label>
                                            <select id="courseTypeSelect" name="course_type" class="form-control" required>
                                                <option value="">Select</option>
                                                @if($item->course_type != 'offline')
                                                    <option value="online">Online</option>
                                                @endif
                                                <option value="offline" @if($item->course_type == 'offline') selected @endif>Offline</option>
                                            </select>
                                        </div>
                                    </div>
                                @endif

                                @if($item->course_type != 'online')
                                <div id="branchDiv" class="col-sm-6 @if($item->course_type != 'offline') d-none @endif">
                                    <div class="form-group mb-3">
                                        <label for="branchSelect" class="form-control-label">Branch <span
                                                class="text-danger">*</span></label>
                                        <select name="branch_id" id="branchSelect" class="form-control">
                                            <option value="">Select Branch</option>
                                            @foreach ($branches as $branch)
                                                <option value="{{ $branch->id }}">{{ $branch->branch_name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                @endif

                                
                                <div id="batchDiv" class="col-md-12 @if($item->course_type != 'online') d-none @endif">
                                    <label for="courseTypeSelect" class="form-control-label">Select Batch <span
                                                    class="text-danger">*</span></label>
                                    <div class="row" id="batchContainer">
                                        @if($item->course_type == 'online')
                                            {{-- @foreach($batches as $key => $batch)
                                                <div class="col-md-4 col-sm-12 mb-3">
                                                    <div class="card batch-card" data-batch-id="{{ $batch->id }}">
                                                        <div class="card-body text-center" style="padding-bottom: 0px;">
                                                            <h6>{{ $batch->batch_name }}</h6>
                                                            <p>{{ $batch->branch->branch_name }}</p>
                                                            <input type="hidden" class="batch_value" value="{{ $batch->id }}">
                                                        </div>
                                                    </div>
                                                </div>
                                            @endforeach --}}
                                            @foreach($batches as $key => $batch)
                                                <div class="col-md-4 col-sm-12 mb-3">
                                                    <div class="w-100">
                                                        <input class="form-check-input d-none" type="radio" name="batch" id="course_batch" value="{{ $batch->id }}">
                                                        <label class="w-100" for="course_batch">
                                                            <div class="card batch-card" data-batch-id="{{ $batch->id }}">
                                                                <div class="card-body text-left p-3">
                                                                    <h6>{{ $batch->batch_name }}</h6>
                                                                    <p>{{ $batch->branch->branch_name }} Branch</p>
                                                                    <span style="font-size: 12px">{{ $batch->time }}</span><br>
                                                                    <span style="font-size: 10px">
                                                                        @php
                                                                            $days = json_decode(
                                                                                $batch->days,
                                                                            );
                                                                            $week_days = [
                                                                                'Saturday',
                                                                                'Sunday',
                                                                                'Monday',
                                                                                'Tuesday',
                                                                                'Wednesday',
                                                                                'Thursday',
                                                                                'Friday',
                                                                            ];
                                                                        @endphp
                                                                        @foreach ($days as $key5 => $day)
                                                                            {{ $week_days[$day - 1] }}@if($key5 + 1 < count($days)), @endif
                                                                        @endforeach
                                                                    </span>
                                                                </div>
                                                            </div>
                                                        </label>
                                                    </div>
                                                </div>
                                            @endforeach
                                        @endif
                                    </div>
                                </div>
                            </div>
                            {{-- ============ Coupon Section ============ --}}
                            <div class="d-flex justify-content-between mb-2 mt-3">
                                <p class="mb-0">Coupon</p>
                                <div>
                                    <div class="input-group">
                                        <input type="text" class="form-control" style="width: 130px" id="promoCode"
                                            value="{{session('coupon') != null ? session('coupon')['coupon_code']:'' }}" name="coupon_code"
                                            placeholder="Promo Code">
                                        <input type="hidden" value="{{ $item->id }}" name="course_id">
                                        <button type="button" id="{{ session('coupon') == null ? 'applyCoupon' :'removeCoupon' }}"
                                            class="btn btn-primary border-1 border-white">
                                            <i class="fa fa-{{ session('coupon') != null &&  session('coupon')['coupon_code'] != null ? 'x' : 'check-circle' }}"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                            {{-- <div class="d-flex justify-content-between mb-2">
                                <p class="mb-0">Coupon</p>
                                <div class="input-group">
                                    <input type="text" class="form-control" style="width: 100px" id="promoCode" value="{{ session()->get('coupon_code') }}" name="coupon_code" placeholder="Promo Code">
                                    <input type="hidden" value="{{ $item->id }}" name="course_id">
                                    <button type="button" id="applyCoupon" class="btn btn-primary border-1 border-white">
                                        <i class="fa fa-{{ session()->get('coupon_code') != null ? 'X':'check-circle' }}"></i>
                                    </button>
                                </div>
                            </div> --}}
                            {{-- ========= End Coupon Section ========= --}}
                            <h6>Payment Details</h6>
                            <div class="d-flex justify-content-between mb-2">
                                <p class="mb-0">Course Price</p>
                                <p class="mb-0">৳ {{ $item->course_fee }}</p>
                            </div>
                            <div class="d-flex justify-content-between mb-2">
                                <p class="mb-0">Discount</p>
                                @if (session('coupon') != null && session('coupon')['discount_type'] == 1)
                                    <input type="hidden" value="{{ session('coupon')['discount'] }}" name="discount">
                                    <p class="mb-0">- ৳ {{ session('coupon')['discount'] }}</p>
                                    @php
                                        $discount = session('coupon')['discount'];
                                    @endphp
                                @elseif(session('coupon') != null && session('coupon')['discount_type'] == 0)
                                    <input type="hidden"
                                        value="{{ ($item->course_fee * session('coupon')['discount']) / 100 }}"
                                        name="discount">
                                    <p class="mb-0">- ৳
                                        {{ ($item->course_fee * session('coupon')['discount']) / 100 }}</p>
                                    @php
                                        $discount = ($item->course_fee * session('coupon')['discount']) / 100;
                                    @endphp
                                @else
                                    <p class="mb-0">- ৳ {{ $item->discount }}</p>
                                    <input type="hidden" value="{{ $item->discount }}" name="discount">
                                    @php
                                        $discount = $item->discount;
                                    @endphp
                                @endif
                            </div>
                            <hr>
                            <div class="d-flex justify-content-between">
                                <h5>Total Payment:</h5>
                                <h5>৳ {{ $item->course_fee - $discount }}</h5>
                                <input type="hidden" value="{{ $item->course_fee }}" name="total_fee">
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Payment Methods -->
                <div class="col-lg-4">
                    <div class="card border card my-3">
                        <div class="card-body">
                            <h5 class="text-center">Payment Methods</h5>
                            <div class="form-check mb-3 d-flex align-items-center">
                                <input class="form-check-input" type="radio" name="payment_method" value="bkash"
                                    id="bKash" checked>
                                <label class="form-check-label d-flex align-items-center p-2 border rounded ms-2"
                                    for="bKash" style="width: 90%">
                                    <img src="https://cdn.ostad.app/public/gateway/bkash-payment.png" alt="bKash"
                                        class="img-fluid me-3" style="height: 30px;">
                                    bKash
                                </label>
                            </div>
                            <div class="form-check mb-3 d-flex align-items-center d-none">
                                <input class="form-check-input" type="radio" name="payment_method" value="nagad"
                                    id="nagad">
                                <label class="form-check-label d-flex align-items-center p-2 border rounded ms-2"
                                    for="nagad" style="width: 90%">
                                    <img src="https://cdn.ostad.app/public/upload/2024-04-23T05-07-00.461Z-nagad.png"
                                        alt="Nagad" class="img-fluid me-3" style="height: 30px;">
                                    Nagad
                                </label>
                            </div>
                            <button class="btn btn-primary form-control border">Pay & Confirm</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
@endsection
@push('js')
    <script>
        $('#removeCoupon').on('click', function() {
            // Get the promo code and course id
            alert('ok')
            let promoCode = $('#promoCode').val();
            let courseId = "{{ $item->id }}";

            // Create form data
            let formData = new FormData();
            formData.append('coupon_code', promoCode);
            formData.append('course_id', courseId);

            $.ajax({
                url: "{{ route('coupon.remove') }}",
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                success: function(data) {
                    // Handle the response
                    console.log(data);

                        // alert('Coupon applied/removed successfully');
                        location.reload(); // Reload to reflect the coupon application

                }
            });
        });
        $('#applyCoupon').on('click', function() {
            // Get the promo code and course id
            alert('ok')
            let promoCode = $('#promoCode').val();
            let courseId = "{{ $item->id }}";

            // Create form data
            let formData = new FormData();
            formData.append('coupon_code', promoCode);
            formData.append('course_id', courseId);

            $.ajax({
                url: "{{ route('coupon.apply.ajax') }}",
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                success: function(data) {
                    // Handle the response
                    console.log(data);

                        // alert('Coupon applied/removed successfully');
                        location.reload(); // Reload to reflect the coupon application

                }
            });
        });


        $(document).ready(function() {
            
            $('.batch-card').on('click', function() {
                $('.batch-card').removeClass('selected');
                $(this).addClass('selected');
            });

            $('#courseTypeSelect').change(function() {
                var courseType = $(this).val();
                $('#batchContainer').empty();
                
                $('#branchDiv').removeClass('d-none');
                $('#branchDiv').addClass('d-none');
                
                $('#batchDiv').removeClass('d-none');
                $('#batchDiv').addClass('d-none');
                
                $('#branchSelect').val('');

                if(courseType == 'online'){
                    handleCourseTypeDisplay(courseType);
                    loadBatches(0, courseType);
                }else if(courseType == 'offline'){
                    $('#branchDiv').removeClass('d-none');
                }
            });

            $('#branchSelect').change(function() {
                var branch_id = $(this).val();
                var courseType = $('#courseTypeSelect').val();
                
                $('#batchContainer').empty();
                $('#batchDiv').removeClass('d-none');
                $('#batchDiv').addClass('d-none');

                if (branch_id) {
                    loadBatches(branch_id, courseType);
                } else {
                    $('#batchCardContainer').empty().append('<p>Select a branch to see batches.</p>');
                }
            });

            function handleCourseTypeDisplay(courseType) {
                //var course_id = $('input[name="course_id"]').val();

                // if (courseType === 'online') {
                //     $('#courseTypeDiv').hide();
                //     $('#branchDiv').hide();
                //     $('#batchDivSelect').hide();
                //     $('#batchDiv').show();
                //     loadBatches(null, course_id);
                // } else if (courseType === 'offline') {
                //     $('#courseTypeDiv').hide();
                //     $('#branchDiv').show();
                //     $('#batchDiv').show();
                //     $('#batchDivSelect').hide();
                //     $('#batchCardContainer').empty().append('<p>Select a branch to see batches.</p>');
                // } else if (courseType === 'online and offline') {
                //     $('#courseTypeDiv').hide();
                //     $('#branchDiv').show();
                //     $('#batchDiv').hide();
                //     $('#batchDivSelect').show();
                //     $('#batchSelect').empty().append('<option value="">Select Batch</option>');
                // }
            }

            function loadBatches(branch_id, courseType) {
                var spinner =   `<div class="spinner-grow" role="status">
                                    <span class="visually-hidden">Loading...</span>
                                </div>`;
                $('#batchContainer').html(spinner);
                if(courseType == 'online'){
                    courseType = 1;
                }else if(courseType == 'offline'){
                    courseType = 2;
                }
                var course_id = $('input[name="course_id"]').val();
                
                //Array of week days
                var weekDays = [
                    'Saturday',  // 1
                    'Sunday',    // 2
                    'Monday',    // 3
                    'Tuesday',   // 4
                    'Wednesday', // 5
                    'Thursday',  // 6
                    'Friday'     // 7
                ];

                $.ajax({
                    url: '/get-batches/' + branch_id + '/' + course_id+ '/' + courseType,
                    type: 'GET',
                    success: function(batches) {
                        console.log(batches);
                        $('#batchContainer').empty();
                        if (batches.length === 0) {
                            $('#batchContainer').append('<p>No Batch Found</p>');
                        } else {
                            $.each(batches, function(key, batch) {
                                // Result days from ajax
                                let result = batch.days;
                                try {
                                    result = JSON.parse(result); // Parse if it's a JSON string
                                } catch(e) {
                                    console.error("Invalid JSON format");
                                }
                                
                                // Convert the result to week day names
                                const selectedDays = result.map(day => weekDays[day - 1]);
                                
                                // Join the selected days into a comma-separated string
                                const daysString = selectedDays.join(', ');

                                var cardHtml = `<div class="col-md-4 col-sm-12 mb-3">
                                                    <div class="w-100">
                                                        <input class="form-check-input d-none" type="radio" name="batch" id="course_batch" value="${batch.id}">
                                                        <label class="w-100" for="course_batch">
                                                            <div class="card batch-card" data-batch-id="${batch.id}">
                                                                <div class="card-body text-left p-3">
                                                                <h6>${batch.batch_name}</h6>`;
                                if(courseType == 1){                           
                                    cardHtml +=                     `<p>${batch.branch.branch_name} Branch</p>`;
                                }
                                                                    
                                    cardHtml +=                     `<span style="font-size: 12px">${batch.time}</span><br>
                                                                    <span style="font-size: 10px">${daysString}</span>
                                                                </div>
                                                            </div>
                                                        </label>
                                                    </div>
                                                </div>`;
                                    console.log(batch.days);
                                                
                                $('#batchContainer').append(cardHtml);
                            });
                            
                            $('.batch-card').on('click', function() {
                                $('.batch-card').removeClass('selected');
                                $(this).addClass('selected');
                            });
                        }
                        
                        $('#batchDiv').removeClass('d-none');
                    },
                    error: function() {
                        alert('Failed to load batches. Please try again.');
                    }
                });
            }

            $('form').on('submit', function(event) {
                if (!$('input[name="batch"]:checked').length) {
                    alert('Please select a batch before submitting.');
                    event.preventDefault();
                }
            });
        });
    </script>
@endpush
