<!DOCTYPE html>
<html lang="en">

<head>
    <title>{{ getSettings('site_name' ?? '') }} | @yield('title')</title>

    <!-- Meta Tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="author" content="Sky Dream IT">
    
    @yield('meta')
    
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/magnific-popup.js/1.1.0/magnific-popup.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">



    <!-- Favicon -->

    <link rel="shortcut icon" href="{{ asset(getSettings('site_icon')) }}">

    <!-- Google Font -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600&display=swap">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">



    @include('frontend.include.style')
    <style>
        .custom-nav-container {
            position: fixed;
            bottom: 0;
            width: 100%;
            /*padding: 12px;*/
            max-width: 100%;
            margin: 0 auto;
            left: 0;
            right: 0;
            z-index: 9999;

        }

        .custom-nav-box {
            display: flex;
            padding: 10px 0px;
            background-color: #fff;
            box-shadow: 0px 0px 16px 0px #4444;
            border-radius: 20px;
            border-bottom-left-radius: 0px;
            border-bottom-right-radius: 0px;
            margin-right: -5px;
            margin-left: -5px;
        }

        .custom-nav-list {
            display: flex;
            width: 100%;
            list-style: none;
            justify-content: space-around;
            padding-left: 0px;
        }

        .custom-nav-item {
            display: flex;
            position: relative;
            padding: 2px;
        }

        .custom-nav-item.active .custom-nav-icon {
            margin-top: -26px;
            box-shadow: 0px 0px 16px 0px #4444;
        }

        .custom-nav-item.active .custom-nav-text {
            transform: scale(1);
        }

        .custom-nav-link {
            display: flex;
            flex-direction: column;
            align-items: center;
            color: #515159;
            text-decoration: none;
        }

        .custom-nav-icon {
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.3em;
            background-color: #fff;
            /*border-radius: 50%;*/
            height: 20px;
            width: 20px;
            transition: margin-top 250ms ease-in-out, box-shadow 250ms ease-in-out;
        }

        .custom-nav-text {
            position: absolute;
            bottom: 0;
            transform: scale(0);
            transition: transform 250ms ease-in-out;
            font-size: 12px;
        }
        
        .side-menu .custom-nav-text {
            transform: none;
            top: 25px;
        }
        
        .custom-nav-list ul {
            margin-bottom: 0;
        }
        
        .sticky-contact-btn {
          cursor: pointer;
          position: fixed !important;
          bottom: 40px;
          right: 30px;
          display: block;
          z-index: 99;
          visibility: visible;
          opacity: 100;
          -webkit-transform: translateY(50%);
                  transform: translateY(50%);
          -webkit-transition: all 0.3s ease-in-out;
          transition: all 0.3s ease-in-out;
          background: none !important;
          color: white;
          border-radius: 10%;
          width: 52px;
          height: 52px;
          line-height: 52px;
          text-align: center;
        }
        .sticky-contact-btn i {
          font-size: 1.6rem;
          vertical-align: middle;
        }
        .sticky-contact-btn:hover {
          /*background:#EB343C;*/
          color: white;
        }
        .sticky-contact-btn.back-top-show {
          visibility: visible;
          opacity: 1;
          -webkit-transform: translateY(0%);
                  transform: translateY(0%);
        }
        
        .back-top {
            width: 42px;
            height: 42px;
            line-height: 42px;
            bottom: 90px !important;
        }
        
        @media (max-width: 767.98px) {
          
          .sticky-contact-btn {
            display: none;
            bottom: 90px;
            right: 10px;
            width: 40px;
            height: 40px;
            line-height: 30px;
          }
          .sticky-contact-btn i {
            font-size: 1rem;
          }
          
            .back-top {
                width: 30px;
                height: 30px;
                line-height: 30px;
                bottom: 120px !important;
            }
        }
        
        .navbar-toggler .navbar-toggler-animation {
            height: 18px;
            width: 18px;
        }
        
        @media (min-width: 300px) {
          header.navbar-sticky-on {
            position: fixed;
            z-index: 1020;
            top: 0;
            left: 0;
            right: 0;
            background-color: var(--bs-body-bg);
            -webkit-animation: fadeInDown 0.5s;
                    animation: fadeInDown 0.5s;
            width: 100%;
            border-bottom: 1px solid var(--bs-gray-300);
          }
          header.navbar-sticky-on .navbar-top {
            display: none !important;
          }
          header.navbar-sticky-on .navbar-brand {
            padding: 5px 0;
          }
          
        }
        
        @media (max-width: 667px) {
            header.navbar-sticky-on .navbar-brand .navbar-brand-item {
                height: 25px;
            }
            
            .account-btn {
                margin-right: -40%;
            }
            
            .signin-btn {
                margin-right: -20%;
            }
            
            .account-btn .avatar-sm {
                height: 30px;
                width: 30px;
            }
        }
    </style>
    @stack('css')
</head>

<body>

    @include('frontend.include.header')

    <!-- **************** MAIN CONTENT START **************** -->
    <main>
        @yield('content')
        <div class="modal fade" id="promoCodeModal" tabindex="-1" aria-labelledby="promoCodeModalLabel"
            aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="promoCodeModalLabel">Enter Promo Code</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <form action="{{ route('coupon.apply') }}" method="POST">
                            @csrf
                            <div class="mb-3">
                                <label for="promoCode" class="form-label">Promo Code</label>
                                <input type="text" class="form-control" id="promoCode" name="coupon_code"
                                    placeholder="Enter your promo code">
                            </div>
                            <button type="submit" class="btn btn-primary">Apply</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <div class="modal fade" id="webinarModal" tabindex="-1" aria-labelledby="webinarModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="registerModalLabel">Register for Free Webinar</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form action="{{ route('webinar.booking.submit') }}" method="post">
                        <div class="modal-body">

                            @csrf
                            <input type="hidden" name="webinar_id" value="{{ $webinar->id ?? '' }}">
                            <div class="mb-3">
                                <label for="name" class="form-label">Name <span class="text-danger">*</span></label>
                                <input type="text" class="form-control @error('name') is-invalid @enderror"
                                    name="name" id="name" placeholder="Name"
                                    value="{{ Auth::check() && Auth::user()->role == 3 ? Auth::user()->name : old('name') }}"
                                    required>
                                @error('name')
                                    <div class="invalid-feedback" role="alert">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="mb-3">
                                <label for="phone" class="form-label">Phone</label>
                                <input type="tel" name="phone"
                                    class="form-control @error('phone') is-invalid @enderror" id="phone"
                                    placeholder="Phone"
                                    value="{{ Auth::check() != null && Auth::user()->role == 3 ? Auth::user()->student->student_phone : old('phone') }}"
                                    required>
                                @error('phone')
                                    <div class="invalid-feedback" role="alert">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="mb-3">
                                <label for="email" class="form-label">Email</label>
                                <input type="email" name="email"
                                    class="form-control @error('email') is-invalid @enderror" id="email"
                                    placeholder="Email"
                                    value="{{ Auth::check() != null && Auth::user()->role == 3 ? Auth::user()->email : old('email') }}"
                                    required>
                                @error('email')
                                    <div class="invalid-feedback" role="alert">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="mb-3">
                                <label for="address" class="form-label">Address</label>
                                <textarea type="text" name="address" class="form-control @error('address') is-invalid @enderror" id="address"
                                    placeholder="Address" required>{{ old('address') }}</textarea>
                                @error('address')
                                    <div class="invalid-feedback" role="alert">{{ $message }}</div>
                                @enderror
                            </div>

                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-primary">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </main>
    {!! NoCaptcha::renderJs() !!}

    <!-- **************** MAIN CONTENT END **************** -->

    @include('frontend.include.footer')


    <!-- Back to top -->
    <div class="back-top d-lg-block d-none"><i
            class="bi bi-arrow-up-short position-absolute top-50 start-50 translate-middle"></i>
    </div>
    <div class="sticky-contact-btn d-lg-block">
        <a href="https://wa.me/{{ str_replace('-', '', getSettings('whatsapp_number')) }}"><img src="{{asset('frontend-assets')}}/images/whatsapp_icon.png"></a>
    </div>
    <!-- Bootstrap JS -->
    @include('frontend.include.script')
    <script>
        $(document).ready(function() {
            $('.image-popup').magnificPopup({
                type: 'image',
                gallery: {
                    enabled: true
                },
                mainClass: 'mfp-fade',
                removalDelay: 300,
                closeBtnInside: true,
                closeMarkup: '<button title="%title%" type="button" class="mfp-close">&#215;</button>',
                closeOnContentClick: true,
                closeOnBgClick: true
            });
        });
    </script>




    @stack('js')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <script>
        toastr.options = {
            "closeButton": true,
            "progressBar": true,
            "positionClass": "toast-top-right",
            "timeOut": "3000",
            "extendedTimeOut": "1000",
            "showEasing": "swing",
            "hideEasing": "linear",
            "showMethod": "fadeIn",
            "hideMethod": "fadeOut"
        };
    </script>




</body>

</html>
