@extends('frontend.master')
@section('title')
Student Sign Up
@endsection
@section('content')
<section class="p-0 d-flex align-items-center position-relative overflow-hidden">

    <div class="container-fluid">
        <div class="row">
            <!-- left -->
            <div class="signup-banner col-12 col-lg-6 d-md-flex align-items-center justify-content-center bg-primary bg-opacity-10 d-none d-md-block">
                <div class="p-3 p-lg-5">
                    <!-- Title -->
                    <div class="text-center">
                        <h2 class="fw-bold">Welcome To Our Largest Community</h2>
                        <p class="mb-0 h6 fw-light">Let's learn something new today!</p>
                    </div>
                    <!-- SVG Image -->
                    <img src="fonts/02.svg" class="mt-5" alt="">
                    <!-- Info -->
                    <div class="d-sm-flex mt-5 align-items-center justify-content-center">
                        <!-- Avatar group -->
                        <ul class="avatar-group mb-2 mb-sm-0">
                            <li class="avatar avatar-sm">
                                <img class="avatar-img rounded-circle" src="{{asset('frontend-assets')}}/images/01.jpg" alt="avatar">
                            </li>
                            <li class="avatar avatar-sm">
                                <img class="avatar-img rounded-circle" src="{{asset('frontend-assets')}}/images/02_1.jpg" alt="avatar">
                            </li>
                            <li class="avatar avatar-sm">
                                <img class="avatar-img rounded-circle" src="{{asset('frontend-assets')}}/images/03.jpg" alt="avatar">
                            </li>
                            <li class="avatar avatar-sm">
                                <img class="avatar-img rounded-circle" src="{{asset('frontend-assets')}}/images/04.jpg" alt="avatar">
                            </li>
                        </ul>
                        <!-- Content -->
                        <p class="mb-0 h6 fw-light ms-0 ms-sm-3">500+ Students joined us, now it's your turn.</p>
                    </div>
                </div>
            </div>

            <!-- Right -->
            <div class="col-12 col-lg-6 m-auto">
                <h4 class="text-center text-success">{{session('message')}}</h4>
                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
                <div class="row my-5">
                    <div class="col-sm-10 col-xl-8 m-auto">
                        <!-- Title -->
                        <img src="fonts/03.svg" class="h-40px mb-2" alt="">
                        <h2>Sign Up For Your Account!</h2>
                        <p class="lead mb-4">Nice to see you! Please Sign up with your account.</p>

                        <!-- Form START -->
                        <form action="{{ route('student.sign-up.submit') }}" method="POST" enctype="multipart/form-data">
                            <input type="hidden" name="student_status_id" value="0">
                            @csrf
                            <!-- Email -->
                            <div class="mb-4">
                                <label for="name" class="form-label">Name *</label>
                                <div class="input-group input-group-lg">
                                    <span class="input-group-text bg-light rounded-start border-0 text-secondary px-3"><i class="bi bi-person-fill"></i></span>
                                    <input type="text" name="student_name" class="form-control border-0 bg-light rounded-end ps-1
                                    @error('student_name') is-invalid @enderror" placeholder="Name" id="name" value="{{ old('student_name') }}" required>

                                </div>
                                @error('student_name')
                                        <div class="invalida-feedback" role="alert">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="mb-4">
                                <label for="exampleInputEmail1" class="form-label">Phone *</label>
                                <div class="input-group input-group-lg">
                                    <span class="input-group-text bg-light rounded-start border-0 text-secondary px-3"><i class="bi bi-phone-fill"></i></span>
                                    <input type="text" name="student_phone" class="form-control border-0 bg-light rounded-end ps-1
                                    @error('student_phone') is-invalid @enderror" placeholder="Phone" id="phone" value="{{ old('student_phone') }}" required>

                                </div>
                                @error('student_phone')
                                        <div class="invalid-feedback" role="alert">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="mb-4">
                                <label for="exampleInputEmail1" class="form-label">Email Address *</label>
                                <div class="input-group input-group-lg">
                                    <span class="input-group-text bg-light rounded-start border-0 text-secondary px-3"><i class="bi bi-envelope-fill"></i></span>
                                    <input type="email" name="student_email" class="form-control border-0 bg-light rounded-end ps-1
                                    @error('student_email')
                                        is-invalid
                                    @enderror" placeholder="E-mail" id="exampleInputEmail1" value="{{ old('student_email') }}" required>

                                </div>
                                @error('student_email')
                                        <div class="invalid-feedback" role="alert">{{ $message }}</div>
                                @enderror
                            </div>
{{--                            <div class="mb-4">--}}
{{--                                <label for="image" class="form-label">Image *</label>--}}
{{--                                <div class="input-group input-group-lg">--}}
{{--                                    <span class="input-group-text bg-light rounded-start border-0 text-secondary px-3"><i class="bi bi-file-image"></i></span>--}}
{{--                                    <input type="file" name="student_image" accept="image/*" class="form-control border-0 bg-light rounded-end ps-1--}}
{{--                                    @error('student_image')--}}
{{--                                        is-invalid--}}
{{--                                    @enderror" placeholder="Image" id="image" >--}}
{{--                                    @error('student_image')--}}
{{--                                        <div class="invalid-feedback" role="alert">{{ $message }}</div>--}}
{{--                                    @enderror--}}
{{--                                </div>--}}
{{--                            </div>--}}
                            <!-- Password -->
                            <div class="mb-4">
                                <label for="inputPassword5" class="form-label">Password *</label>
                                <div class="input-group input-group-lg">
                                    <span class="input-group-text bg-light rounded-start border-0 text-secondary px-3"><i class="fas fa-lock"></i></span>
                                    <input type="password" name="password" class="form-control border-0 bg-light rounded-end ps-1" placeholder="*********" id="inputPassword5" required>

                                </div>
                                @error('password')
                                        <div class="invalida-feedback" role="alert">{{ $message }}</div>
                                @enderror
                            </div>
                            <!-- Confirm Password -->
                            <div class="mb-4">
                                <label for="inputPassword6" class="form-label">Confirm Password *</label>
                                <div class="input-group input-group-lg">
                                    <span class="input-group-text bg-light rounded-start border-0 text-secondary px-3"><i class="fas fa-lock"></i></span>
                                    <input type="password" name="password_confirmation" class="form-control border-0 bg-light rounded-end ps-1" placeholder="*********" id="inputPassword6" required>

                                </div>
                                @error('password')
                                        <div class="invalida-feedback" role="alert">{{ $message }}</div>
                                @enderror
                            </div>
                            <!-- Check box -->
                            <div class="mb-4">
                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input" id="checkbox-1" required>
                                    <label class="form-check-label" for="checkbox-1">By signing up, you agree to our <a href="{{route('terms-conditions')}}">terms & conditions</a></label>
                                </div>
                            </div>
                            <!-- Button -->
                            <div class="align-items-center mt-0">
                                <div class="d-grid">
                                    <button class="btn btn-primary mb-0" type="submit">Sign Up</button>
                                </div>
                            </div>
                        </form>
                        <!-- Form END -->



                        <!-- Sign up link -->
                        <div class="mt-4 text-center">
                            <span>Already have an account?<a href="{{ route('student.sign-in') }}"> Sign In Here</a></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection
