@extends('admin.master')
@section('title')
    Webinar List
@endsection
@section('content')
{{--    @php $route = Route::currentRouteName(); @endphp--}}
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="text-center text-success">{{session('message')}}</h4>
                    <div class="d-flex justify-content-between">
                        <h3 class="text-center"><strong>View Webinars</strong></h3>
{{--                       @if(count($items) > 0 && $route == 'teacher.schedule.list')--}}
{{--                            <a href="{{route('admin.schedule.edit', $items->first()->batch_id)}}" class=" ms-3 btn btn-success"  title="Edit Class Schedule"><i class="fa fa-pencil"> Edit Schedule</i></a>--}}
{{--                        @endif--}}
                    </div>


                </div>
                <div class="card-body table-responsive">
                    <table class="table table-striped">
                        <tr>
                            <th>#</th>
                            <th>Course</th>
                            <th>Webinar Name</th>
                            <th>Date</th>
                            <th>Time</th>
                            <th>Price</th>
{{--                            <th>Status</th>--}}
                            <th>Action</th>

                        </tr>
                        @php $i=1; @endphp
                        @foreach($items as $item)
                            <tr>
                                <td>{{$i++}}</td>
                                <td>{{$item->course->course_name ?? 'N/A'}}</td>
                                <td>{{$item->title}}</td>
                                <td width="150px">{{$item->date}}</td>
                                <td>{{$item->time}}</td>
                                <td>{{$item->price}} BDT </td>

                                <td class="btn-group">
                                    <a href="{{route('admin.webinar.edit', $item->id)}}" title="Edit" class="btn btn-primary"><i class="fa fa-pencil"></i></a>
                                    <form action="{{route('admin.webinar.remove')}}" onclick="return confirm('Please Confirm Before Deleting it!!')" method="post">
                                        @csrf
                                        <input type="hidden" name="id" value="{{$item->id}}">
                                        <button type="submit" title="Remove" class="btn btn-danger" style="margin: 0 5px"><i class="fa fa-trash"></i></button>
                                    </form>
                                    <a href="{{route('admin.webinar.message.send', $item->id)}}" class="btn btn-warning" title="Send Message"><i class="fa fa-envelope"></i></a>
                                </td>

                            </tr>
                        @endforeach

                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection
