@extends('admin.master')
@section('title')
    Webinar Registration List
@endsection
@section('content')
{{--    @php $route = Route::currentRouteName(); @endphp--}}
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="text-center text-success">{{session('message')}}</h4>
                    <div class="d-flex justify-content-between">
                        <h3 class="text-center"><strong>View Webinar Registered Members</strong></h3>
{{--                       @if(count($items) > 0 && $route == 'teacher.schedule.list')--}}
{{--                            <a href="{{route('admin.schedule.edit', $items->first()->batch_id)}}" class=" ms-3 btn btn-success"  title="Edit Class Schedule"><i class="fa fa-pencil"> Edit Schedule</i></a>--}}
{{--                        @endif--}}
                    </div>
                    <div class="row mt-3">
                        <div class="col-md-12">
                            <form action="" id="filterForm">
                                <div class="row">
                                    <div class="col-md-6 d-flex"><label for="" class="form-control-label my-auto mx-2">Course</label><select
                                            name="course_id" id="" class="form-control" onchange="filter()">
                                            <option value="" selected>All Courses</option>
                                            @foreach($courses as $course)
                                                <option value="{{$course->id}}" @isset($_GET['course_id']){{$_GET['course_id'] == $course->id ? 'selected':''}}@endisset>{{$course->course_name}}</option>
                                            @endforeach

                                        </select></div>
                                    <div class="col-md-6 d-flex"><label for="" class="form-control-label my-auto mx-2">Webinar</label><select
                                            name="webinar_id" id="" class="form-control" onchange="filter()">
                                            <option value="" selected>All Webinars</option>
                                            @isset($webinars)
                                                @foreach($webinars as $webinar)
                                                    <option value="{{$webinar->id}}" @isset($_GET['webinar_id']){{$_GET['webinar_id'] == $webinar->id ? 'selected':''}}@endisset>{{$webinar->title}}</option>
                                                @endforeach
                                            @endisset
                                        </select></div>
                                </div>
                            </form>
                        </div>
                    </div>


                </div>
                <div class="card-body table-responsive">
                    <table class="table table-striped">
                        <tr>
                            <th>#</th>
                            <th>Course</th>
                            <th>Webinar Name</th>
                            <th>Date</th>
{{--                            <th>Time</th>--}}
                            <th>Name</th>
                            <th>Email</th>
                            <th>Phone</th>
                            <th>Address</th>
{{--                            <th>Price</th>--}}
{{--                            <th>Status</th>--}}
{{--                            <th>Action</th>--}}

                        </tr>
                        @php $i=1; @endphp
                       @if(count($items) > 0)
                            @foreach($items as $item)
                                <tr>
                                    <td>{{$i++}}</td>
                                    <td>{{$item->course->course_name ?? 'N/A'}}</td>
                                    <td>{{$item->webinar->title ?? ''}}</td>
                                    <td>{{$item->webinar->date ?? ''}}</td>
                                    {{--                                <td>{{$item->webinar->time ?? ''}}</td>--}}
                                    <td>{{$item->name}}</td>
                                    <td>{{$item->email}}</td>
                                    <td>{{$item->phone}}</td>
                                    <td>{{$item->address}}</td>
                                    {{--                                <td>{{$item->price}} BDT </td>--}}


                                </tr>
                            @endforeach
                        @else
                           <td colspan="8" class="text-center text-danger"> No Member Registered</td>
                        @endif

                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection
