@extends('admin.master')
@section('title')
    Password Update
@endsection

@section('content')
    <div class="card">
        <div class="card-header text-center">
            <h4 class="text-center text-success">{{session('message')}}</h4>
            <h2><strong> Password Update</strong></h2>
        </div>
        <div class="card-body card-block">
            <form action="{{route('password.update')}}" method="post" enctype="multipart/form-data">
                @csrf
                <input type="hidden" name="id" value="{{Auth::user()->id}}">
                <div class="row mb-3">
                    <div class="col-md-12 card card-body">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group"><label for="vat" class=" form-control-label">Old Password
                                            <span class="text-danger">* [minimum 8 alphanumeric characters]</span></label>
                                        <div class="input-group">
                                            <input type="password" id="old_password" name="old_password"
                                                   class="form-control @error('old_password') is-invalid @enderror"
                                                   value="{{old('old_password')}}" required>
                                            <a class="btn btn-light input-group-addon" onclick="toggleOldPassword()"><i class="fa fa-eye"></i></a>
                                        </div>
                                        @error('old_password')
                                        <div class="invalid-feedback" role="alert">{{$message}}</div>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group"><label for="vat" class=" form-control-label">New Password
                                            <span class="text-danger">* [minimum 8 alphanumeric characters]</span></label>
                                        <div class="input-group">
                                            <input type="password" id="password" name="password"
                                                   class="form-control @error('password') is-invalid @enderror"
                                                   value="{{old('password')}}" required>
                                            <a class="btn btn-light input-group-addon" onclick="togglePassword()"><i class="fa fa-eye"></i></a>
                                        </div>
                                        @error('password')
                                        <div class="invalid-feedback" role="alert">{{$message}}</div>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group"><label for="vat" class=" form-control-label">Confirm Password
                                            <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <input type="password" id="password_confirmation" name="password_confirmation"
                                                   class="form-control @error('password') is-invalid @enderror"
                                                   value="{{old('password')}}" required >
                                            <a class="btn btn-light input-group-addon" onclick="toggleConfirmPassword()"><i class="fa fa-eye"></i></a>
                                        </div>
                                        @error('password')
                                        <div class="invalid-feedback" role="alert">{{$message}}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row mb-3">
                    <div class="form-group col-md-12">
                        <label for="" class="form-control-label"></label>
                        <button type="submit" class="btn btn-primary form-control">Update Profile </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
@push('script')
    <script src="https://cdn.jsdelivr.net/npm/jquery@3.5.0/dist/jquery.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>


<script>


    function toggleOldPassword(){
        var pass =document.getElementById('old_password');
        if(pass.type == 'password'){
            pass.type = 'text';
        }
        else {
            pass.type = 'password';
        }

    }
    function togglePassword(){
        var pass =document.getElementById('password');
        if(pass.type == 'password'){
            pass.type = 'text';
        }
        else {
            pass.type = 'password';
        }

    }
    function toggleConfirmPassword(){
        var pass_confirm =document.getElementById('password_confirmation');
        if(pass_confirm.type == 'password'){
            pass_confirm.type = 'text';
        }
        else {
            pass_confirm.type = 'password';
        }
    }
    $( '#select-field' ).select2( {
        theme: 'bootstrap-5'
    } );
    $( '#multiple-select-field' ).select2( {
        theme: "bootstrap-5",
        width: $( this ).data( 'width' ) ? $( this ).data( 'width' ) : $( this ).hasClass( 'w-100' ) ? '100%' : 'style',
        placeholder: $( this ).data( 'placeholder' ),
        closeOnSelect: false,
    } )


</script>

@endpush
