@php use App\Models\Course; @endphp
@extends('admin.master')
@section('title')
    Offer List
@endsection
@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">

                    <div class="row">
                        <div class="col-md-10">
                            <h4 class="text-center text-success">{{session('message')}}</h4>
                            <h3 class="text-center"><strong>View Offer List</strong></h3>
                        </div>
                        <div class="col-md-2">
                            <a href="{{route('admin.offer.add')}}" class="float-right btn btn-primary">Add Offer</a>
                        </div>
                    </div>


                </div>
                <div class="card-body">
                    <table class="table table-striped">
                        <tr>
                            <th>#</th>
                            <th>Title</th>
                            <th>Image</th>
                            <th>Date</th>
{{--                            <th>Courses</th>--}}
                            <th>Coupon Code</th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                        @php $i=1; @endphp
                        @foreach($items as $item)
                            <tr>
                                <td>{{$i++}}</td>
                                <td>{{$item->title}}</td>
                                <td><img src="{{asset($item->image)}}" alt="" height="100px" width="100px"></td>
                                <td>{{date('d M, y', strtotime($item->start_date))}} - <br> {{date('d M, y', strtotime($item->end_date))}}</td>
                                <td>{{$item->coupon->coupon_code ?? ''}}</td>
{{--                                <td>--}}
{{--                                    @php $offer_courses = json_decode($item->course_ids) @endphp--}}
{{--                                    @foreach($offer_courses as $key => $offer_course)--}}
{{--                                        @php $course = Course::find($offer_course) @endphp--}}
{{--                                        @if($key > 0), @endif{{$course->course_name}}--}}

{{--                                    @endforeach--}}
{{--                                </td>--}}
                                <td class="text-center">
                                    <div class="mb-2">
                                        <span class="{{$item->status == 1 ? 'bg-success':'bg-danger'}} p-2 text-white" style="border-radius:5px">
                                    {{$item->status == 1 ? 'Active':'Inactive'}}</span>
                                    </div>
                                    </td>

                                <td class="btn-group">
                                    <a href="{{route('admin.offer.edit', ['id'=>$item->id])}}" title="Edit" class="btn btn-primary"><i class="fa fa-pencil"></i></a>
                                    <form action="{{route('admin.offer.remove')}}" onclick="return confirm('Please Confirm Before Deleting it!!')" method="post">
                                        @csrf
                                        <input type="hidden" name="id" value="{{$item->id}}">
                                        <button type="submit" title="Remove" class="btn btn-danger" style="margin-left: 5px"><i class="fa fa-trash"></i></button>
                                    </form>

                                </td>
                            </tr>
                        @endforeach
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection
