@extends('admin.master')
@section('title')
    @isset($item)Edit @else Add @endisset Offers
@endsection
@push('css')
    <style>
        .select2-container--default .select2-selection--single {
            height: calc(2.25rem + 2px);
            color: #495057;
        }
    </style>
@endpush
@section('content')
    <div class="card">
        <div class="card-header text-center">
            <h2><strong> @isset($item)Edit @else Add @endisset Offer Form</strong></h2>
        </div>
        <div class="card-body card-block">
            <form action="@isset($item){{route('admin.offer.update')}}@else{{route('admin.offer.submit')}}@endisset" method="post" enctype="multipart/form-data">
                @csrf
                <input type="hidden" name="id" value="@isset($item){{$item->id}}@endisset">
                <input type="hidden" name="coupon_id" value="@isset($item){{$item->coupon_id}}@endisset">
                <div class="row mb-3">
                    <div class="form-group col-md-12"><label for="company" class=" form-control-label">Title
                            <span class="text-danger">*</span></label>
                        <input type="text" name="title" id="company" class="form-control @error('title') is-invalid @enderror"
                               value="@isset($item){{$item->title}}@else{{old('title')}}@endisset" required>
                        @error('title')
                        <div class="invalid-feedback" role="alert">{{$message}}</div>
                        @enderror
                    </div>
                </div>
                <div class="row mb-3">
                    <div class="form-group col-md-12"><label for="company" class=" form-control-label">Description
                            <span class="text-danger">*</span></label>
                        <textarea type="text" name="description" id="company"
                                  class="form-control summernote @error('description') is-invalid @enderror" required>@isset($item){{$item->description}}@else{{old('description')}}@endisset</textarea>
                        @error('title')
                        <div class="invalid-feedback" role="alert">{{$message}}</div>
                        @enderror
                    </div>
                </div>
                <div class="row mb-3">
                    <div class="form-group col-md-12"><label for="company" class=" form-control-label">Image
                            <span class="text-danger">*</span></label>
                        <input type="file" name="image" id="company" class="form-control @error('image') is-invalid @enderror" @isset($item) @else required @endisset>
                        @isset($item)
                            <img src="{{asset($item->image)}}" height="100px" width="100px" class="mt-2" alt="">
                        @endisset
                        @error('image')
                        <div class="invalid-feedback" role="alert">{{$message}}</div>
                        @enderror
                    </div>
                    <div class="col-md-6 mb-4">
                        <label for="expire_date" class="col-form-label" >Start Date <span class="text-danger">*</span></label>
                        <input class="form-control" id="expire_date" type="date" name="start_date" min="0" value="@isset($item){{$item->start_date}}@else{{old('start_date')}}@endisset" required>
                    </div>
                    <div class="col-md-6 mb-4">
                        <label for="expire_date" class="col-form-label" >End Date <span class="text-danger">*</span></label>
                        <input class="form-control" id="expire_date" type="date" name="end_date" min="0" value="@isset($item){{$item->end_date}}@else{{old('end_date')}}@endisset" required>
                    </div>

                </div>
                <div class="row mb-3">
                    <div class="col-md-12 mb-4">
                        @php if(isset($item)){
                            $offer_courses = json_decode($item->course_ids);
                        }
                        @endphp
                        <label for="coupon_code" class="col-form-label" >Course <span class="text-danger">*</span></label>
                        <select name="course_ids[]" id="" class="js-example-basic-multiple form-control" multiple="multiple" required>
                            <option value="0">All</option>
                            @foreach($courses as $course)
                                <option @isset($item){{in_array($course->id, $offer_courses) ? 'selected':''}}@endisset value="{{$course->id}}">{{$course->course_name}}</option>
                            @endforeach

                        </select>
                        @error('course_id')
                        <p class="text-danger">{{$message}}</p>
                        @enderror
                    </div>
                    <div class="col-md-4 mb-4">
                        <label for="coupon_code" class="col-form-label" >Coupon Code <span class="text-danger">*</span> <span class="text-danger">*</span></label>
                        <input class="form-control" id="coupon_code" type="text" value="@isset($item){{$coupon->coupon_code}}@else{{old('coupon_code')}}@endisset" name="coupon_code" placeholder="Write Coupon Code" required>
                        @error('coupon_code')
                        <p class="text-danger">{{$message}}</p>
                        @enderror
                    </div>

                    <div class="col-md-4 mb-4">
                        <label for="discount_type" class="col-form-label" >Discount Type <span class="text-danger">*</span></label>
                        <div class="custom_select">
                            <select class="form-control select-active w-100 form-select select-nice" name="discount_type" id="discount_type" >
                                <option value="1" @isset($item){{$coupon->discount_type == 1 ? 'selected':''}}@endisset>Fixed Amount</option>
                                <option value="0" @isset($item){{$coupon->discount_type == 0 ? 'selected':''}}@endisset>Percent %</option>
                            </select>
                        </div>
                    </div>

                    <div class="col-md-4 mb-4">
                        <label for="discount" class="col-form-label" >Discount Amount/Percent <span class="text-danger">*</span></label>
                        <input class="form-control" id="discount" type="number" name="discount" placeholder="Write discount amount/percent" min="0" value="@isset($item){{$coupon->discount}}@else{{old('discount')}}@endisset" required>
                    </div>

                    <div class="col-md-6 mb-4">
                          <label for="limit_per_user" class="col-form-label" >Use Limit Per User <span class="text-danger">*</span></label>
                        <input class="form-control" id="limit_per_user" type="number" name="limit_per_user" placeholder="Write use limit per user" min="0" value="@isset($item){{$coupon->limit_per_user}}@else{{old('limit_per_user')}}@endisset" required>
                        @error('limit_per_user')
                            <p class="text-danger">{{$message}}</p>
                        @enderror
                    </div>

                    <div class="col-md-6 mb-4">
                        <label for="total_use_limit" class="col-form-label" >Total Use Limit <span class="text-danger">*</span></label>
                        <input class="form-control" id="total_use_limit" type="number" name="total_use_limit" value="@isset($item){{$coupon->total_use_limit}}@else{{old('total_use_limit')}}@endisset" placeholder="Enter total use limit" required min="0">
                        @error('total_use_limit')
                        <p class="text-danger">{{$message}}</p>
                        @enderror
                    </div>


                    {{-- <div class="col-md-6 mb-4">
                         <label for="type" class="col-form-label" >Coupon For:</label>
                        <div class="custom_select">
                            <select class="form-control select-active w-100 form-select select-nice" name="type" id="type">
                                <option value="1">All Customer</option>
                                <option value="0">Specific Customer</option>
                            </select>
                        </div>
                    </div> --}}

                    {{-- <div class="col-md-6 mb-4">
                         <label for="user_id" class="col-form-label" >Customer: *</label>
                        <div class="custom_select cit-multi-select">
                            <select class="form-control select-active w-100 form-select select-nice" name="user_id[]" id="user_id" multiple="multiple" data-placeholder="User id" required>
                                @foreach($users as $user)
                                    <option value="{{ $user->id }}">{{ $user->name }}</option>
                                   @endforeach
                            </select>
                        </div>
                    </div> --}}
                    <div class="form-group col-md-12">
                        <label for="" class="form-control-label">Status</label>
                        <div class="form-check">
                            <input class="form-check-input" value="1" type="radio" name="status" id="flexRadioDefault1" checked>
                            <label class="form-check-label" for="flexRadioDefault1">
                                Active
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" value="0" type="radio" name="status" id="flexRadioDefault2" @isset($item){{$item->status == 0 ? 'checked':''}}@endisset>
                            <label class="form-check-label" for="flexRadioDefault2">
                                Inactive
                            </label>
                        </div>
                    </div>

                </div>

                <div class="row mb-3">
                    <div class="form-group col-md-12">
                        <label for="" class="form-control-label"></label>
                        <button type="submit" class="btn btn-primary form-control">@isset($item)Update @else Add @endisset Course Category</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
@push('script')
    <script>
        jQuery(document).ready(function(){
            var counter=0;

            jQuery('#addSubjectBtn').click(function(){
                counter ++;
                const inputField = jQuery('<input>').attr({
                    type:'text',
                    name: 'modules[]',
                    class: 'form-control mb-2',
                    placeholder: 'Enter Module Name'
                });

                jQuery('#subject-container').append(inputField);
            });
        });
    </script>
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.js"></script>
    <script>
        jQuery(document).ready(function() {
            jQuery('.summernote').summernote();
        });
    </script>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>

        jQuery(document).ready(function() {
            jQuery('.js-example-basic-multiple').select2();
        });
    </script>
@endpush

