@extends('admin.master')
@section('title')
    @isset($item)Edit @else Add @endisset Attendance
@endsection
@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3><strong>@isset($item)Edit @else Add @endisset Attendance</strong></h3>
                </div>
                <div class="card-body">
                    <form action="" id="filterForm">
                        <div class="row">
{{--                            <div class="col-md-4 form-group">--}}
{{--                                <label for="" class="form-control-label">Date</label>--}}
{{--                                <input type="date" name="date" id="exam_date" oninput="changeDate()" class="form-control" value="{{date('Y-m-d')}}">--}}
{{--                            </div>--}}
                            <div class="col-md-4 form-group">
                                <label for="" class="form-control-label">Course</label>
                                @php if(Auth::user()->role == 4) {$courses = assignedCourses();} @endphp
                                @if(Auth::user()->role == 4)
                                    <select name="course_id" id="course" class="form-control" >
                                        <option value="">Select Course</option>
                                        @foreach($courses as $course)
                                            <option value="{{$course->course_id}}" @isset($_GET['course_id']) {{$course->course_id == $_GET['course_id'] ? 'selected':''}} @endisset>{{$course->course->course_name}}</option>
                                        @endforeach
                                    </select>
                                @else
                                    <select name="course_id" id="course" class="form-control" >
                                        <option value="">Select Course</option>
                                        @foreach($courses as $course)
                                            <option value="{{$course->id}}" @isset($_GET['course_id']) {{$course->id == $_GET['course_id'] ? 'selected':''}} @endisset>{{$course->course_name}}</option>
                                        @endforeach
                                    </select>
                                @endif
                            </div>
                            <div class="col-md-4 form-group">
                                <label for="" class="form-control-label">Batch</label>
                                <select name="batch_id" id="batch_id" class="form-control" onchange="filter()">
                                    <option value="">Select Batch</option>
                                    @isset($batches)
                                        @if(count($batches) > 0)
                                            @foreach($batches as $batch)
                                                <option value="{{$batch->id}}" {{$_GET['batch_id'] == $batch->id ? 'selected':''}}>{{$batch->batch_name}}</option>
                                            @endforeach
                                        @endif
                                    @endisset
                                </select>
                            </div>
                            <div class="col-md-4 form-group">
                                <label for="" class="form-control-label">Schedule</label>
                                <select name="schedule_id" id="schedule_id" class="form-control">
                                    <option value="">Select Schedule</option>
                                    @isset($schedules)
                                        @if(count($schedules) > 0)
                                            @foreach($schedules as $schedule)
                                                <option value="{{$schedule->id}}" {{$_GET['schedule_id'] == $schedule->id ? 'selected':''}}>{{$schedule->date}}</option>
                                            @endforeach
                                        @endif
                                    @endisset
                                </select>
                            </div>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>
    @if(isset($_GET['batch_id']) && isset($_GET['course_id']))
        <div class="row mt-5">
            <div class="col-md-12">
                <div class="card card-body">
                    <table class="table table-bordered table-striped">
                        <thead>
                        <th>#</th>
                        <th width="20px">Attendance</th>
                        <th>Student Name</th>
                        <th>Student Roll</th>
                        </thead>
                        <tbody>
                        @if(isset($items) && count($items) != 0 )
                            <form action="{{route('teacher.attendance.submit')}}" onsubmit="return checkFillable()" method="post">
                                @csrf
                                @php $i=1; @endphp
                                @foreach($items as $item)
{{--                                    @if($item->student && $item->student->student_status_id ==1)--}}
                                        <tr>
                                            <td>{{$i++}}</td>
                                            <td width="20px">
                                                <div class="form-check" style="align-items: center">
                                                    <input class="form-check-input" type="checkbox" name="student_id[]" value="{{$item->student_id}}"
                                                           id="flexCheckDefault" style="height: 15px; width: 15px; margin: 0 20%" checked>
                                                </div>
                                            </td>
                                            <td>{{$item->student->student_name ?? ''}}</td>
                                            <td>{{$item->branchStudent->student_roll ?? ''}}</td>
                                        </tr>
{{--                                    @endif--}}
                                @endforeach
                                <input type="hidden" name="course_id" value="{{$_GET['course_id']}}">
                                <input type="hidden" name="batch_id" value="{{$_GET['batch_id']}}">
                                <input type="hidden" id="class_schedule" name="schedule_id">
                                <input type="hidden" id="date" name="date" value="{{date('Y-m-d')}}">
                                <input type="hidden" id="total_student" name="total_student" value="{{count($items)}}">
                                <tr>

                                    <td colspan="4" style="" class="text-center">
                                        @if($i > 1)
                                            <div style="display: flex; flex-wrap: wrap; justify-content: space-around">

                                                <button type="submit" id="submitBtn" onclick="" class="btn btn-primary">Save Attendance</button>
                                            </div>
                                        @else
                                            <span >No Student Found</span>
                                        @endif

                                    </td>

                                </tr>
                            </form>
                        @else
                            <td colspan="4" class="text-center">No Student Found</td>
                        @endif
                        </tbody>
                    </table>

                </div>
            </div>
        </div>
    @endif

@endsection
@push('script')
    <script>
        function changeDate(){
            var date = jQuery('#exam_date').val();
            jQuery('#date').val(date);
            console.log(jQuery('#date').val());
        }
        function checkFillable() {
            var batch_id = jQuery('#batch_id').val();
            var course_id = jQuery('#course').val();
            var schedule_id = jQuery('#schedule_id').val();
            console.log(schedule_id);
            if(course_id == ''  || batch_id == '' || schedule_id== ''){
                alert('Please Select Course, Batch & Schedule!!');
                return false;
            }
        }
    </script>
    <script>
        jQuery(document).ready(function () {
            // alert();
            jQuery('#course').change(function () {
                var course_id = jQuery('#course').val();
                jQuery('#batch_id').empty()
                if(course_id != ''){
                    jQuery.ajax({
                        method: 'GET',
                        url: '{{route('get-batch-by-course')}}',
                        data: {
                            course_id: course_id,
                        },
                        success:function (data) {
                            console.log(data);
                            jQuery('#batch_id').empty();
                            var html = `<option>Select Batch</option>`
                            jQuery.each(data, function (key, data) {
                                html += `<option value="${data.id}">${data.batch_name} (${data.time})</option>`;
                            })

                            jQuery('#batch_id').append(html);
                        }
                    })
                }
            });
        })
    </script>
    <script>
        jQuery('#schedule_id').change(function () {
            var schedule = jQuery('#schedule_id').val();
            jQuery('#class_schedule').val(schedule);
        })
    </script>
@endpush
