@extends('admin.master')
@section('title')
    @isset($item)Edit @else Add @endisset Course Category
@endsection
@section('content')
    <div class="card">
        <div class="card-header text-center">
            <h2><strong> @isset($item)Edit @else Add @endisset Course Category Form</strong></h2>
        </div>
        <div class="card-body card-block">
            <form action="@isset($item){{route('admin.course.category.update')}}@else{{route('admin.course.category.submit')}}@endisset" method="post" enctype="multipart/form-data">
                @csrf
                <input type="hidden" name="id" value="@isset($item){{$item->id}}@endisset">
                <div class="row mb-3">
                    <div class="form-group col-md-12"><label for="company" class=" form-control-label">Name
                            <span class="text-danger">*</span></label>
                        <input type="text" name="name" id="company" class="form-control @error('name') is-invalid @enderror"
                               value="@isset($item){{$item->name}}@else{{old('name')}}@endisset" required>
                        @error('name')
                        <div class="invalid-feedback" role="alert">{{$message}}</div>
                        @enderror
                    </div>
                </div>
                <div class="row mb-3">
                    <div class="form-group col-md-12"><label for="company" class=" form-control-label">Image
                            <span class="text-danger">*</span></label>
                        <input type="file" name="image" id="company" class="form-control @error('image') is-invalid @enderror" @isset($item) @else required @endisset>
                        @isset($item)
                            <img src="{{asset($item->image)}}" height="100px" width="100px" class="mt-2" alt="">
                        @endisset
                        @error('image')
                        <div class="invalid-feedback" role="alert">{{$message}}</div>
                        @enderror
                    </div>
                    <div class="form-group col-md-3">
                        <label for="" class="form-control-label">Status</label>
                        <div class="form-check">
                            <input class="form-check-input" value="1" type="radio" name="status" id="flexRadioDefault1" checked>
                            <label class="form-check-label" for="flexRadioDefault1">
                                Active
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" value="0" type="radio" name="status" id="flexRadioDefault2" @isset($item){{$item->status == 0 ? 'checked':''}}@endisset>
                            <label class="form-check-label" for="flexRadioDefault2">
                                Inactive
                            </label>
                        </div>
                    </div>

                </div>
                    <div class="form-group col-md-12">
                        <label for="" class="form-control-label"></label>
                        <button type="submit" class="btn btn-primary form-control">@isset($item)Update @else Add @endisset Course Category</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
@push('script')
    <script>
        jQuery(document).ready(function(){
            var counter=0;

            jQuery('#addSubjectBtn').click(function(){
                counter ++;
                const inputField = jQuery('<input>').attr({
                    type:'text',
                    name: 'modules[]',
                    class: 'form-control mb-2',
                    placeholder: 'Enter Module Name'
                });

                jQuery('#subject-container').append(inputField);
            });
        });
    </script>
@endpush
