@extends('admin.master')
@section('title')
    Course List
@endsection
@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">

                    <div class="row">
                        <div class="col-md-10">
                            <h4 class="text-center text-success">{{session('message')}}</h4>
                            <h3 class="text-center"><strong>View Course FAQs</strong></h3>
                        </div>
                        <div class="col-md-2">
                            <a href="{{route('admin.course.faq.add')}}" class="float-right btn btn-primary">Add FAQ</a>
                        </div>
                    </div>

                    <hr>
                    {{-- <form action="" id="filterForm">
                        <div class="row mb-3">
                            <div class="form-group col-sm-5"><label for="" class="form-control-label">Status</label>
                                <select name="course_status_id" onchange="filter()" id="" class="form-control">
                                    <option value="">All</option>
                                    <option value="1" @isset($_GET['course_status_id']){{$_GET['course_status_id'] == '1' ? 'selected':''}}@endisset>Active</option>
                                    <option value="0" @isset($_GET['course_status_id']){{$_GET['course_status_id'] == '0' ? 'selected':''}}@endisset>Inactive</option>
                                </select>

                            </div>
                            <div class="form-group col-sm-5"><label for="" class="form-control-label">Course Type</label>
                                <select name="course_type" onchange="filter()" id="" class="form-control">
                                    <option value="">All</option>
                                    <option value="online"
                                    @isset($_GET['course_type']){{$_GET['course_type'] == 'online' ? 'selected':''}}@endisset>
                                        Offline</option>
                                    <option value="offline" @isset($_GET['course_type']){{$_GET['course_type'] == 'offline' ? 'selected':''}}@endisset
                                    >Online</option>
                                </select>
                            </div>

                        </div>

                    </form> --}}
                </div>
                <div class="card-body">
                    <table class="table table-striped">
                        <tr>
                            <th>#</th>
                            <th>Course Name<br><span class="second-line">Course Name</span></th>
                            <th>Fee<br><span class="second-line">Total FAQs</span></th>
                            <th>Action</th>
                        </tr>
                        @php $i=1; @endphp
                        @foreach($items as $item)
                        @php
                            $total_faq = countFaq($item->course_id);
                        @endphp
                            <tr>
                                <td>{{$i++}}</td>
                                <td>{{$item->course->course_name ?? ''}}</td>
                                <td>{{$total_faq ?? '0'}}</td>


                                <td class="btn-group">
                                    <a href="{{route('admin.course.faq.edit', ['id'=>$item->course_id])}}" title="Details" class="btn btn-primary"><i class="fa fa-info"></i></a>
                                    <form action="{{route('admin.course.faq.remove')}}" onclick="return confirm('Please Confirm Before Deleting it!!')" method="post">
                                        @csrf
                                        <input type="hidden" name="id" value="{{$item->course_id}}">
                                        <button type="submit" title="Remove" class="btn btn-danger" style="margin-left: 5px"><i class="fa fa-trash"></i></button>
                                    </form>

                                </td>
                            </tr>
                        @endforeach
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection
