@extends('admin.master')
@section('title')
    @isset($item)Edit @else Add @endisset Course FAQ
@endsection
@section('content')

    <div class="card">
        <div class="card-header text-center">
            <h2><strong> @isset($item)Edit @else Add @endisset Course FAQ Form</strong></h2>
        </div>
        <div class="card-body card-block">
            <form action="@isset($item){{route('admin.course.faq.update')}}@else{{route('admin.course.faq.submit')}}@endisset" method="post" >
                @csrf
                <input type="hidden" name="id" value="@isset($item){{$course_id}}@endisset">
                <input type="hidden" id="faq_count" value="@isset($item){{count($item)}}@endisset">
                <div class="row mb-3">
                    <div class="form-group col-md-12"><label for="company" class=" form-control-label">Course Name
                            <span class="text-danger">*</span></label>
                        <select name="course_id" class="form-control @error('course_id') is-invalid @enderror" required>
                            <option value="">Select Course</option>
                            @foreach($courses as $course)
                                <option value="{{$course->id}}" @isset($item){{$course_id == $course->id ? 'selected':''}}@endisset>{{$course->course_name}}</option>
                            @endforeach
                        </select>
                        @error('course_name')
                        <div class="invalid-feedback" role="alert">{{$message}}</div>
                        @enderror
                    </div>
                </div>
                @isset($item)
                @foreach($item as $key=> $query)
                    <div id="query{{ $key }}">
                        <div class="row mb-3">
                            <div class="form-group col-md-12"><label for="company" class=" form-control-label">Question
                                <span class="text-danger">*</span> <a class="btn btn-danger" onclick="removeFaq({{ $key }})"><i class="fa fa-minus"></i></a></label>
                                <input type="text" name="question[]" id="company" class="form-control @error('question') is-invalid @enderror"
                                    value="{{ $query->question }}" required>
                                @error('question')
                                <div class="invalid-feedback" role="alert">{{$message}}</div>
                                @enderror
                            </div>

                        </div>

                        <div class="row mb-3">
                            <div class="form-group col-md-12"><label for="" class="form-control-label">Answer</label>
                                <textarea name="answer[]" id="" cols="30" rows="10" class="form-control">{{ $query->answer }}</textarea>
                            </div>
                        </div>
                    </div>

                @endforeach
                @else
                    <div id="query0">
                        <div class="row mb-3">
                            <div class="form-group col-md-12"><label for="company" class=" form-control-label">Question
                                <span class="text-danger">*</span> </label>
                                <input type="text" name="question[]" id="company" class="form-control @error('question') is-invalid @enderror"
                                    value="" required>
                                @error('question')
                                <div class="invalid-feedback" role="alert">{{$message}}</div>
                                @enderror
                            </div>

                        </div>

                        <div class="row mb-3">
                            <div class="form-group col-md-12"><label for="" class="form-control-label">Answer</label>
                                <textarea name="answer[]" id="" cols="30" rows="10" class="form-control"></textarea>
                            </div>
                        </div>
                    </div>

                @endisset
                <div id="faq-container">
                </div>
                <div class="row mb-3">
                    <div class="form-group col-md-12">
                        <label for="" class="form-control-label"></label>
                        <button type="button" id="addFaqBtn" class="btn btn-success">Add More Question</button>
                    </div>
                </div>
                <div class="row mb-3">
                    <div class="form-group col-md-12">
                        <label for="" class="form-control-label"></label>
                        <button type="submit" class="btn btn-primary form-control">@isset($item)Update @else Add @endisset Course FAQ</button>
                    </div>
                </div>
            </div>

            </form>
        </div>
    </div>
@endsection
@push('script')

    <script>
        jQuery(document).ready(function(){
            var counter = 0;
            if(jQuery('#faq_counter').val() != null){
                var counter=jQuery('#faq_counter').val();
            }


           jQuery('#addFaqBtn').click(function(){

               counter ++;
               var html = `<div id="query${counter}">
                <div class="row mb-3">
                    <div class="form-group col-md-12"><label for="company" class=" form-control-label">Question
                        <span class="text-danger">*</span><a class="btn btn-danger" onclick="removeFaq(${counter})"><i class="fa fa-minus text-white"></i></a></label>
                        <input type="text" name="question[]" id="company" class="form-control @error('question') is-invalid @enderror"
                               value="" required>
                        @error('question')
                        <div class="invalid-feedback" role="alert">{{$message}}</div>
                        @enderror
                    </div>

                </div>

                <div class="row mb-3">
                    <div class="form-group col-md-12"><label for="" class="form-control-label">Answer</label>
                        <textarea name="answer[]" id="" cols="30" rows="10" class="form-control"></textarea>
                    </div>
                </div>
                </div>`
               ;

               jQuery('#faq-container').append(html);
            });
        });
    </script>
    <script>
        function removeFaq(id){
            
            jQuery('#query'+id).empty();
        }
    </script>

@endpush

