@extends('admin.master')
@section('title')
'Page Content Edit'
@endsection
@section('content')
<div class="row mt-1">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header text-center">
                <h2>Edit Page Content</h2>
                <h4 class="text-success mt-1">{{session('message')}}</h4>
            </div>
            <div class="card-body">
                <form action="{{route('admin.content.update')}}" method="post" enctype="multipart/form-data">
                    @csrf
                    <div>
                        @foreach ($items as $counter=> $item)
                        <div class="row mb-3">
                            <div class="col-md-12 form-group"><label for="" class="form-control-label fw-bold">{{ str_replace('_', ' ', Str::title($item->key)) }}</label>
                                @if(Str::contains($item->key, 'image'))
                                    <input type="file" class="form-control" name="{{$item->key}}">
                                    @if($item->value != null)
                                        <img class="mt-4" src="{{asset($item->value)}}" alt="" width="150px">
                                        @endif
                                @elseif(Str::contains($item->key, 'video'))
                                    <input type="text" class="form-control" name="{{$item->key}}" value="{{$item->value}}" placeholder="Enter URL">
                                @elseif(Str::contains($item->key, 'title'))
                                    <input type="text" class="form-control" name="{{$item->key}}" value="{{$item->value}}" placeholder="Enter Title">
                                @else
                                    <textarea rows="3" name="{{ $item->key }}" cols="10" class="form-control summernote " >@if(isset($item)){{$item->value}} @else {{old('description')}} @endif</textarea>
                                @endif
                            </div>
                        </div>
                        @endforeach
                    </div>
                    <div class="row mb-3">
                        <div class="col-md-12 form-group">
                            <button class="form-control btn btn-primary" type="submit">Update Content</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
@push('script')

<link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.js"></script>
<script>
    jQuery(document).ready(function() {
        jQuery('.summernote').summernote();
  });
</script>
@endpush