@extends('admin.master')
@section('title')
    Batch List
@endsection
@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">

                    <div class="row">
                        <div class="col-md-10">
                            <h4 class="text-center text-success">{{session('message')}}</h4>
                            <h3 class="text-center"><strong>View Batch List</strong></h3>
                        </div>
                        <div class="col-md-2">
                            <a href="{{route('batch.add')}}" class="float-right btn btn-primary">Add Batch</a>
                        </div>
                    </div>

                    <hr>
                    <form action="" id="filterForm">
                        <div class="row mb-3">
                            <div class="form-group col-sm-5"><label for="" class="form-control-label">Course</label>
                                <select name="course_id" onchange="filter()" id="" class="form-control">
                                    <option value="">All</option>
                                    @foreach($courses as $course)
                                        <option value="{{$course->id}}" @isset($_GET['course_id']){{$_GET['course_id'] == $course->id ? 'selected':''}}@endisset>{{$course->course_name}}</option>
                                    @endforeach
                                </select>

                            </div>
                            <div class="form-group col-sm-5"><label for="" class="form-control-label">Teacher</label>
                                <select name="teacher_id" onchange="filter()" id="" class="form-control">
                                    <option value="">All</option>
                                    @foreach($teachers as $teacher)
                                        <option value="{{$teacher->id}}"
                                        @isset($_GET['teacher_id']){{$_GET['teacher_id'] == $teacher->id ? 'selected':''}}@endisset>
                                            {{$teacher->name}}</option>
                                    @endforeach

                                </select>
                            </div>

                        </div>

                    </form>
                </div>
                <div class="card-body">
                    <table class="table table-striped">
                        <tr>
                            <th>#</th>
                            <th>Batch Name</th>
                            <th>Branch Name</th>
                            <th>Course Name<br><span class="second-line">Session Name</span></th>
                            <th>Assigned Teacher</th>
                            <th>Total Student / <br> Max Students</th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                        @php $i=1; @endphp
                        @foreach($items as $item)
                            <tr>
                                <td>{{$i++}}</td>
                                <td>{{$item->batch_name}}</td>
                                <td>{{$item->branch->branch_name ?? ''}}</td>
                                <td>{{$item->course->course_name ?? ''}}<br><span>{{$item->session->session_name ?? ''}}</span></td>
                                <td>{{$item->teacher->name}}</td>
                                @php $total_student = \App\Models\CourseEnrollment::where('batch_id', $item->id)->where('status', 1)->count() @endphp
                                <td>{{count(getStudentsByBatchId($item->id))}}/<span>{{$item->max_student}}</span></td>

                                <td class="text-center">
                                    <div class="mb-2">
                                        <span class="{{$item->status == 1 || $item->status == 3 ? 'bg-success':'bg-danger'}} p-2 text-white" style="border-radius:5px">
                                    @if($item->status == 1)
                                        Active
                                            @elseif($item->status == 3)
                                        Completed
                                            @else
                                        Inactive
                                    @endif
                                        </span>
                                    </div>
                                </td>

                                <td class="btn-group">
                                    <a href="{{route('batch.edit', ['id'=>$item->id])}}" title="Edit" class="btn btn-primary"><i class="fa fa-pencil"></i></a>
                                    <form action="{{route('batch.remove')}}" onclick="return confirm('Please Confirm Before Deleting it!!')" method="post">
                                        @csrf
                                        <input type="hidden" name="id" value="{{$item->id}}">
                                        <button type="submit" title="Remove" class="btn btn-danger" style="margin-left: 5px"><i class="fa fa-trash"></i></button>
                                    </form>

                                </td>
                            </tr>
                        @endforeach
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection
