<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('course_enrollments', function (Blueprint $table) {
            $table->integer('branch_id')->after('course_id')->nullable();
            $table->string('student_roll')->after('student_id')->nullable();
            $table->string('student_registration')->after('student_id')->nullable();
            $table->string('course_type')->after('course_id')->nullable()->comment('online, offline');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('course_enrollments', function (Blueprint $table) {
            $table->integer('branch_id')->after('course_id')->nullable();
            $table->string('student_roll')->after('student_id')->nullable();
            $table->string('student_registration')->after('student_id')->nullable();
            $table->string('course_type')->after('course_id')->nullable()->comment('online, offline');
        });
    }
};
