<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('certificates', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('father_name')->nullable();
            $table->string('mother_name')->nullable();
            $table->string('student_roll');
            $table->string('student_registration_num');
            $table->string('course_name');
            $table->string('batch_name');
            $table->date('start_date');
            $table->date('end_date');
            $table->string('grade')->nullable();
            $table->string('teacher_name')->nullable();
            $table->string('serial_num');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('certificates');
    }
};
