<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('course_enrollments', function (Blueprint $table) {
            $table->tinyInteger('certificate_provided')->after('status')->default(0)->comment('1=>Yes, 0=>No');
            $table->date('certificate_provided_date')->after('certificate_provided')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('course_enrollments', function (Blueprint $table) {
            $table->tinyInteger('certificate_provided')->after('status')->default(0)->comment('1=>Yes, 0=>No');
            $table->date('certificate_provided_date')->after('certificate_provided')->nullable();
        });
    }
};
