<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('coupons', function (Blueprint $table) {
            $table->id();
            $table->string('coupon_code',50)->nullable();
            $table->unsignedTinyInteger('discount_type')->default(1)->comment('1=>Fixed Amount, 0=>Percent');
            $table->string('discount')->nullable();
            $table->string('limit_per_user')->nullable();
            $table->string('total_use_limit')->nullable();
            $table->date('expire_date')->nullable();
            $table->unsignedTinyInteger('type')->default(1)->comment('1=>All Customers, 0=>Specific Customer');
            $table->string('user_id')->nullable();
            $table->text('description')->nullable();
            $table->unsignedTinyInteger('status')->default(1)->comment('1=>Active, 0=> Inactive');


            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('coupons');
    }
};
