<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('testimonials', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('profession')->default('Student');
            $table->integer('student_id')->nullable();
            $table->integer('teacher_id')->nullable();
            $table->integer('course_id')->nullable();
            $table->text('description');
            $table->text('image')->nullable();
            $table->tinyInteger('status')->default(0)->comment('1=>Active, 2=>Inactive');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('testimonials');
    }
};
