<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('course_enrollments', function (Blueprint $table) {
            $table->id();
            $table->integer('student_id');
            $table->integer('course_id');
            $table->integer('session_id');
            $table->string('payment_method');
            $table->string('payment_number');
            $table->decimal('total_fee', 10,2);
            $table->decimal('total_paid', 10,2);
            $table->decimal('discount', 10, 2);
            $table->integer('due', 10, 2);
            $table->integer('completed_content');
            $table->decimal('total_content');
            $table->tinyInteger('status')->default(0)->comment('1=>Active, 0=>Inactive');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('course_enrollments');
    }
};
