<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class Webinar extends Model
{
    use HasFactory;

    private static $webiner;

    public static function addOrUpdate($request)
    {
//        dd($request);
        for($i=1; $i<=$request->webinar_counter; $i++){
            $title = 'title_'.$i;
            $date = 'date_'.$i;
            $time = 'time_'.$i;
            $price = 'price_'.$i;
            $topic = 'topic_'.$i;
            $type = 'type_'.$i;
            $guest = 'guest_'.$i;
            $link = 'link_'.$i;
            $address = 'address_'.$i;
            $status = 'status_'.$i;
            if(isset($request->$date)){
                self::$webiner = new Webinar();
                $slug = Str::slug($request->$title); // Convert sentence to slug with hyphens
                $randomNumber = rand(1000, 9999); // Generate random number
                self::$webiner->course_id   = $request->course_id;
                self::$webiner->title       = $request->$title;
                self::$webiner->type        = $request->$type;
                self::$webiner->link        = $request->$link;
                self::$webiner->location    = $request->$address;
                self::$webiner->guest       = $request->$guest;
                self::$webiner->date        = $request->$date;
                self::$webiner->time        = $request->$time;
                self::$webiner->price       = $request->$price ?? 0;
                self::$webiner->slug        = $slug.$randomNumber;
                self::$webiner->status      = $request->$status ?? 0;
                self::$webiner->save();
                WebinarTopic::add($request->$topic, self::$webiner->id);
            }
        }

    }
    public static function valueUpdate($request)
    {
//        dd($request);
        self::$webiner = Webinar::find($request->id);
        if($request->title_1 != self::$webiner->title){
            $slug = Str::slug($request->title_1); // Convert sentence to slug with hyphens
            $randomNumber = rand(1000, 9999); // Generate random number
            $slug = $slug.$randomNumber;
        }
        else{
            $slug = self::$webiner->slug;
        }
        self::$webiner->course_id   = $request->course_id;
        self::$webiner->title       = $request->title_1;
        self::$webiner->type        = $request->type_1;
        self::$webiner->link        = $request->link_1;
        self::$webiner->location    = $request->address_1;
        self::$webiner->guest       = $request->guest_1;
        self::$webiner->date        = $request->date_1;
        self::$webiner->time        = $request->time_1;
        self::$webiner->price       = $request->price ?? 0;
        self::$webiner->slug        = $slug;
        self::$webiner->status      = $request->status_1 ?? 0;
        self::$webiner->save();
        return self::$webiner;
    }

    public static function remove($id)
    {
        Webinar::where('id', $id)->delete();
    }


    public function course()
    {
        return $this->belongsTo(Course::class, 'course_id');
    }

    public function topic()
    {
        return $this->hasMany(WebinarTopic::class, 'id','webinar_id');
    }
}
