<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class Offer extends Model
{
    private static $offer;
    use HasFactory;
    public static function addOrUpdate($request, $coupon_id){
//        dd($request->status);
        $array = [];
        if(Offer::find($request->id)){
            self::$offer = Offer::find($request->id);
        }

        else{
            self::$offer = new Offer();
            $slug = Str::slug($request->title); // Convert sentence to slug with hyphens
            $randomNumber = rand(1000, 9999);
            self::$offer->slug = $slug.'-'.$randomNumber;
        }
        self::$offer->title          = $request->title;
        self::$offer->description    = $request->description;
        self::$offer->start_date     = $request->start_date;
        self::$offer->end_date       = $request->end_date;
        self::$offer->coupon_id = $coupon_id;

        foreach ($request->course_ids as $course_id) {
            array_push($array, $course_id);
        }
        self::$offer->course_ids = json_encode($array);
        self::$offer->status     = $request->status;
        if ($request->file('image')) {
            if (self::$offer->image) {
                if (file_exists(self::$offer->image)) {
                    unlink(self::$offer->image);
                }
                self::$offer->image = self::saveImageUrl($request);
            } else {
                self::$offer->image = self::saveImageUrl($request);
            }
        }

        self::$offer->save();
    }

    public static function remove($id){
        self::$offer = Offer::find($id);
        if(self::$offer->image){
            unlink(self::$offer->image);
        }
        self::$offer->delete();
    }

    private static function saveImageUrl($request){
        $image = $request->file('image');
        $imageName = date('ymdhis'). uniqid(). '.' . $image->extension();
        $directory = 'uploads/offers/';
        $imageUrl = $directory.$imageName;
        $image->move($directory, $imageName);

        return $imageUrl;
    }

    public function coupon()
    {
        return $this->belongsTo(Coupon::class, 'coupon_id');
    }
}
