<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;

use function PHPUnit\Framework\fileExists;

class LearningContent extends Model
{
    use HasFactory;
    private static $content;

    public static function add($request, $course_id){
        if(isset($request->outcomes)){

            for($i= 0; $i< count($request->outcomes); $i++){
                self::$content = new LearningContent();
            self::$content->course_id = $course_id;
            self::$content->topic = 'course_outcome';
            self::$content->content = $request->outcomes[$i];
            self::$content->save();
            }

        }
        if(isset($request->software_name)){

            for($i= 0; $i< count($request->software_name); $i++){
                self::$content = new LearningContent();
            self::$content->course_id = $course_id;
            self::$content->topic = 'software_learning';
            self::$content->content = $request->software_name[$i];
            self::$content->image = self::saveImgUrl($request->software_image[$i],$request->software_name[$i]);
            self::$content->save();
            }

        }
    }

    public static function change($request)
    {
        // dd($request);
        if(isset($request->softwareCheck) && count($request->softwareCheck) > 0){
            foreach(LearningContent::where('course_id', $request->id)->where('topic', 'software_learning')->get() as $resource){
                if(in_array($resource->id, $request->softwareCheck)){

                }
                else{
                    if (file_exists($resource->resource)) {
                        unlink($resource->resource);
                    }
                    $resource->delete();
                }
            }
        }
        else{
            foreach(LearningContent::where('course_id', $request->id)->where('topic', 'software_learning')->get() as $resource){
                if(fileExists($resource->image)){
                    unlink($resource->image);
                }
                $resource->delete();
            }
        }
        LearningContent::where('course_id', $request->id)->where('topic', 'course_outcome')->delete();
        self::add($request, $request->id);
    }

    private static function saveImgUrl($file, $softwareName)
    {

        $fileName = $softwareName . '-' . rand(1000, 9999) . '.' . $file->extension();
        $directory = 'uploads/course-softwares/';
        $filePath = $directory . $fileName;

        // Ensure the directory exists
        if (!Storage::exists($directory)) {
            Storage::makeDirectory($directory);
        }

        // Move the file to the specified directory
        $file->move(public_path($directory), $fileName);

        return $filePath;
    }

    public static function remove($id){
        foreach (LearningContent::where('course_id', $id)->where('topic', 'software_learning')->get() as $item){
            if(fileExists($item->image)){
                unlink($item->image);
            }
        }
        self::$content= LearningContent::where('course_id', $id)->delete();
    }
}
